/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.spark.transform.analysis.histogram;

import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.List;
import org.apache.spark.api.java.function.Function2;
import org.datavec.api.transform.ColumnType;
import org.datavec.api.transform.schema.Schema;
import org.datavec.api.writable.Writable;
import org.datavec.spark.transform.analysis.histogram.DoubleHistogramCounter;
import org.datavec.spark.transform.analysis.histogram.HistogramCounter;
import org.datavec.spark.transform.analysis.histogram.StringHistogramCounter;

public class HistogramAddFunction
implements Function2<List<HistogramCounter>, List<Writable>, List<HistogramCounter>> {
    private final int nBins;
    private final Schema schema;
    private final double[][] minsMaxes;

    public List<HistogramCounter> call(List<HistogramCounter> histogramCounters, List<Writable> writables) throws Exception {
        int size;
        int i;
        if (histogramCounters == null) {
            histogramCounters = new ArrayList<HistogramCounter>();
            List columnTypes = this.schema.getColumnTypes();
            i = 0;
            for (ColumnType ct : columnTypes) {
                switch (ct) {
                    case String: {
                        histogramCounters.add(new StringHistogramCounter((int)this.minsMaxes[i][0], (int)this.minsMaxes[i][1], this.nBins));
                        break;
                    }
                    case Integer: {
                        histogramCounters.add(new DoubleHistogramCounter(this.minsMaxes[i][0], this.minsMaxes[i][1], this.nBins));
                        break;
                    }
                    case Long: {
                        histogramCounters.add(new DoubleHistogramCounter(this.minsMaxes[i][0], this.minsMaxes[i][1], this.nBins));
                        break;
                    }
                    case Double: {
                        histogramCounters.add(new DoubleHistogramCounter(this.minsMaxes[i][0], this.minsMaxes[i][1], this.nBins));
                        break;
                    }
                    case Categorical: {
                        histogramCounters.add(null);
                        break;
                    }
                    case Time: {
                        histogramCounters.add(new DoubleHistogramCounter(this.minsMaxes[i][0], this.minsMaxes[i][1], this.nBins));
                        break;
                    }
                    case Bytes: {
                        histogramCounters.add(null);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown column type: " + ct);
                    }
                }
                ++i;
            }
        }
        if ((size = histogramCounters.size()) != writables.size()) {
            throw new IllegalStateException("Writables list and number of counters does not match (" + writables.size() + " vs " + size + ")");
        }
        for (i = 0; i < size; ++i) {
            HistogramCounter hc = histogramCounters.get(i);
            if (hc == null) continue;
            hc.add(writables.get(i));
        }
        return histogramCounters;
    }

    @ConstructorProperties(value={"nBins", "schema", "minsMaxes"})
    public HistogramAddFunction(int nBins, Schema schema, double[][] minsMaxes) {
        this.nBins = nBins;
        this.schema = schema;
        this.minsMaxes = minsMaxes;
    }
}

