/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.spark.transform.quality.longq;

import java.beans.ConstructorProperties;
import org.apache.spark.api.java.function.Function2;
import org.datavec.api.transform.metadata.LongMetaData;
import org.datavec.api.transform.quality.columns.LongQuality;
import org.datavec.api.writable.NullWritable;
import org.datavec.api.writable.Text;
import org.datavec.api.writable.Writable;

public class LongQualityAddFunction
implements Function2<LongQuality, Writable, LongQuality> {
    private final LongMetaData meta;

    public LongQuality call(LongQuality v1, Writable writable) throws Exception {
        long valid = v1.getCountValid();
        long invalid = v1.getCountInvalid();
        long countMissing = v1.getCountMissing();
        long countTotal = v1.getCountTotal() + 1L;
        long nonLong = v1.getCountNonLong();
        if (this.meta.isValid(writable)) {
            ++valid;
        } else if (writable instanceof NullWritable || writable instanceof Text && (writable.toString() == null || writable.toString().isEmpty())) {
            ++countMissing;
        } else {
            ++invalid;
        }
        String str = writable.toString();
        try {
            Long.parseLong(str);
        }
        catch (NumberFormatException e) {
            ++nonLong;
        }
        return new LongQuality(valid, invalid, countMissing, countTotal, nonLong);
    }

    @ConstructorProperties(value={"meta"})
    public LongQualityAddFunction(LongMetaData meta) {
        this.meta = meta;
    }
}

