/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.spark.transform.utils;

import java.beans.ConstructorProperties;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.function.Function;
import org.datavec.api.writable.Writable;
import org.datavec.spark.transform.misc.WritablesToStringFunction;

public class SparkExport {
    public static void exportCSVSpark(String directory, String delimiter, int outputSplits, JavaRDD<List<Writable>> data) {
        JavaRDD lines = data.map((Function)new WritablesToStringFunction(delimiter));
        lines.coalesce(outputSplits);
        lines.saveAsTextFile(directory);
    }

    public static void exportCSVLocal(File outputFile, String delimiter, JavaRDD<List<Writable>> data, int rngSeed) throws Exception {
        JavaRDD lines = data.map((Function)new WritablesToStringFunction(delimiter));
        ArrayList linesList = lines.collect();
        if (!(linesList instanceof ArrayList)) {
            linesList = new ArrayList(linesList);
        }
        Collections.shuffle(linesList, new Random(rngSeed));
        FileUtils.writeLines((File)outputFile, linesList);
    }

    public static void exportCSVLocal(String outputDir, String baseFileName, int numFiles, String delimiter, JavaRDD<List<Writable>> data, int rngSeed) throws Exception {
        JavaRDD lines = data.map((Function)new WritablesToStringFunction(delimiter));
        double[] split = new double[numFiles];
        for (int i = 0; i < split.length; ++i) {
            split[i] = 1.0 / (double)numFiles;
        }
        JavaRDD[] splitData = lines.randomSplit(split);
        int count = 0;
        Random r = new Random(rngSeed);
        for (JavaRDD subset : splitData) {
            String path = FilenameUtils.concat((String)outputDir, (String)(baseFileName + count++ + ".csv"));
            ArrayList linesList = subset.collect();
            if (!(linesList instanceof ArrayList)) {
                linesList = new ArrayList(linesList);
            }
            Collections.shuffle(linesList, r);
            FileUtils.writeLines((File)new File(path), linesList);
        }
    }

    public static void exportCSVLocal(String outputDir, String baseFileName, int numFiles, String delimiter, JavaRDD<List<Writable>> data) throws Exception {
        JavaRDD lines = data.map((Function)new WritablesToStringFunction(delimiter));
        double[] split = new double[numFiles];
        for (int i = 0; i < split.length; ++i) {
            split[i] = 1.0 / (double)numFiles;
        }
        JavaRDD[] splitData = lines.randomSplit(split);
        int count = 0;
        for (JavaRDD subset : splitData) {
            String path = FilenameUtils.concat((String)outputDir, (String)(baseFileName + count++ + ".csv"));
            List linesList = subset.collect();
            FileUtils.writeLines((File)new File(path), (Collection)linesList);
        }
    }

    public static void exportStringLocal(File outputFile, JavaRDD<String> data, int rngSeed) throws Exception {
        ArrayList linesList = data.collect();
        if (!(linesList instanceof ArrayList)) {
            linesList = new ArrayList(linesList);
        }
        Collections.shuffle(linesList, new Random(rngSeed));
        FileUtils.writeLines((File)outputFile, linesList);
    }

    public static void exportCSVSequenceLocal(File baseDir, JavaRDD<List<List<Writable>>> sequences, long seed) throws Exception {
        baseDir.mkdirs();
        if (!baseDir.isDirectory()) {
            throw new IllegalArgumentException("File is not a directory: " + baseDir.toString());
        }
        String baseDirStr = baseDir.toString();
        ArrayList fileContents = sequences.map((Function)new SequenceToStringFunction(",")).collect();
        if (!(fileContents instanceof ArrayList)) {
            fileContents = new ArrayList(fileContents);
        }
        Collections.shuffle(fileContents, new Random(seed));
        int i = 0;
        for (String s : fileContents) {
            String path = FilenameUtils.concat((String)baseDirStr, (String)(i + ".csv"));
            File f = new File(path);
            FileUtils.writeStringToFile((File)f, (String)s);
            ++i;
        }
    }

    public static void exportCSVSequenceLocalNoShuffling(File baseDir, JavaRDD<List<List<Writable>>> sequences) throws Exception {
        SparkExport.exportCSVSequenceLocalNoShuffling(baseDir, sequences, "", ",", "csv");
    }

    public static void exportCSVSequenceLocalNoShuffling(File baseDir, JavaRDD<List<List<Writable>>> sequences, String delimiter, String filePrefix, String fileExtension) throws Exception {
        baseDir.mkdirs();
        if (!baseDir.isDirectory()) {
            throw new IllegalArgumentException("File is not a directory: " + baseDir.toString());
        }
        String baseDirStr = baseDir.toString();
        ArrayList fileContents = sequences.map((Function)new SequenceToStringFunction(delimiter)).collect();
        if (!(fileContents instanceof ArrayList)) {
            fileContents = new ArrayList(fileContents);
        }
        int i = 0;
        for (String s : fileContents) {
            String path = FilenameUtils.concat((String)baseDirStr, (String)(filePrefix + "_" + i + "." + fileExtension));
            File f = new File(path);
            FileUtils.writeStringToFile((File)f, (String)s);
            ++i;
        }
    }

    private static class SequenceToStringFunction
    implements Function<List<List<Writable>>, String> {
        private final String delim;

        public String call(List<List<Writable>> sequence) throws Exception {
            StringBuilder sb = new StringBuilder();
            boolean firstTimeStep = true;
            for (List<Writable> c : sequence) {
                if (!firstTimeStep) {
                    sb.append("\n");
                }
                boolean first = true;
                for (Writable w : c) {
                    if (!first) {
                        sb.append(this.delim);
                    }
                    sb.append(w.toString());
                    first = false;
                }
                firstTimeStep = false;
            }
            return sb.toString();
        }

        @ConstructorProperties(value={"delim"})
        public SequenceToStringFunction(String delim) {
            this.delim = delim;
        }
    }
}

