/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.spark.transform.join;

import java.beans.ConstructorProperties;
import java.util.List;
import org.apache.spark.api.java.function.PairFunction;
import org.datavec.api.transform.join.Join;
import org.datavec.api.transform.schema.Schema;
import org.datavec.api.writable.Writable;
import org.datavec.spark.transform.join.JoinValue;
import scala.Tuple2;

public class MapToJoinValuesFunction
implements PairFunction<List<Writable>, String, JoinValue> {
    private boolean left;
    private Join join;

    public Tuple2<String, JoinValue> call(List<Writable> writables) throws Exception {
        String[] keyColumns;
        Schema schema;
        if (this.left) {
            schema = this.join.getLeftSchema();
            keyColumns = this.join.getKeyColumnsLeft();
        } else {
            schema = this.join.getRightSchema();
            keyColumns = this.join.getKeyColumnsRight();
        }
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String key : keyColumns) {
            int idx = schema.getIndexOfColumn(key);
            if (!first) {
                sb.append("_");
            }
            sb.append(writables.get(idx).toString());
            first = false;
        }
        return new Tuple2((Object)sb.toString(), (Object)new JoinValue(this.left, writables));
    }

    @ConstructorProperties(value={"left", "join"})
    public MapToJoinValuesFunction(boolean left, Join join) {
        this.left = left;
        this.join = join;
    }
}

