/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.spark.transform.analysis.aggregate;

import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.List;
import org.apache.spark.api.java.function.Function2;
import org.datavec.api.transform.ColumnType;
import org.datavec.api.transform.schema.Schema;
import org.datavec.api.writable.Writable;
import org.datavec.spark.transform.analysis.AnalysisCounter;
import org.datavec.spark.transform.analysis.columns.BytesAnalysisCounter;
import org.datavec.spark.transform.analysis.columns.CategoricalAnalysisCounter;
import org.datavec.spark.transform.analysis.columns.DoubleAnalysisCounter;
import org.datavec.spark.transform.analysis.columns.IntegerAnalysisCounter;
import org.datavec.spark.transform.analysis.columns.LongAnalysisCounter;
import org.datavec.spark.transform.analysis.string.StringAnalysisCounter;

public class AnalysisAddFunction
implements Function2<List<AnalysisCounter>, List<Writable>, List<AnalysisCounter>> {
    private Schema schema;

    public List<AnalysisCounter> call(List<AnalysisCounter> analysisCounters, List<Writable> writables) throws Exception {
        int size;
        if (analysisCounters == null) {
            analysisCounters = new ArrayList<AnalysisCounter>();
            List columnTypes = this.schema.getColumnTypes();
            block9: for (ColumnType ct : columnTypes) {
                switch (ct) {
                    case String: {
                        analysisCounters.add(new StringAnalysisCounter());
                        continue block9;
                    }
                    case Integer: {
                        analysisCounters.add(new IntegerAnalysisCounter());
                        continue block9;
                    }
                    case Long: {
                        analysisCounters.add(new LongAnalysisCounter());
                        continue block9;
                    }
                    case Double: {
                        analysisCounters.add(new DoubleAnalysisCounter());
                        continue block9;
                    }
                    case Categorical: {
                        analysisCounters.add(new CategoricalAnalysisCounter());
                        continue block9;
                    }
                    case Time: {
                        analysisCounters.add(new LongAnalysisCounter());
                        continue block9;
                    }
                    case Bytes: {
                        analysisCounters.add(new BytesAnalysisCounter());
                        continue block9;
                    }
                }
                throw new IllegalArgumentException("Unknown column type: " + ct);
            }
        }
        if ((size = analysisCounters.size()) != writables.size()) {
            throw new IllegalStateException("Writables list and number of counters does not match (" + writables.size() + " vs " + size + ")");
        }
        for (int i = 0; i < size; ++i) {
            analysisCounters.get(i).add(writables.get(i));
        }
        return analysisCounters;
    }

    @ConstructorProperties(value={"schema"})
    public AnalysisAddFunction(Schema schema) {
        this.schema = schema;
    }
}

