/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.spark.transform.join;

import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.List;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.datavec.api.transform.join.Join;
import org.datavec.api.writable.Writable;
import org.datavec.spark.transform.join.JoinValue;
import scala.Tuple2;

public class ExecuteJoinFlatMapFunction
implements FlatMapFunction<Tuple2<List<Writable>, Iterable<JoinValue>>, List<Writable>> {
    private Join join;

    public Iterable<List<Writable>> call(Tuple2<List<Writable>, Iterable<JoinValue>> t2) throws Exception {
        ArrayList<JoinValue> leftList = new ArrayList<JoinValue>();
        ArrayList<JoinValue> rightList = new ArrayList<JoinValue>();
        for (JoinValue jv : (Iterable)t2._2()) {
            if (jv.isLeft()) {
                leftList.add(jv);
                continue;
            }
            rightList.add(jv);
        }
        ArrayList<List<Writable>> ret = new ArrayList<List<Writable>>();
        Join.JoinType jt = this.join.getJoinType();
        switch (jt) {
            case Inner: {
                for (JoinValue jvl : leftList) {
                    for (JoinValue jvr : rightList) {
                        List joined = this.join.joinExamples(jvl.getValues(), jvr.getValues());
                        ret.add(joined);
                    }
                }
                break;
            }
            case LeftOuter: {
                for (JoinValue jvl : leftList) {
                    if (rightList.size() == 0) {
                        List joined = this.join.joinExamples(jvl.getValues(), null);
                        ret.add(joined);
                        continue;
                    }
                    for (JoinValue jvr : rightList) {
                        List joined = this.join.joinExamples(jvl.getValues(), jvr.getValues());
                        ret.add(joined);
                    }
                }
                break;
            }
            case RightOuter: {
                for (JoinValue jvr : rightList) {
                    if (leftList.size() == 0) {
                        List joined = this.join.joinExamples(null, jvr.getValues());
                        ret.add(joined);
                        continue;
                    }
                    for (JoinValue jvl : leftList) {
                        List joined = this.join.joinExamples(jvl.getValues(), jvr.getValues());
                        ret.add(joined);
                    }
                }
                break;
            }
            case FullOuter: {
                if (leftList.size() == 0) {
                    for (JoinValue jvr : rightList) {
                        List joined = this.join.joinExamples(null, jvr.getValues());
                        ret.add(joined);
                    }
                } else if (rightList.size() == 0) {
                    for (JoinValue jvl : leftList) {
                        List joined = this.join.joinExamples(jvl.getValues(), null);
                        ret.add(joined);
                    }
                } else {
                    for (JoinValue jvl : leftList) {
                        for (JoinValue jvr : rightList) {
                            List joined = this.join.joinExamples(jvl.getValues(), jvr.getValues());
                            ret.add(joined);
                        }
                    }
                }
                break;
            }
        }
        return ret;
    }

    @ConstructorProperties(value={"join"})
    public ExecuteJoinFlatMapFunction(Join join) {
        this.join = join;
    }
}

