/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.spark.transform.quality.integer;

import java.beans.ConstructorProperties;
import org.apache.spark.api.java.function.Function2;
import org.datavec.api.transform.metadata.IntegerMetaData;
import org.datavec.api.transform.quality.columns.IntegerQuality;
import org.datavec.api.writable.NullWritable;
import org.datavec.api.writable.Text;
import org.datavec.api.writable.Writable;

public class IntegerQualityAddFunction
implements Function2<IntegerQuality, Writable, IntegerQuality> {
    private final IntegerMetaData meta;

    public IntegerQuality call(IntegerQuality v1, Writable writable) throws Exception {
        long valid = v1.getCountValid();
        long invalid = v1.getCountInvalid();
        long countMissing = v1.getCountMissing();
        long countTotal = v1.getCountTotal() + 1L;
        long nonInteger = v1.getCountNonInteger();
        if (this.meta.isValid(writable)) {
            ++valid;
        } else if (writable instanceof NullWritable || writable instanceof Text && (writable.toString() == null || writable.toString().isEmpty())) {
            ++countMissing;
        } else {
            ++invalid;
        }
        String str = writable.toString();
        try {
            Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            ++nonInteger;
        }
        return new IntegerQuality(valid, invalid, countMissing, countTotal, nonInteger);
    }

    @ConstructorProperties(value={"meta"})
    public IntegerQualityAddFunction(IntegerMetaData meta) {
        this.meta = meta;
    }
}

