/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.spark.transform.quality.real;

import java.beans.ConstructorProperties;
import org.apache.spark.api.java.function.Function2;
import org.datavec.api.transform.metadata.DoubleMetaData;
import org.datavec.api.transform.quality.columns.DoubleQuality;
import org.datavec.api.writable.NullWritable;
import org.datavec.api.writable.Text;
import org.datavec.api.writable.Writable;

public class RealQualityAddFunction
implements Function2<DoubleQuality, Writable, DoubleQuality> {
    private final DoubleMetaData meta;

    public DoubleQuality call(DoubleQuality v1, Writable writable) throws Exception {
        long valid = v1.getCountValid();
        long invalid = v1.getCountInvalid();
        long countMissing = v1.getCountMissing();
        long countTotal = v1.getCountTotal() + 1L;
        long nonReal = v1.getCountNonReal();
        long nan = v1.getCountNaN();
        long infinite = v1.getCountInfinite();
        if (this.meta.isValid(writable)) {
            ++valid;
        } else if (writable instanceof NullWritable || writable instanceof Text && (writable.toString() == null || writable.toString().isEmpty())) {
            ++countMissing;
        } else {
            ++invalid;
        }
        String str = writable.toString();
        try {
            double d = Double.parseDouble(str);
            if (Double.isNaN(d)) {
                ++nan;
            }
            if (Double.isInfinite(d)) {
                ++infinite;
            }
        }
        catch (NumberFormatException e) {
            ++nonReal;
        }
        return new DoubleQuality(valid, invalid, countMissing, countTotal, nonReal, nan, infinite);
    }

    @ConstructorProperties(value={"meta"})
    public RealQualityAddFunction(DoubleMetaData meta) {
        this.meta = meta;
    }
}

