/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.spark.transform.sparkfunction.sequence;

import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.spark.api.java.function.Function2;
import org.apache.spark.sql.Row;
import org.datavec.api.transform.schema.Schema;
import org.datavec.api.writable.Writable;
import org.datavec.spark.transform.DataFrames;

public class DataFrameToSequenceMergeValue
implements Function2<List<List<Writable>>, Iterable<Row>, List<List<Writable>>> {
    private final Schema schema;

    public List<List<Writable>> call(List<List<Writable>> seqSoFar, Iterable<Row> rows) throws Exception {
        ArrayList<List<Writable>> retSeq = new ArrayList<List<Writable>>(seqSoFar);
        for (Row v1 : rows) {
            List<Writable> ret = DataFrames.rowToWritables(this.schema, v1);
            retSeq.add(ret);
        }
        Collections.sort(retSeq, new Comparator<List<Writable>>(){

            @Override
            public int compare(List<Writable> o1, List<Writable> o2) {
                return Integer.compare(o1.get(1).toInt(), o2.get(1).toInt());
            }
        });
        return retSeq;
    }

    @ConstructorProperties(value={"schema"})
    public DataFrameToSequenceMergeValue(Schema schema) {
        this.schema = schema;
    }
}

