/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.spark.transform.analysis.aggregate;

import java.util.ArrayList;
import java.util.List;
import org.apache.spark.api.java.function.Function2;
import org.datavec.api.transform.ColumnType;
import org.datavec.api.transform.analysis.AnalysisCounter;
import org.datavec.api.transform.analysis.counter.BytesAnalysisCounter;
import org.datavec.api.transform.analysis.counter.CategoricalAnalysisCounter;
import org.datavec.api.transform.analysis.counter.DoubleAnalysisCounter;
import org.datavec.api.transform.analysis.counter.IntegerAnalysisCounter;
import org.datavec.api.transform.analysis.counter.LongAnalysisCounter;
import org.datavec.api.transform.analysis.counter.NDArrayAnalysisCounter;
import org.datavec.api.transform.analysis.counter.StringAnalysisCounter;
import org.datavec.api.transform.schema.Schema;
import org.datavec.api.writable.Writable;

public class AnalysisAddFunction
implements Function2<List<AnalysisCounter>, List<Writable>, List<AnalysisCounter>> {
    private Schema schema;

    public List<AnalysisCounter> call(List<AnalysisCounter> analysisCounters, List<Writable> writables) throws Exception {
        int size;
        if (analysisCounters == null) {
            analysisCounters = new ArrayList<AnalysisCounter>();
            List columnTypes = this.schema.getColumnTypes();
            block11: for (ColumnType ct : columnTypes) {
                switch (ct) {
                    case String: {
                        analysisCounters.add((AnalysisCounter)new StringAnalysisCounter());
                        continue block11;
                    }
                    case Integer: {
                        analysisCounters.add((AnalysisCounter)new IntegerAnalysisCounter());
                        continue block11;
                    }
                    case Long: {
                        analysisCounters.add((AnalysisCounter)new LongAnalysisCounter());
                        continue block11;
                    }
                    case Double: 
                    case Float: {
                        analysisCounters.add((AnalysisCounter)new DoubleAnalysisCounter());
                        continue block11;
                    }
                    case Categorical: {
                        analysisCounters.add((AnalysisCounter)new CategoricalAnalysisCounter());
                        continue block11;
                    }
                    case Time: {
                        analysisCounters.add((AnalysisCounter)new LongAnalysisCounter());
                        continue block11;
                    }
                    case Bytes: {
                        analysisCounters.add((AnalysisCounter)new BytesAnalysisCounter());
                        continue block11;
                    }
                    case NDArray: {
                        analysisCounters.add((AnalysisCounter)new NDArrayAnalysisCounter());
                        continue block11;
                    }
                    case Boolean: {
                        analysisCounters.add((AnalysisCounter)new IntegerAnalysisCounter());
                        continue block11;
                    }
                }
                throw new IllegalArgumentException("Unknown column type: " + ct);
            }
        }
        if ((size = analysisCounters.size()) != writables.size()) {
            throw new IllegalStateException("Writables list and number of counters does not match (" + writables.size() + " vs " + size + ")");
        }
        for (int i = 0; i < size; ++i) {
            analysisCounters.get(i).add(writables.get(i));
        }
        return analysisCounters;
    }

    public AnalysisAddFunction(Schema schema) {
        this.schema = schema;
    }
}

