/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.spark.transform.filter;

import org.apache.spark.api.java.function.Function;
import org.datavec.api.transform.metadata.ColumnMetaData;
import org.datavec.api.writable.NullWritable;
import org.datavec.api.writable.Text;
import org.datavec.api.writable.Writable;

public class FilterWritablesBySchemaFunction
implements Function<Writable, Boolean> {
    private final ColumnMetaData meta;
    private final boolean keepValid;
    private final boolean excludeMissing;

    public FilterWritablesBySchemaFunction(ColumnMetaData meta, boolean keepValid) {
        this(meta, keepValid, false);
    }

    public FilterWritablesBySchemaFunction(ColumnMetaData meta, boolean keepValid, boolean excludeMissing) {
        this.meta = meta;
        this.keepValid = keepValid;
        this.excludeMissing = excludeMissing;
    }

    public Boolean call(Writable v1) throws Exception {
        boolean valid = this.meta.isValid(v1);
        if (this.excludeMissing && (v1 instanceof NullWritable || v1 instanceof Text && (v1.toString() == null || v1.toString().isEmpty()))) {
            return false;
        }
        if (this.keepValid) {
            return valid;
        }
        return !valid;
    }
}

