/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.spark.functions.pairdata;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.net.URI;
import java.util.List;
import org.apache.hadoop.io.Text;
import org.apache.spark.api.java.function.Function;
import org.datavec.api.records.reader.SequenceRecordReader;
import org.datavec.api.writable.Writable;
import org.datavec.spark.functions.pairdata.BytesPairWritable;
import scala.Tuple2;

public class PairSequenceRecordReaderBytesFunction
implements Function<Tuple2<Text, BytesPairWritable>, Tuple2<List<List<Writable>>, List<List<Writable>>>> {
    private final SequenceRecordReader recordReaderFirst;
    private final SequenceRecordReader recordReaderSecond;

    public PairSequenceRecordReaderBytesFunction(SequenceRecordReader recordReaderFirst, SequenceRecordReader recordReaderSecond) {
        this.recordReaderFirst = recordReaderFirst;
        this.recordReaderSecond = recordReaderSecond;
    }

    public Tuple2<List<List<Writable>>, List<List<Writable>>> call(Tuple2<Text, BytesPairWritable> v1) throws Exception {
        BytesPairWritable bpw = (BytesPairWritable)v1._2();
        DataInputStream dis1 = new DataInputStream(new ByteArrayInputStream(bpw.getFirst()));
        DataInputStream dis2 = new DataInputStream(new ByteArrayInputStream(bpw.getSecond()));
        URI u1 = bpw.getUriFirst() != null ? new URI(bpw.getUriFirst()) : null;
        URI u2 = bpw.getUriSecond() != null ? new URI(bpw.getUriSecond()) : null;
        List first = this.recordReaderFirst.sequenceRecord(u1, dis1);
        List second = this.recordReaderSecond.sequenceRecord(u2, dis2);
        return new Tuple2((Object)first, (Object)second);
    }
}

