/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.spark.transform.join;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.datavec.api.transform.join.Join;
import org.datavec.api.writable.Writable;
import org.nd4j.shade.guava.collect.Iterables;
import scala.Tuple2;

public class ExecuteJoinFromCoGroupFlatMapFunction
implements FlatMapFunction<Tuple2<List<Writable>, Tuple2<Iterable<List<Writable>>, Iterable<List<Writable>>>>, List<Writable>> {
    private final Join join;

    public ExecuteJoinFromCoGroupFlatMapFunction(Join join) {
        this.join = join;
    }

    public Iterator<List<Writable>> call(Tuple2<List<Writable>, Tuple2<Iterable<List<Writable>>, Iterable<List<Writable>>>> t2) throws Exception {
        Iterable leftList = (Iterable)((Tuple2)t2._2())._1();
        Iterable rightList = (Iterable)((Tuple2)t2._2())._2();
        ArrayList<Object> ret = new ArrayList<Object>();
        Join.JoinType jt = this.join.getJoinType();
        switch (jt) {
            case Inner: {
                for (List jvl : leftList) {
                    for (List jvr : rightList) {
                        List joined = this.join.joinExamples(jvl, jvr);
                        ret.add(joined);
                    }
                }
                break;
            }
            case LeftOuter: {
                for (List jvl : leftList) {
                    if (Iterables.size((Iterable)rightList) == 0) {
                        List joined = this.join.joinExamples(jvl, null);
                        ret.add(joined);
                        continue;
                    }
                    for (List jvr : rightList) {
                        List joined = this.join.joinExamples(jvl, jvr);
                        ret.add(joined);
                    }
                }
                break;
            }
            case RightOuter: {
                for (List jvr : rightList) {
                    if (Iterables.size((Iterable)leftList) == 0) {
                        List joined = this.join.joinExamples(null, jvr);
                        ret.add(joined);
                        continue;
                    }
                    for (List jvl : leftList) {
                        List joined = this.join.joinExamples(jvl, jvr);
                        ret.add(joined);
                    }
                }
                break;
            }
            case FullOuter: {
                if (Iterables.size((Iterable)leftList) == 0) {
                    for (List jvr : rightList) {
                        List joined = this.join.joinExamples(null, jvr);
                        ret.add(joined);
                    }
                } else if (Iterables.size((Iterable)rightList) == 0) {
                    for (List jvl : leftList) {
                        List joined = this.join.joinExamples(jvl, null);
                        ret.add(joined);
                    }
                } else {
                    for (List jvl : leftList) {
                        for (List jvr : rightList) {
                            List joined = this.join.joinExamples(jvl, jvr);
                            ret.add(joined);
                        }
                    }
                }
                break;
            }
        }
        return ret.iterator();
    }
}

