/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.spark.transform.misc;

import java.util.ArrayList;
import java.util.List;
import org.apache.spark.api.java.function.Function;
import org.datavec.api.writable.DoubleWritable;
import org.datavec.api.writable.NDArrayWritable;
import org.datavec.api.writable.Writable;
import org.nd4j.linalg.api.ndarray.INDArray;

public class NDArrayToWritablesFunction
implements Function<INDArray, List<Writable>> {
    private boolean useNdarrayWritable = false;

    public NDArrayToWritablesFunction() {
        this.useNdarrayWritable = false;
    }

    public List<Writable> call(INDArray arr) throws Exception {
        if (arr.rows() != 1) {
            throw new UnsupportedOperationException("Only NDArray row vectors can be converted to list of Writables (found " + arr.rows() + " rows)");
        }
        ArrayList<Writable> record = new ArrayList<Writable>();
        if (this.useNdarrayWritable) {
            record.add((Writable)new NDArrayWritable(arr));
        } else {
            for (int i = 0; i < arr.columns(); ++i) {
                record.add((Writable)new DoubleWritable(arr.getDouble((long)i)));
            }
        }
        return record;
    }

    public NDArrayToWritablesFunction(boolean useNdarrayWritable) {
        this.useNdarrayWritable = useNdarrayWritable;
    }
}

