/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.spark.transform.misc;

import java.util.List;
import org.apache.spark.api.java.function.Function;
import org.datavec.api.writable.Writable;

public class WritablesToStringFunction
implements Function<List<Writable>, String> {
    private final String delim;
    private final String quote;

    public WritablesToStringFunction(String delim) {
        this(delim, null);
    }

    public String call(List<Writable> c) throws Exception {
        StringBuilder sb = new StringBuilder();
        WritablesToStringFunction.append(c, sb, this.delim, this.quote);
        return sb.toString();
    }

    public static void append(List<Writable> c, StringBuilder sb, String delim, String quote) {
        boolean first = true;
        for (Writable w : c) {
            String s;
            boolean needQuotes;
            if (!first) {
                sb.append(delim);
            }
            if ((needQuotes = (s = w.toString()).contains(delim)) && quote != null) {
                sb.append(quote);
                s = s.replace(quote, quote + quote);
            }
            sb.append(s);
            if (needQuotes && quote != null) {
                sb.append(quote);
            }
            first = false;
        }
    }

    public WritablesToStringFunction(String delim, String quote) {
        this.delim = delim;
        this.quote = quote;
    }
}

