/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.spark.transform.sparkfunction;

import java.util.ArrayList;
import java.util.List;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.sql.Row;
import org.datavec.api.transform.schema.Schema;
import org.datavec.api.writable.DoubleWritable;
import org.datavec.api.writable.FloatWritable;
import org.datavec.api.writable.IntWritable;
import org.datavec.api.writable.LongWritable;
import org.datavec.api.writable.Writable;

public class ToRecord
implements Function<Row, List<Writable>> {
    private Schema schema;

    public List<Writable> call(Row v1) throws Exception {
        ArrayList<Writable> ret = new ArrayList<Writable>();
        if (v1.size() != this.schema.numColumns()) {
            throw new IllegalArgumentException("Invalid number of columns for row " + v1.size() + " should have matched schema columns " + this.schema.numColumns());
        }
        block6: for (int i = 0; i < v1.size(); ++i) {
            if (v1.get(i) == null) {
                throw new IllegalStateException("Row item " + i + " is null");
            }
            switch (this.schema.getType(i)) {
                case Double: {
                    ret.add((Writable)new DoubleWritable(v1.getDouble(i)));
                    continue block6;
                }
                case Float: {
                    ret.add((Writable)new FloatWritable(v1.getFloat(i)));
                    continue block6;
                }
                case Integer: {
                    ret.add((Writable)new IntWritable(v1.getInt(i)));
                    continue block6;
                }
                case Long: {
                    ret.add((Writable)new LongWritable(v1.getLong(i)));
                    continue block6;
                }
                default: {
                    throw new IllegalStateException("Illegal type");
                }
            }
        }
        return ret;
    }

    public ToRecord(Schema schema) {
        this.schema = schema;
    }
}

