/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.spark.util;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import lombok.NonNull;
import org.apache.hadoop.conf.Configuration;

public class SerializableHadoopConfig
implements Serializable {
    private Map<String, String> content;
    private transient Configuration configuration;

    public SerializableHadoopConfig(@NonNull Configuration configuration) {
        if (configuration == null) {
            throw new NullPointerException("configuration is marked @NonNull but is null");
        }
        this.configuration = configuration;
        this.content = new LinkedHashMap<String, String>();
        for (Map.Entry next : configuration) {
            this.content.put((String)next.getKey(), (String)next.getValue());
        }
    }

    public synchronized Configuration getConfiguration() {
        if (this.configuration == null) {
            this.configuration = new Configuration();
            for (Map.Entry<String, String> e : this.content.entrySet()) {
                this.configuration.set(e.getKey(), e.getValue());
            }
        }
        return this.configuration;
    }
}

