/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.spark.storage;

import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.mapreduce.lib.input.SequenceFileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.MapFileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.SequenceFileOutputFormat;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.PairFunction;
import org.datavec.api.writable.Writable;
import org.datavec.hadoop.records.reader.mapfile.record.RecordWritable;
import org.datavec.hadoop.records.reader.mapfile.record.SequenceRecordWritable;
import org.datavec.spark.storage.functions.RecordLoadPairFunction;
import org.datavec.spark.storage.functions.RecordSavePrepPairFunction;
import org.datavec.spark.storage.functions.SequenceRecordLoadPairFunction;
import org.datavec.spark.storage.functions.SequenceRecordSavePrepPairFunction;

public class SparkStorageUtils {
    public static final String MAP_FILE_INDEX_INTERVAL_KEY = "io.map.index.interval";
    public static final int DEFAULT_MAP_FILE_INTERVAL = 1;

    private SparkStorageUtils() {
    }

    public static void saveSequenceFile(String path, JavaRDD<List<Writable>> rdd) {
        SparkStorageUtils.saveSequenceFile(path, rdd, null);
    }

    public static void saveSequenceFile(String path, JavaRDD<List<Writable>> rdd, Integer maxOutputFiles) {
        path = FilenameUtils.normalize((String)path, (boolean)true);
        if (maxOutputFiles != null) {
            rdd = rdd.coalesce(maxOutputFiles.intValue());
        }
        JavaPairRDD dataIndexPairs = rdd.zipWithUniqueId();
        JavaPairRDD keyedByIndex = dataIndexPairs.mapToPair((PairFunction)new RecordSavePrepPairFunction());
        keyedByIndex.saveAsNewAPIHadoopFile(path, LongWritable.class, RecordWritable.class, SequenceFileOutputFormat.class);
    }

    public static JavaRDD<List<Writable>> restoreSequenceFile(String path, JavaSparkContext sc) {
        return SparkStorageUtils.restoreMapFile(path, sc).values();
    }

    public static void saveSequenceFileSequences(String path, JavaRDD<List<List<Writable>>> rdd) {
        SparkStorageUtils.saveSequenceFileSequences(path, rdd, null);
    }

    public static void saveSequenceFileSequences(String path, JavaRDD<List<List<Writable>>> rdd, Integer maxOutputFiles) {
        path = FilenameUtils.normalize((String)path, (boolean)true);
        if (maxOutputFiles != null) {
            rdd = rdd.coalesce(maxOutputFiles.intValue());
        }
        JavaPairRDD dataIndexPairs = rdd.zipWithUniqueId();
        JavaPairRDD keyedByIndex = dataIndexPairs.mapToPair((PairFunction)new SequenceRecordSavePrepPairFunction());
        keyedByIndex.saveAsNewAPIHadoopFile(path, LongWritable.class, SequenceRecordWritable.class, SequenceFileOutputFormat.class);
    }

    public static JavaRDD<List<List<Writable>>> restoreSequenceFileSequences(String path, JavaSparkContext sc) {
        return SparkStorageUtils.restoreMapFileSequences(path, sc).values();
    }

    public static void saveMapFile(String path, JavaRDD<List<Writable>> rdd) {
        SparkStorageUtils.saveMapFile(path, rdd, 1, null);
    }

    public static void saveMapFile(String path, JavaRDD<List<Writable>> rdd, int interval, Integer maxOutputFiles) {
        Configuration c = new Configuration();
        c.set(MAP_FILE_INDEX_INTERVAL_KEY, String.valueOf(interval));
        SparkStorageUtils.saveMapFile(path, rdd, c, maxOutputFiles);
    }

    public static void saveMapFile(String path, JavaRDD<List<Writable>> rdd, Configuration c, Integer maxOutputFiles) {
        path = FilenameUtils.normalize((String)path, (boolean)true);
        if (maxOutputFiles != null) {
            rdd = rdd.coalesce(maxOutputFiles.intValue());
        }
        JavaPairRDD dataIndexPairs = rdd.zipWithIndex();
        JavaPairRDD keyedByIndex = dataIndexPairs.mapToPair((PairFunction)new RecordSavePrepPairFunction());
        keyedByIndex.saveAsNewAPIHadoopFile(path, LongWritable.class, RecordWritable.class, MapFileOutputFormat.class, c);
    }

    public static JavaPairRDD<Long, List<Writable>> restoreMapFile(String path, JavaSparkContext sc) {
        Configuration c = new Configuration();
        c.set("mapreduce.input.fileinputformat.inputdir", FilenameUtils.normalize((String)path, (boolean)true));
        JavaPairRDD pairRDD = sc.newAPIHadoopRDD(c, SequenceFileInputFormat.class, LongWritable.class, RecordWritable.class);
        return pairRDD.mapToPair((PairFunction)new RecordLoadPairFunction());
    }

    public static void saveMapFileSequences(String path, JavaRDD<List<List<Writable>>> rdd) {
        SparkStorageUtils.saveMapFileSequences(path, rdd, 1, null);
    }

    public static void saveMapFileSequences(String path, JavaRDD<List<List<Writable>>> rdd, int interval, Integer maxOutputFiles) {
        Configuration c = new Configuration();
        c.set(MAP_FILE_INDEX_INTERVAL_KEY, String.valueOf(interval));
        SparkStorageUtils.saveMapFileSequences(path, rdd, c, maxOutputFiles);
    }

    public static void saveMapFileSequences(String path, JavaRDD<List<List<Writable>>> rdd, Configuration c, Integer maxOutputFiles) {
        path = FilenameUtils.normalize((String)path, (boolean)true);
        if (maxOutputFiles != null) {
            rdd = rdd.coalesce(maxOutputFiles.intValue());
        }
        JavaPairRDD dataIndexPairs = rdd.zipWithIndex();
        JavaPairRDD keyedByIndex = dataIndexPairs.mapToPair((PairFunction)new SequenceRecordSavePrepPairFunction());
        keyedByIndex.saveAsNewAPIHadoopFile(path, LongWritable.class, SequenceRecordWritable.class, MapFileOutputFormat.class, c);
    }

    public static JavaPairRDD<Long, List<List<Writable>>> restoreMapFileSequences(String path, JavaSparkContext sc) {
        Configuration c = new Configuration();
        c.set("mapreduce.input.fileinputformat.inputdir", FilenameUtils.normalize((String)path, (boolean)true));
        JavaPairRDD pairRDD = sc.newAPIHadoopRDD(c, SequenceFileInputFormat.class, LongWritable.class, SequenceRecordWritable.class);
        return pairRDD.mapToPair((PairFunction)new SequenceRecordLoadPairFunction());
    }
}

