/*
 * Decompiled with CFR 0.152.
 */
package org.dataverse.unf;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Base64;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.dataverse.unf.UnfCons;

public class Base64Encoding
implements UnfCons {
    private static String DEFAULT_CHAR_ENCODING = "UTF-8";
    private static Logger mLog = Logger.getLogger(Base64Encoding.class.getName());
    private static ByteOrder border = ByteOrder.BIG_ENDIAN;

    public Base64Encoding() {
        mLog.setLevel(Level.WARNING);
    }

    public Base64Encoding(ByteOrder ord) {
        border = ord;
    }

    public static ByteOrder getBorder() {
        return border;
    }

    public static void setBorder(ByteOrder ord) {
        border = ord;
    }

    public static String tobase64(byte[] digest, boolean chngByteOrd) {
        byte[] tobase64 = null;
        ByteOrder local = ByteOrder.nativeOrder();
        String ordbyte = local.toString();
        mLog.finer("Native byte order is: " + ordbyte);
        ByteBuffer btstream = ByteBuffer.wrap(digest);
        btstream.order(ByteOrder.BIG_ENDIAN);
        byte[] revdigest = null;
        if (chngByteOrd) {
            revdigest = Base64Encoding.changeByteOrder(digest, local);
        }
        if (revdigest != null) {
            btstream.put(revdigest);
        } else {
            btstream.put(digest);
        }
        tobase64 = Base64.getEncoder().encode(btstream.array());
        return new String(tobase64);
    }

    public static String tobase64(byte[] digest, String enc) throws UnsupportedEncodingException {
        ByteArrayOutputStream btstream = new ByteArrayOutputStream();
        DataOutputStream stream = new DataOutputStream(btstream);
        byte[] tobase64 = null;
        byte[] revdigest = new byte[digest.length];
        revdigest = Base64Encoding.changeByteOrder(digest, ByteOrder.nativeOrder());
        try {
            stream.write(revdigest);
            stream.flush();
            tobase64 = Base64.getEncoder().encode(btstream.toByteArray());
        }
        catch (IOException io) {
            tobase64 = Base64.getEncoder().encode(digest);
        }
        return new String(tobase64, enc);
    }

    public static byte[] changeByteOrder(byte[] digest, ByteOrder local) {
        byte[] revdigest = new byte[digest.length];
        if (local.equals(ByteOrder.LITTLE_ENDIAN) && Base64Encoding.getBorder().equals(ByteOrder.BIG_ENDIAN) || local.equals(ByteOrder.BIG_ENDIAN) && Base64Encoding.getBorder().equals(ByteOrder.LITTLE_ENDIAN)) {
            int ln = digest.length;
            for (int n = 0; n < ln; ++n) {
                revdigest[n] = digest[ln - 1 - n];
            }
        } else {
            revdigest = digest;
        }
        return revdigest;
    }
}

