/*
 * Decompiled with CFR 0.152.
 */
package org.dataverse.unf;

import java.util.Locale;
import java.util.logging.Logger;
import org.dataverse.unf.FormatNumbSymbols;

public class RoundRoutinesUtils {
    public static final long serialVersionUID = 2222L;
    private static Logger mLog = Logger.getLogger(RoundRoutinesUtils.class.getName());
    private static final Locale currentLocale = Locale.getDefault();
    private static FormatNumbSymbols symb = new FormatNumbSymbols(currentLocale);

    public static boolean checkNumeric(Byte obj, int radix) {
        String str = obj.toString();
        boolean numeric = true;
        try {
            Byte.parseByte(str, radix);
        }
        catch (NumberFormatException err) {
            numeric = false;
        }
        return numeric;
    }

    public static boolean checkNumeric(CharSequence cobj) {
        String obj = cobj.toString();
        int ln = cobj.length();
        char[] objarro = new char[ln];
        boolean numeric = true;
        int cnt = 0;
        for (int n = 0; n < ln; ++n) {
            objarro[n] = cobj.charAt(n);
            if (Character.isDigit(objarro[n])) continue;
            numeric = false;
            ++cnt;
        }
        if (!numeric && cnt < ln) {
            mLog.warning("roundRoutines: mixing digits and chars treated as string");
        }
        return numeric;
    }

    public static String trimZeros(String str, boolean atfront) {
        char[] strchar = str.toCharArray();
        int ln = strchar.length;
        int cnt = 0;
        String str0 = str;
        if (atfront) {
            for (int i = 0; i < ln && strchar[i] == '0'; ++i) {
                ++cnt;
            }
            if (cnt > 0) {
                str0 = str.substring(cnt, str.length());
            }
        } else {
            for (int i = ln - 1; i >= 0 && strchar[i] == '0'; --i) {
                ++cnt;
            }
            if (cnt > 0) {
                str0 = str.substring(0, ln - cnt);
            }
        }
        return str0;
    }

    public static String specialNumb(Double n) {
        boolean bnan = Double.isNaN(n);
        boolean binfty = Double.isInfinite(n);
        String tmp = null;
        if (n - n + 0.0 == 0.0 && n == n && !bnan && !binfty) {
            return tmp;
        }
        if (bnan) {
            mLog.warning("RoundRoutines: nan encounter");
            tmp = symb.getNan();
            return tmp;
        }
        if (binfty) {
            mLog.warning("RoundRoutines: infinite encounter");
            if (n > 0.0) {
                tmp = symb.getPlusInf();
                return tmp;
            }
            tmp = symb.getMinusInf();
            return tmp;
        }
        mLog.severe("RoundRoutines: Genround: Unknown input" + n);
        return n.toString();
    }

    public static Object byteToValue(Byte obj, int radix) {
        Double objd = null;
        String objcs = null;
        boolean b = RoundRoutinesUtils.checkNumeric(obj, radix);
        if (b) {
            objd = obj.doubleValue();
            return objd;
        }
        if (!b) {
            objcs = obj.toString();
            return objcs;
        }
        return obj;
    }
}

