/*
 * Decompiled with CFR 0.152.
 */
package org.dataverse.unf;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.dataverse.unf.Base64Encoding;
import org.dataverse.unf.UnfCons;
import org.dataverse.unf.UnfDigestUtils;
import org.dataverse.unf.UtilsConverter;

public class UnfBitfield<T extends CharSequence>
implements UnfCons {
    private static Logger mLog = Logger.getLogger(UnfBitfield.class.getName());
    private String orencoding = null;
    private String encoding = "UTF-8";
    Locale currentlocale = Locale.getDefault();
    private String mdalgor = "SHA-256";
    private MessageDigest md = null;

    public UnfBitfield() {
        mLog.setLevel(Level.WARNING);
        if (this.orencoding == null) {
            this.orencoding = "UTF-8";
        }
        try {
            this.md = MessageDigest.getInstance(this.mdalgor);
        }
        catch (NoSuchAlgorithmException err) {
            throw new RuntimeException(err.getMessage());
        }
    }

    public UnfBitfield(String algor) {
        mLog.setLevel(Level.WARNING);
        this.mdalgor = algor;
        try {
            this.md = MessageDigest.getInstance(algor);
        }
        catch (NoSuchAlgorithmException err) {
            throw new RuntimeException(err.getMessage());
        }
    }

    public UnfBitfield(String dch, String or) {
        this();
        this.encoding = dch;
        this.orencoding = or;
    }

    public UnfBitfield(String digest, String dch, String or) {
        this(digest);
        this.encoding = dch;
        this.orencoding = or;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String fenc) {
        this.encoding = fenc;
    }

    public String getMdalgor() {
        return this.mdalgor;
    }

    public void setMdalgor(String aa) {
        this.mdalgor = aa;
        MessageDigest mdm = null;
        try {
            this.md = mdm = MessageDigest.getInstance(aa);
        }
        catch (NoSuchAlgorithmException err) {
            throw new RuntimeException(err.getMessage());
        }
    }

    public boolean getNullbyte() {
        return true;
    }

    public String RUNF5(CharSequence[] v, boolean[] miss, List<Integer> result, Character[] base64, StringBuilder hex) throws UnsupportedEncodingException {
        int nv = v.length;
        int[] v5bitsize = new int[]{128, 192, 256};
        int k = 0;
        for (k = 0; k < nv; ++k) {
            mLog.finer("" + v[k] + ";");
            this.md = miss == null ? this.UNF3(v[k], this.md, false) : this.UNF3(v[k], this.md, miss[k]);
        }
        byte[] hash = this.md.digest();
        this.md.reset();
        if (hash.length > 32) {
            mLog.finer("unfString: hash has more than 32 bytes.." + hash.length);
        }
        byte[] v5hash = this.truncateHash(hash, v5bitsize[0]);
        for (k = 0; k < v5hash.length; ++k) {
            result.add(v5hash[k] & 0xFF);
        }
        String rtobase64 = Base64Encoding.tobase64(v5hash, false);
        String hexstr = UtilsConverter.getHexStrng(v5hash);
        hex.append(hexstr);
        for (int n = 0; n < rtobase64.length(); ++n) {
            base64[n] = new Character(rtobase64.charAt(n));
        }
        mLog.finer(rtobase64);
        return rtobase64;
    }

    byte[] truncateHash(byte[] hash, int n) {
        assert (n % 8 == 0);
        int bits = n / 8;
        byte[] rhash = new byte[bits];
        for (int x = 0; x < bits; ++x) {
            rhash[x] = hash[x];
        }
        return rhash;
    }

    public MessageDigest UNF3(CharSequence obj, MessageDigest previous, boolean miss) throws UnsupportedEncodingException {
        if (!miss) {
            mLog.finer(obj.toString());
            String res = "";
            if (!obj.equals("")) {
                res = obj.toString();
            } else {
                res = res + creturn;
                res = res + zeroscape;
            }
            mLog.finer(res);
            if (res == null || res.equals("") && !obj.equals(obj)) {
                mLog.severe("UNF3: Genround returns null or empty String");
                return previous;
            }
            int sz = res.length();
            if (res.charAt(sz - 1) != zeroscape) {
                res = res + zeroscape;
            }
            String[] dec = new String[]{this.encoding, this.orencoding};
            byte[] bt = res.getBytes(this.orencoding);
            byte[] tmpu = null;
            tmpu = UtilsConverter.byteConverter(bt, dec);
            if (tmpu == null) {
                mLog.severe("UNF3: CanonalizeUnicode returns null");
                return previous;
            }
            byte[] bint = tmpu;
            bint = UnfDigestUtils.eliminateZeroPadding(tmpu, bt);
            String tmp0 = "";
            int cnt = 0;
            for (int n = 0; n < bint.length; ++n) {
                tmp0 = tmp0 + "\t" + bint[n];
                if (++cnt % 10 != 0) continue;
                tmp0 = tmp0 + "\n";
            }
            mLog.finer("after " + tmp0);
            this.md.update(bint);
        }
        if (miss) {
            byte[] topass = UtilsConverter.getBytes(missv, null);
            this.md.update(topass);
        }
        return previous;
    }
}

