/*
 * Decompiled with CFR 0.152.
 */
package org.dataverse.unf;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.dataverse.unf.BitString;
import org.dataverse.unf.UnfBitfield;
import org.dataverse.unf.UnfBoolean;
import org.dataverse.unf.UnfClass;
import org.dataverse.unf.UnfCons;
import org.dataverse.unf.UnfDigestUtils;
import org.dataverse.unf.UnfException;
import org.dataverse.unf.UnfNumber;
import org.dataverse.unf.UnfString;

public class UnfDigest
implements UnfCons {
    private static Logger mLog = Logger.getLogger(UnfDigest.class.getName());
    private static String currentVersion = "6";
    private static final String SHA256 = "SHA-256";
    private static final String UTF8 = "UTF-8";
    private static boolean trnps = true;
    private static List<List<Integer>> fingerprint = new ArrayList<List<Integer>>();
    private boolean debug = false;
    private static UnfClass signature = null;
    private static boolean buildunfObj = new Boolean(true);

    private static String getExtensions(UnfClass signature) {
        String extensions;
        StringBuffer retValBuf = new StringBuffer();
        if (signature != null && (extensions = signature.getExtensions()).length() > 0) {
            retValBuf.append(":" + extensions);
        }
        return retValBuf.toString();
    }

    public UnfDigest() {
        mLog.setLevel(Level.WARNING);
    }

    public static String getVersion() {
        return currentVersion;
    }

    public void setVersion(String vv) {
        currentVersion = vv;
    }

    public static boolean getTrnps() {
        return trnps;
    }

    public static void setTrnps(boolean tt) {
        trnps = tt;
    }

    public List<List<Integer>> getFingerprint() {
        return fingerprint;
    }

    public static UnfClass getSignature() {
        return signature;
    }

    public void setSignature(UnfClass c) {
        signature = c;
    }

    public static boolean getUnfObj() {
        return buildunfObj;
    }

    public static void setUnfObj(boolean obj) {
        buildunfObj = obj;
    }

    public static void dowarnings(int ndigits, int cdigits) {
        mLog.setLevel(Level.WARNING);
        if (ndigits != 0 && (ndigits < NDGTS_BNDS[0] || ndigits > NDGTS_BNDS[1])) {
            mLog.warning("ndigts range is between " + NDGTS_BNDS[0] + " and " + NDGTS_BNDS[1]);
        }
        if (cdigits != 0 && cdigits < 1) {
            mLog.warning("cdigts can't be less than 1");
        }
    }

    public static <T extends Number> String[] unf(T[][] obj, Integer ... digits) throws UnsupportedEncodingException, UnfException, IOException {
        if (obj == null) {
            return null;
        }
        int ln = digits.length;
        int ndigits = ln <= 0 ? 7 : digits[0];
        int cdigits = ln <= 1 ? 128 : digits[1];
        UnfDigest.dowarnings(ndigits, cdigits);
        Object topass = null;
        Object[][] tmp = UnfDigestUtils.transArray(obj);
        int len = tmp[0].length;
        int nr = UnfDigestUtils.countRows(tmp);
        Number[][] tobj = new Number[nr][len];
        for (int c = 0; c < len; ++c) {
            for (int r = 0; r < nr; ++r) {
                tobj[r][c] = (Number)tmp[r][c];
            }
        }
        int nrow = 0;
        if (trnps) {
            nrow = obj[0].length;
            topass = tobj;
        } else {
            nrow = tobj[0].length;
            topass = obj;
        }
        String algor = SHA256;
        String enc = UTF8;
        int hsz = 128;
        if (buildunfObj) {
            signature = new UnfClass(cdigits, ndigits, hsz);
        }
        String[] res = new String[nrow];
        for (int r = 0; r < nrow; ++r) {
            res[r] = UnfDigest.unfV((Number[])topass[r], (int)ndigits, (UnfClass)signature);
        }
        return res;
    }

    public static String[] unf(BitString[] b) throws UnsupportedEncodingException, IOException {
        int nrow = 1;
        int hsz = 128;
        if (buildunfObj) {
            signature = new UnfClass(128, 7, 128);
        }
        String[] res = new String[nrow];
        res[0] = UnfDigest.unfV(b, signature);
        return res;
    }

    public static String[] unf(Boolean[] b) throws UnsupportedEncodingException, IOException {
        int nrow = b.length;
        int hsz = 128;
        if (buildunfObj) {
            signature = new UnfClass(128, 7, hsz);
        }
        String[] res = new String[nrow];
        res[0] = UnfDigest.unfV(b, signature);
        return res;
    }

    public static <T extends CharSequence> String[] unf(T[][] obj, Integer ... digits) throws UnsupportedEncodingException, UnfException, IOException {
        return UnfDigest.unf(obj, (String)currentVersion, (Integer[])digits);
    }

    public static <T extends CharSequence> String[] unf(T[][] obj, String vers, Integer ... digits) throws UnsupportedEncodingException, UnfException, IOException {
        if (obj == null) {
            return null;
        }
        currentVersion = vers;
        int ln = digits.length;
        int cdigits = ln <= 0 ? 128 : digits[0];
        int ndigits = ln <= 1 ? 7 : digits[1];
        UnfDigest.dowarnings(ndigits, cdigits);
        Object topass = null;
        Object[][] tmp = UnfDigestUtils.transArray(obj);
        int nr = UnfDigestUtils.countRows(tmp);
        int len = tmp[0].length;
        CharSequence[][] tobj = new CharSequence[nr][len];
        for (int c = 0; c < len; ++c) {
            for (int r = 0; r < nr; ++r) {
                tobj[r][c] = (CharSequence)tmp[r][c];
            }
        }
        int nrow = 0;
        if (trnps) {
            nrow = obj[0].length;
            topass = tobj;
        } else {
            nrow = tobj[0].length;
            topass = obj;
        }
        int hsz = 128;
        if (buildunfObj) {
            signature = new UnfClass(cdigits, ndigits, hsz);
        }
        String[] res = new String[nrow];
        for (int r = 0; r < nrow; ++r) {
            res[r] = UnfDigest.unfV((CharSequence[])topass[r], (int)cdigits, (UnfClass)signature);
        }
        return res;
    }

    public static <T extends Number> String unfV(T[] obj, int ndg) throws UnsupportedEncodingException, UnfException, IOException {
        int hsz = 128;
        signature = new UnfClass(128, ndg, hsz);
        return UnfDigest.unfV(obj, (int)ndg, (UnfClass)signature);
    }

    public static <T extends Number> String unfV(T[] obj, int ndg, UnfClass signature) throws UnsupportedEncodingException, UnfException, IOException {
        UnfNumber unfno = new UnfNumber();
        Character[] base64 = new Character[64];
        ArrayList<Integer> fingerp = new ArrayList<Integer>();
        StringBuilder hex = new StringBuilder();
        String b64 = unfno.RUNF5((Number[])obj, ndg, fingerp, base64, hex);
        boolean buildclass = false;
        if (signature != null) {
            buildclass = true;
        } else {
            int hsz = 128;
            signature = new UnfClass(128, ndg, hsz);
        }
        b64 = "UNF:" + UnfDigest.getVersion() + UnfDigest.getExtensions(signature) + ":" + b64;
        if (buildunfObj && buildclass) {
            UnfDigest.buildUnf5Class(fingerp, hex, b64, signature);
        }
        return b64;
    }

    public static <T extends CharSequence> String unfV(T[] obj, int cdg) throws UnsupportedEncodingException, UnfException, IOException {
        int hsz = 128;
        signature = new UnfClass(cdg, 7, hsz);
        return UnfDigest.unfV(obj, (int)cdg, (UnfClass)signature);
    }

    public static <T extends CharSequence> String unfV(T[] obj, int cdg, UnfClass signature) throws UnsupportedEncodingException, UnfException, IOException {
        UnfString unfno = new UnfString();
        String init = String.format("%064d", 0);
        Character[] base64 = new Character[64];
        ArrayList<Integer> fingerp = new ArrayList<Integer>();
        boolean[] b = new boolean[obj.length];
        b = UnfDigestUtils.isna(obj);
        StringBuilder hex = new StringBuilder();
        String b64 = unfno.RUNF5((CharSequence[])obj, b, cdg, (List<Integer>)fingerp, base64, hex);
        fingerprint.add(fingerp);
        boolean buildclass = false;
        if (signature != null) {
            buildclass = true;
        } else {
            int hsz = 128;
            signature = new UnfClass(cdg, 7, hsz);
        }
        b64 = "UNF:" + UnfDigest.getVersion() + UnfDigest.getExtensions(signature) + ":" + b64;
        if (buildunfObj && buildclass) {
            UnfDigest.buildUnf5Class(fingerp, hex, b64, signature);
        }
        return b64;
    }

    private static void buildUnf5Class(List<Integer> fingerp, StringBuilder hex, String b64, UnfClass signature) {
        int sz = fingerp.size();
        fingerprint.add(fingerp);
        Integer[] toadd = fingerp.toArray(new Integer[sz]);
        signature.getFingerprints().add(toadd);
        if (hex != null) {
            List<String> tmp = signature.getHexvalue();
            tmp.add(hex.toString());
            signature.setHexvalue(tmp);
        }
        List<String> tmp0 = signature.getB64();
        tmp0.add(b64);
        signature.setB64(tmp0);
    }

    public static String addUNFs(String[] b64) throws UnsupportedEncodingException, UnfException, IOException {
        if (b64.length <= 0) {
            return null;
        }
        if (b64.length <= 1) {
            return b64[0];
        }
        int ln = b64.length;
        ArrayList<String> combo = new ArrayList<String>();
        for (String str : b64) {
            String tosplit = ":";
            mLog.finer(tosplit);
            String[] res = str.split(tosplit);
            if (res.length >= 3 && str.startsWith("UNF:")) {
                mLog.finer("toadd..." + res[1]);
                combo.add(res[res.length - 1].trim());
                continue;
            }
            mLog.finer("toadd..." + res[0]);
            combo.add(res[0].trim());
        }
        Collections.sort(combo);
        CharSequence[] sortedb64 = new String[ln];
        sortedb64 = combo.toArray(new String[ln]);
        String fin = UnfDigest.unfV((CharSequence[])sortedb64, (int)128, null);
        return fin;
    }

    public static String unfV(Boolean[] obj, UnfClass signature) throws UnsupportedEncodingException, IOException {
        UnfBoolean unfno = new UnfBoolean();
        Character[] base64 = new Character[64];
        ArrayList<Integer> fingerp = new ArrayList<Integer>();
        StringBuilder hex = new StringBuilder();
        Boolean[] cobj = new Boolean[1];
        cobj = obj;
        String b64 = unfno.RUNF5(cobj, fingerp, base64, hex);
        boolean buildclass = false;
        if (signature != null) {
            buildclass = true;
        } else {
            signature = new UnfClass(128, 7, 128);
        }
        b64 = "UNF:" + UnfDigest.getVersion() + UnfDigest.getExtensions(signature) + ":" + b64;
        if (buildunfObj && buildclass) {
            UnfDigest.buildUnf5Class(fingerp, hex, b64, signature);
        }
        return b64;
    }

    public static String unfV(BitString[] obj, UnfClass signature) throws UnsupportedEncodingException, IOException {
        int nrows = obj.length;
        UnfBitfield unfno = new UnfBitfield();
        String init = String.format("%064d", 0);
        Character[] base64 = new Character[64];
        ArrayList<Integer> fingerp = new ArrayList<Integer>();
        boolean[] b = new boolean[nrows];
        StringBuilder hex = new StringBuilder();
        CharSequence[] cobj = new CharSequence[nrows];
        for (int i = 0; i < nrows; ++i) {
            b[i] = obj[i] == null;
            cobj[i] = obj[i] != null ? obj[i].getBits() : null;
        }
        String b64 = unfno.RUNF5(cobj, b, fingerp, base64, hex);
        fingerprint.add(fingerp);
        boolean buildclass = false;
        if (signature != null) {
            buildclass = true;
        } else {
            int hsz = 128;
            signature = new UnfClass(128, 7, hsz);
        }
        b64 = "UNF:" + UnfDigest.getVersion() + UnfDigest.getExtensions(signature) + ":" + b64;
        if (buildunfObj && buildclass) {
            UnfDigest.buildUnf5Class(fingerp, hex, b64, signature);
        }
        return b64;
    }
}

