/*
 * Decompiled with CFR 0.152.
 */
package org.dataverse.unf;

public class BitString
implements CharSequence {
    private String bits;

    public BitString() {
    }

    public BitString(String bitString) {
        if (this.validate(bitString)) {
            this.setBits(bitString);
        }
    }

    public BitString(Long l) {
        this.setBits(Long.toBinaryString(l));
    }

    public void setBits(Long l) {
        this.setBits(Long.toBinaryString(l));
    }

    private boolean validate(String bitstring) {
        boolean ok = true;
        for (int i = 0; i < bitstring.length(); ++i) {
            if (bitstring.charAt(i) == '0' || bitstring.charAt(i) == '1') continue;
            ok = false;
            break;
        }
        return ok;
    }

    private void alignToByteBoundary() {
        int padding;
        if (this.bits != null && (padding = 8 - this.bits.length() % 8) > 0) {
            StringBuilder bitsBuilder = new StringBuilder(this.bits);
            for (int i = 0; i < padding; ++i) {
                bitsBuilder.insert(0, '0');
            }
            this.bits = bitsBuilder.toString();
        }
    }

    private void truncateLeadingEmptyBits() {
        this.bits = this.bits.substring(this.bits.indexOf(49));
    }

    private void normalize() {
        this.truncateLeadingEmptyBits();
        this.alignToByteBoundary();
    }

    @Override
    public int length() {
        return this.bits.length();
    }

    @Override
    public char charAt(int index) {
        return this.bits.charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.bits.subSequence(start, end);
    }

    public String getBits() {
        return this.bits;
    }

    public void setBits(String bits) {
        if (this.validate(bits)) {
            this.bits = bits;
            this.normalize();
        }
    }
}

