/*
 * Decompiled with CFR 0.152.
 */
package org.dataverse.unf;

import java.text.DecimalFormatSymbols;
import java.util.Locale;

public class FormatNumbSymbols {
    private final Locale currentLocale;
    private final DecimalFormatSymbols decimalFmtSymb;

    public FormatNumbSymbols() {
        this.currentLocale = new Locale("en", "US");
        this.decimalFmtSymb = new DecimalFormatSymbols(this.currentLocale);
    }

    public FormatNumbSymbols(Locale currentLocale) {
        this.currentLocale = currentLocale;
        this.decimalFmtSymb = new DecimalFormatSymbols(currentLocale);
    }

    public Locale getCurrentLocale() {
        return this.currentLocale;
    }

    public String getPlusInf() {
        return "+inf";
    }

    public String getMinusInf() {
        return "-inf";
    }

    public String getNan() {
        return "+nan";
    }

    public char getDecSep() {
        return '.';
    }

    public String getPlusInfinity() {
        return this.decimalFmtSymb.getInfinity();
    }

    public String getMinusInfinity() {
        return new String(this.decimalFmtSymb.getMinusSign() + this.decimalFmtSymb.getInfinity());
    }

    public String getNaN() {
        return this.decimalFmtSymb.getNaN();
    }

    public char getDecimalSep() {
        return this.decimalFmtSymb.getDecimalSeparator();
    }

    public void setDecimalSep(char dot) {
        this.decimalFmtSymb.setDecimalSeparator(dot);
    }
}

