/*
 * Decompiled with CFR 0.152.
 */
package org.dataverse.unf;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;
import java.nio.charset.Charset;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.dataverse.unf.FormatNumbSymbols;
import org.dataverse.unf.RoundRoutinesUtils;
import org.dataverse.unf.RoundString;
import org.dataverse.unf.Ucnt;
import org.dataverse.unf.UnfCons;
import org.dataverse.unf.UnfException;

public class RoundRoutines<T extends Number>
implements UnfCons {
    public static final long serialVersionUID = 1111L;
    private static Logger mLog = Logger.getLogger(RoundRoutines.class.getName());
    private int digits;
    private Locale loc;
    private FormatNumbSymbols symb = new FormatNumbSymbols();
    private static final boolean nozero = true;
    private int radix = 10;
    private static final char dot = Ucnt.dot.getUcode();
    private static final char plus = Ucnt.plus.getUcode();
    private static final char min = Ucnt.min.getUcode();
    private static final char e = Ucnt.e.getUcode();
    private static final char percntg = Ucnt.percntg.getUcode();
    private static final char pndsgn = Ucnt.pndsgn.getUcode();
    private static final char zero = Ucnt.zero.getUcode();
    private static final char s = Ucnt.s.getUcode();
    private static final char ffeed = Ucnt.frmfeed.getUcode();
    private static final char creturn = Ucnt.psxendln.getUcode();
    private static boolean nullbyte = false;
    private static boolean convertToNumber = false;

    public RoundRoutines() {
        mLog.setLevel(Level.WARNING);
        this.digits = 7;
        this.symb = new FormatNumbSymbols();
    }

    public RoundRoutines(boolean no) {
        this();
        nullbyte = no;
    }

    public RoundRoutines(int digits, boolean no) {
        this(no);
        if (digits < 1) {
            digits = 1;
        }
        this.digits = digits <= 14 ? digits : 14;
    }

    public RoundRoutines(int digits, boolean no, Locale loc) {
        this(digits, no);
        this.loc = loc;
    }

    public boolean getNullbyte() {
        return nullbyte;
    }

    public void setNullbyte(boolean b) {
        nullbyte = b;
    }

    public String Genround(T obj, int digits) throws UnfException {
        return this.Genround(obj, digits, nullbyte);
    }

    public String Genround(T numberValue, int digits, boolean nullByte) throws UnfException {
        Double doubleValue;
        nullbyte = nullByte;
        if (numberValue == null) {
            throw new UnfException("Missing (Null) value passed to Genround(Number)!");
        }
        char sep = this.symb.getDecimalSep();
        if (sep != dot) {
            mLog.warning("RoundRoutines: Decimal separator is not '.' or a dot:.");
            sep = '.';
        }
        if (digits < 0) {
            digits = this.digits;
        }
        if ((doubleValue = Double.valueOf(((Number)numberValue).doubleValue())) == 0.0) {
            StringBuffer nullStringBuffer = new StringBuffer();
            if (doubleValue.equals(new Double(0.0))) {
                nullStringBuffer.append(plus);
            } else if (doubleValue.equals(new Double(-0.0))) {
                nullStringBuffer.append(min);
            } else {
                throw new UnfException("The zero value supplied is neither positive, nor negative... what?");
            }
            nullStringBuffer.append(zero);
            nullStringBuffer.append(sep);
            nullStringBuffer.append(e);
            nullStringBuffer.append(plus);
            nullStringBuffer.append(creturn);
            return nullStringBuffer.toString();
        }
        String specialValueToken = null;
        specialValueToken = RoundRoutinesUtils.specialNumb(doubleValue);
        if (specialValueToken != null) {
            StringBuffer specialValueBuffer = new StringBuffer();
            specialValueBuffer.append(specialValueToken);
            specialValueBuffer.append(creturn);
            return specialValueBuffer.toString();
        }
        BigDecimal bigDecimalValue = null;
        if (numberValue instanceof BigDecimal) {
            bigDecimalValue = (BigDecimal)numberValue;
        } else if (numberValue instanceof BigInteger) {
            bigDecimalValue = new BigDecimal((BigInteger)numberValue, MathContext.DECIMAL64);
        } else {
            try {
                bigDecimalValue = new BigDecimal(Double.toString(((Number)numberValue).doubleValue()), MathContext.DECIMAL64);
            }
            catch (NumberFormatException ex) {
                throw new UnfException("Caught an exception when trying to make a BigDecimal out of a .doubleValue() of a Number object; (an undetected special IEEE value perhaps?)");
            }
        }
        if (bigDecimalValue == null) {
            throw new UnfException("Failed to convert the supplied Number value " + numberValue + " to BigDecimal.");
        }
        char[] str = new char[]{percntg, plus, pndsgn, sep};
        int dgt = digits - 1;
        String fmt = new String("%+#." + dgt + "e");
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(str);
        stringBuilder.append(dgt);
        stringBuilder.append(e);
        String fmtu = stringBuilder.toString();
        stringBuilder = null;
        if (!fmtu.equalsIgnoreCase(fmt) && this.loc == new Locale("en", "US")) {
            mLog.severe("RoundRoutines: Unicode & format strings do not agree");
        }
        String tmp = String.format(this.loc, fmtu, bigDecimalValue.round(new MathContext(digits, RoundingMode.HALF_EVEN)));
        String[] atoms = tmp.split("" + e);
        stringBuilder = this.calcMantissa(atoms[0], sep);
        stringBuilder.append(e);
        stringBuilder.append(atoms[1].charAt(0));
        stringBuilder.append(this.calcExponent(atoms[1]));
        return stringBuilder.toString();
    }

    public byte[] GenroundBytes(T obj, int digits, String ... charset) throws UnfException {
        Charset original;
        String str = this.Genround(obj, digits);
        if (str == null || str.equals("")) {
            return null;
        }
        Charset to = original = Charset.defaultCharset();
        if (charset.length > 0 && Charset.isSupported(charset[0]) && !(to = Charset.forName(charset[0])).canEncode()) {
            to = original;
        }
        return str.getBytes(to);
    }

    private StringBuffer calcExponent(String atom) {
        StringBuffer build = new StringBuffer();
        String expnt = atom.substring(1);
        long lngmant = Long.parseLong(expnt);
        if (lngmant <= 0L) {
            if (lngmant == 0L) {
                // empty if block
            }
        } else {
            build.append(lngmant);
        }
        build.append(creturn);
        if (nullbyte) {
            build.append(nil);
        }
        return build;
    }

    private StringBuilder calcMantissa(String atom, char sep) {
        StringBuilder build = new StringBuilder();
        char[] mag = new char[]{atom.charAt(0), atom.charAt(1)};
        String[] canon = atom.split("\\" + sep);
        if (!canon[0].equalsIgnoreCase(new String(mag))) {
            mLog.severe("RoundRoutines:decimal separator no in right place");
        }
        build.append(mag);
        build.append(sep);
        String dec = atom.substring(3);
        if (!dec.equalsIgnoreCase(canon[1])) {
            mLog.severe("RoundRoutines: decimal separator not right");
        }
        String tmp = new StringBuffer(dec).reverse().toString();
        long tmpl = Long.parseLong(tmp);
        tmp = new StringBuffer(Long.toString(tmpl)).reverse().toString();
        if (tmpl == 0L) {
            return build;
        }
        return build.append(tmp);
    }

    public String Genround(CharSequence cobj, int digits) throws UnfException {
        return RoundRoutines.Genround(cobj, digits, nullbyte);
    }

    public static String Genround(CharSequence cobj, int digits, boolean no) throws UnfException {
        if (((String)cobj).trim().equals("")) {
            Object res = "";
            if (cobj.length() > digits) {
                res = (String)cobj.subSequence(0, digits - 1);
            }
            res = (String)res + creturn;
            if (no) {
                res = (String)res + nil;
            }
            return res;
        }
        boolean numeric = false;
        if (convertToNumber) {
            numeric = RoundRoutinesUtils.checkNumeric(cobj);
        }
        if (numeric) {
            BigInteger bg = new BigInteger(cobj.toString());
            RoundRoutines<BigInteger> rout = new RoundRoutines<BigInteger>();
            return rout.Genround(bg, digits, no);
        }
        return new RoundString().Genround((String)cobj, digits, no);
    }
}

