/*
 * Decompiled with CFR 0.152.
 */
package org.dataverse.unf;

import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.dataverse.unf.Ucnt;
import org.dataverse.unf.UnfCons;

public class RoundString
implements UnfCons {
    private static Logger mLog = Logger.getLogger(RoundString.class.getName());
    private static final char dot = Ucnt.dot.getUcode();
    private static final char percntg = Ucnt.percntg.getUcode();
    private static final char s = Ucnt.s.getUcode();
    Locale loc = new Locale("en", "US");
    private boolean nullbyte = true;

    public RoundString() {
        mLog.setLevel(Level.WARNING);
    }

    public RoundString(boolean b) {
        this();
        this.nullbyte = b;
    }

    public RoundString(Locale loc, boolean b) {
        this(b);
        this.loc = loc;
    }

    public String Genround(String str, int digits) {
        return this.Genround(str, digits, this.nullbyte);
    }

    public String Genround(String str, int digits, boolean no) {
        String fmt;
        this.nullbyte = no;
        String fmtu = "" + percntg + dot + digits + s;
        if (!fmtu.equalsIgnoreCase(fmt = "%." + digits + "s") && this.loc == new Locale("en", "US")) {
            mLog.severe("RoundString: Unicode & format strings do not agree");
        }
        Object tmp = String.format(this.loc, fmtu, str);
        tmp = (String)tmp + creturn;
        if (this.nullbyte) {
            tmp = (String)tmp + zeroscape;
        }
        return tmp;
    }

    public String Genround(byte[] bb, int digits) {
        String fmt;
        byte[] str = bb;
        String fmtu = "" + percntg + dot + digits + s;
        if (!fmtu.equalsIgnoreCase(fmt = "%." + digits + "s") && this.loc == new Locale("en", "US")) {
            mLog.severe("RoundString: Unicode & format strings do not agree");
        }
        Object tmp = String.format(this.loc, fmtu, new Object[]{str}).trim();
        tmp = (String)tmp + creturn;
        if (this.nullbyte) {
            tmp = (String)tmp + zeroscape;
        }
        return tmp;
    }
}

