/*
 * Decompiled with CFR 0.152.
 */
package org.dataverse.unf;

import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.dataverse.unf.BitString;
import org.dataverse.unf.UnfDateFormatter;
import org.dataverse.unf.UnfDigest;
import org.dataverse.unf.UnfException;

public class UNFUtil {
    public static String calculateUNF(double[] numb) throws NumberFormatException, UnfException, IOException {
        Number[][] mat = new Double[1][numb.length];
        for (int n = 0; n < numb.length; ++n) {
            mat[0][n] = numb[n];
        }
        UnfDigest.setTrnps(false);
        String[] res = UnfDigest.unf((Number[][])mat, (Integer[])new Integer[0]);
        return res[0];
    }

    public static String calculateUNF(float[] numb) throws NumberFormatException, UnfException, IOException {
        double[] toret = new double[numb.length];
        for (int k = 0; k < numb.length; ++k) {
            toret[k] = numb[k] == Float.NaN ? Double.NaN : (double)numb[k];
        }
        String res = UNFUtil.calculateUNF(toret);
        return res;
    }

    public static String calculateUNF(short[] numb) throws NumberFormatException, UnfException, IOException {
        double[] toret = new double[numb.length];
        for (int k = 0; k < numb.length; ++k) {
            toret[k] = numb[k] == Short.MAX_VALUE ? Double.NaN : (double)numb[k];
        }
        String res = UNFUtil.calculateUNF(toret);
        return res;
    }

    public static String calculateUNF(byte[] numb) throws NumberFormatException, UnfException, IOException {
        double[] toret = new double[numb.length];
        for (int k = 0; k < numb.length; ++k) {
            toret[k] = numb[k] == 127 ? Double.NaN : (double)numb[k];
        }
        String res = UNFUtil.calculateUNF(toret);
        return res;
    }

    public static String calculateUNF(long[] numb) throws NumberFormatException, UnfException, IOException {
        double[] toret = new double[numb.length];
        for (int k = 0; k < numb.length; ++k) {
            toret[k] = numb[k] == Long.MAX_VALUE ? Double.NaN : (double)numb[k];
        }
        String res = UNFUtil.calculateUNF(toret);
        return res;
    }

    public static String calculateUNF(int[] numb) throws NumberFormatException, UnfException, IOException {
        double[] toret = new double[numb.length];
        for (int k = 0; k < numb.length; ++k) {
            toret[k] = numb[k] == Integer.MAX_VALUE ? Double.NaN : (double)numb[k];
        }
        String res = UNFUtil.calculateUNF(toret);
        return res;
    }

    public static String calculateUNF(boolean[] numb) throws NumberFormatException, IOException {
        Boolean[] toret = new Boolean[numb.length];
        for (int k = 0; k < numb.length; ++k) {
            toret[k] = numb[k];
        }
        String[] res = UnfDigest.unf(toret);
        return res[0];
    }

    public static <T> String calculateUNF(List<T> numb) throws NumberFormatException, UnfException, IOException {
        if (numb.get(0) instanceof Number) {
            double[] arr = new double[numb.size()];
            int cnt = 0;
            for (String string : numb) {
                arr[cnt] = (Double)((Object)string);
                ++cnt;
            }
            return UNFUtil.calculateUNF(arr);
        }
        String[] topass = new String[numb.size()];
        topass = numb.toArray(new String[numb.size()]);
        return UNFUtil.calculateUNF(topass);
    }

    public static String calculateUNF(String[] chr) throws IOException, UnfException {
        String tosplit = ":";
        if (chr[0] != null) {
            String[] spres = chr[0].split(tosplit);
            if (spres.length >= 3 && chr[0].startsWith("UNF:")) {
                return UnfDigest.addUNFs(chr);
            }
            if (spres.length > 1) {
                // empty if block
            }
        }
        CharSequence[][] chseq = new CharSequence[1][chr.length];
        UnfDigest.setTrnps(false);
        int cnt = 0;
        for (String str : chr) {
            chseq[0][cnt] = str;
            ++cnt;
        }
        String[] res = UnfDigest.unf((CharSequence[][])chseq, (Integer[])new Integer[0]);
        return res[0];
    }

    public static String calculateUNF(String[] chr, String[] sdfFormat) throws IOException, UnfException {
        String tosplit = ":";
        if (chr[0] != null) {
            String[] spres = chr[0].split(tosplit);
            if (spres.length >= 3 && chr[0].startsWith("UNF:")) {
                return UnfDigest.addUNFs(chr);
            }
            if (spres.length > 1) {
                // empty if block
            }
        }
        CharSequence[][] chseq = new CharSequence[1][chr.length];
        UnfDigest.setTrnps(false);
        int cnt = 0;
        for (String str : chr) {
            if (sdfFormat[cnt] != null) {
                SimpleDateFormat sdf = new SimpleDateFormat(sdfFormat[cnt]);
                try {
                    Date d = sdf.parse(str);
                    UnfDateFormatter udf = new UnfDateFormatter(sdfFormat[cnt]);
                    SimpleDateFormat unfSdf = new SimpleDateFormat(udf.getUnfFormatString().toString());
                    if (udf.isTimeZoneSpecified()) {
                        unfSdf.setTimeZone(TimeZone.getTimeZone("UTC"));
                    }
                    str = unfSdf.format(d);
                    if (sdfFormat[cnt].indexOf("S") > -1 && str.endsWith("0")) {
                        while (str.endsWith("0")) {
                            str = str.substring(0, str.length() - 1);
                        }
                        if (str.endsWith(".")) {
                            str = str.substring(0, str.length() - 1);
                        }
                    }
                }
                catch (ParseException ex) {
                    Logger.getLogger(UNFUtil.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            chseq[0][cnt] = str;
            ++cnt;
        }
        String[] res = UnfDigest.unf((CharSequence[][])chseq, (Integer[])new Integer[0]);
        return res[0];
    }

    /*
     * WARNING - void declaration
     */
    public static String calculateUNF(String[] beginDate, String[] sdfFormat, String[] endDate) throws IOException, UnfException {
        String tosplit = ":";
        if (beginDate[0] != null) {
            String[] spres = beginDate[0].split(tosplit);
            if (spres.length >= 3 && beginDate[0].startsWith("UNF:")) {
                return UnfDigest.addUNFs(beginDate);
            }
            if (spres.length > 1) {
                // empty if block
            }
        }
        CharSequence[][] chseq = new CharSequence[1][beginDate.length];
        UnfDigest.setTrnps(false);
        int cnt = 0;
        for (String string : beginDate) {
            void var9_9;
            if (sdfFormat[cnt] != null) {
                SimpleDateFormat sdf = new SimpleDateFormat(sdfFormat[cnt]);
                try {
                    Date d = sdf.parse(string);
                    UnfDateFormatter udf = new UnfDateFormatter(sdfFormat[cnt]);
                    SimpleDateFormat unfSdf = new SimpleDateFormat(udf.getUnfFormatString().toString());
                    if (udf.isTimeZoneSpecified()) {
                        unfSdf.setTimeZone(TimeZone.getTimeZone("UTC"));
                    }
                    String string2 = unfSdf.format(d);
                    if (sdfFormat[cnt].indexOf("S") > -1 && string2.endsWith("0")) {
                        void var9_12;
                        while (var9_12.endsWith("0")) {
                            String string3 = var9_12.substring(0, var9_12.length() - 1);
                        }
                        if (var9_12.endsWith(".")) {
                            String string4 = var9_12.substring(0, var9_12.length() - 1);
                        }
                    }
                    if (endDate[cnt] != null) {
                        void var9_15;
                        String str2 = endDate[cnt];
                        Date endD = sdf.parse(str2);
                        str2 = unfSdf.format(endD);
                        if (sdfFormat[cnt].indexOf("S") > -1 && str2.endsWith("0")) {
                            while (str2.endsWith("0")) {
                                str2 = str2.substring(0, var9_15.length() - 1);
                            }
                            if (str2.endsWith(".")) {
                                str2 = str2.substring(0, str2.length() - 1);
                            }
                        }
                        String string5 = (String)var9_15 + "/" + str2;
                    }
                }
                catch (ParseException ex) {
                    Logger.getLogger(UNFUtil.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            chseq[0][cnt] = var9_9;
            ++cnt;
        }
        String[] res = UnfDigest.unf((CharSequence[][])chseq, (Integer[])new Integer[0]);
        return res[0];
    }

    public static String calculateUNF(double[][] numb) throws NumberFormatException, UnfException, IOException {
        int ncol = numb[0].length;
        List lst = Arrays.asList(numb);
        int nrw = lst.size();
        Number[][] pass = new Number[nrw][ncol];
        for (int r = 0; r < nrw; ++r) {
            for (int c = 0; c < ncol; ++c) {
                pass[r][c] = numb[r][c];
            }
        }
        String[] unfs = UnfDigest.unf((Number[][])pass, (Integer[])new Integer[0]);
        return UNFUtil.calculateUNF(unfs);
    }

    public static String calculateUNF(String[][] str) throws NumberFormatException, UnfException, IOException {
        int ncol = str[0].length;
        List lst = Arrays.asList(str);
        int nrw = lst.size();
        CharSequence[][] pass = new CharSequence[nrw][ncol];
        for (int r = 0; r < nrw; ++r) {
            for (int c = 0; c < ncol; ++c) {
                pass[r][c] = str[r][c];
            }
        }
        String[] unfs = UnfDigest.unf((CharSequence[][])pass, (Integer[])new Integer[0]);
        return UNFUtil.calculateUNF(unfs);
    }

    public static String calculateUNF(Number[] numb) throws IOException, UnfException {
        Number[][] mat = new Double[1][numb.length];
        for (int n = 0; n < numb.length; ++n) {
            mat[0][n] = numb[n] != null ? Double.valueOf(numb[n].doubleValue()) : null;
        }
        UnfDigest.setTrnps(false);
        String[] res = UnfDigest.unf((Number[][])mat, (Integer[])new Integer[0]);
        return res[0];
    }

    public static String calculateUNF(BitString[] numb) throws IOException {
        UnfDigest.setTrnps(false);
        String[] res = UnfDigest.unf(numb);
        return res[0];
    }
}

