/*
 * Decompiled with CFR 0.152.
 */
package org.datayoo.moql.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.datayoo.moql.io.Resource;
import org.datayoo.moql.util.ResourceUtils;
import org.datayoo.moql.util.StringFormater;

public abstract class AbstractResource
implements Resource {
    @Override
    public boolean exists() {
        try {
            return this.getFile().exists();
        }
        catch (IOException ex) {
            try {
                InputStream is = this.getInputStream();
                is.close();
                return true;
            }
            catch (Throwable isEx) {
                return false;
            }
        }
    }

    @Override
    public boolean isReadable() {
        return true;
    }

    @Override
    public URI getURI() throws IOException {
        URL url = this.getURL();
        try {
            return ResourceUtils.toURI(url);
        }
        catch (URISyntaxException ex) {
            IOException e = new IOException(StringFormater.format("Invalid URI '{}'!", url));
            e.initCause(ex);
            throw e;
        }
    }

    @Override
    public long lastModified() throws IOException {
        long lastModified = this.getFile2Check().lastModified();
        if (lastModified == 0L) {
            throw new FileNotFoundException(StringFormater.format("'{}' cannot be resolved in the file system for resolving its last-modified timestamp", this.getResourceLocation()));
        }
        return lastModified;
    }

    protected abstract File getFile2Check() throws IOException;

    public String toString() {
        return this.getResourceLocation();
    }
}

