/*
 * Decompiled with CFR 0.152.
 */
package org.datayoo.moql.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import org.datayoo.moql.io.AbstractResource;
import org.datayoo.moql.util.PathUtils;
import org.datayoo.moql.util.ResourceUtils;

public class UrlResource
extends AbstractResource {
    private final URL url;
    private final URL canonicalUrl;
    private final URI uri;

    public UrlResource(URL url) {
        this.url = url;
        this.canonicalUrl = this.getCanonicalUrl(this.url, url.toString());
        this.uri = null;
    }

    public UrlResource(URI uri) throws MalformedURLException {
        this.url = uri.toURL();
        this.canonicalUrl = this.getCanonicalUrl(this.url, uri.toString());
        this.uri = uri;
    }

    public UrlResource(String path) throws MalformedURLException {
        this.url = new URL(path);
        this.canonicalUrl = this.getCanonicalUrl(this.url, path);
        this.uri = null;
    }

    private URL getCanonicalUrl(URL originalUrl, String originalPath) {
        try {
            return new URL(PathUtils.toCanonicalPath(originalPath));
        }
        catch (MalformedURLException ex) {
            return originalUrl;
        }
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (this.url.getProtocol().equals("file")) {
            return new FileInputStream(this.url.getPath());
        }
        URLConnection con = this.url.openConnection();
        con.setUseCaches(false);
        return con.getInputStream();
    }

    @Override
    public URL getURL() throws IOException {
        return this.url;
    }

    @Override
    public URI getURI() throws IOException {
        if (this.uri != null) {
            return this.uri;
        }
        return super.getURI();
    }

    @Override
    public File getFile() throws IOException {
        if (this.uri != null) {
            return ResourceUtils.getFile(this.uri);
        }
        return ResourceUtils.getFile(this.url);
    }

    @Override
    protected File getFile2Check() throws IOException {
        if (ResourceUtils.isJarURL(this.url)) {
            URL actualUrl = ResourceUtils.extractJarFileURL(this.url);
            return ResourceUtils.getFile(actualUrl);
        }
        return this.getFile();
    }

    @Override
    public String getResourceName() {
        return new File(this.url.getFile()).getName();
    }

    @Override
    public String getResourceLocation() {
        return this.url.toString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof UrlResource) {
            UrlResource ur = (UrlResource)obj;
            return this.canonicalUrl.equals(ur.canonicalUrl);
        }
        return false;
    }

    public int hashCode() {
        return this.canonicalUrl.hashCode();
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        if (this.url.getProtocol().equals("file")) {
            return new FileOutputStream(this.url.getPath());
        }
        URLConnection con = this.url.openConnection();
        con.setUseCaches(false);
        return con.getOutputStream();
    }
}

