/*
 * Decompiled with CFR 0.152.
 */
package org.datayoo.moql.metadata;

import java.io.Serializable;
import org.apache.commons.lang3.Validate;
import org.datayoo.moql.ColumnDefinition;
import org.datayoo.moql.SelectorDefinition;
import org.datayoo.moql.metadata.CaseMetadata;
import org.datayoo.moql.metadata.SelectorValidator;

public class ColumnMetadata
implements ColumnDefinition,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String name;
    protected String value;
    protected SelectorDefinition nestedSelector;
    protected CaseMetadata caseMetadata;
    protected Object dataType;

    public ColumnMetadata(String name, String value) {
        Validate.notEmpty((CharSequence)name, (String)"Parameter 'name' is empty!", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)value, (String)"Parameter 'value' is empty!", (Object[])new Object[0]);
        if (name.indexOf(40) != -1) {
            int index = name.indexOf(44);
            if (index != -1) {
                name = name.substring(0, index);
                name = name + ')';
            }
            name = name.replace(" ", "");
            name = name.replace('(', '$');
            name = name.replace(')', '$');
            name = name.replace('.', '_');
        }
        this.name = name;
        this.value = value;
    }

    public ColumnMetadata(String name, SelectorDefinition nestedSelector) {
        Validate.notEmpty((CharSequence)name, (String)"Parameter 'name' is empty!", (Object[])new Object[0]);
        Validate.notNull((Object)nestedSelector, (String)"Parameter 'nestedSelector' is empty!", (Object[])new Object[0]);
        SelectorValidator.isValidateNestedColumnSelector(nestedSelector);
        this.name = name;
        this.nestedSelector = nestedSelector;
        this.value = "";
    }

    public ColumnMetadata(String name, CaseMetadata caseMetadata) {
        Validate.notEmpty((CharSequence)name, (String)"Parameter 'name' is empty!", (Object[])new Object[0]);
        Validate.notNull((Object)caseMetadata, (String)"Parameter 'caseMetadata' is empty!", (Object[])new Object[0]);
        this.name = name;
        this.caseMetadata = caseMetadata;
    }

    public boolean isHasAlias() {
        return !this.name.equals(this.value);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    public SelectorDefinition getNestedSelector() {
        return this.nestedSelector;
    }

    public CaseMetadata getCaseMetadata() {
        return this.caseMetadata;
    }

    public Object getDataType() {
        return this.dataType;
    }

    public void setDataType(Object dataType) {
        this.dataType = dataType;
    }
}

