/*
 * Decompiled with CFR 0.152.
 */
package org.datayoo.moql.metadata.xml;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.Validate;
import org.datayoo.moql.SelectorDefinition;
import org.datayoo.moql.metadata.CacheMetadata;
import org.datayoo.moql.metadata.CaseMetadata;
import org.datayoo.moql.metadata.ColumnMetadata;
import org.datayoo.moql.metadata.ColumnsMetadata;
import org.datayoo.moql.metadata.CombinationType;
import org.datayoo.moql.metadata.ConditionMetadata;
import org.datayoo.moql.metadata.DecorateMetadata;
import org.datayoo.moql.metadata.GroupMetadata;
import org.datayoo.moql.metadata.JoinMetadata;
import org.datayoo.moql.metadata.JoinType;
import org.datayoo.moql.metadata.LimitMetadata;
import org.datayoo.moql.metadata.LogicOperationMetadata;
import org.datayoo.moql.metadata.OperationMetadata;
import org.datayoo.moql.metadata.OperatorType;
import org.datayoo.moql.metadata.OrderMetadata;
import org.datayoo.moql.metadata.OrderType;
import org.datayoo.moql.metadata.ParenMetadata;
import org.datayoo.moql.metadata.QueryableMetadata;
import org.datayoo.moql.metadata.RelationOperationMetadata;
import org.datayoo.moql.metadata.SelectorMetadata;
import org.datayoo.moql.metadata.SetlectorMetadata;
import org.datayoo.moql.metadata.TableMetadata;
import org.datayoo.moql.metadata.TablesMetadata;
import org.datayoo.moql.metadata.WashoutStrategy;
import org.datayoo.moql.metadata.WhenMetadata;
import org.datayoo.moql.util.StringFormater;
import org.datayoo.moql.xml.XmlAccessException;
import org.datayoo.moql.xml.XmlElementFormater;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;

class XmlMetadataHelper {
    public static final String SELECTOR_ELEMENT = "selector";
    public static final String SETLECTOR_ELEMENT = "setlector";
    public static final String FILTER_ELEMENT = "filter";
    public static final String CACHE_ELEMENT = "cache";
    public static final String LIMIT_ELEMENT = "limit";
    public static final String COLUMNS_ELEMENT = "columns";
    public static final String COLUMN_ELEMENT = "column";
    public static final String CASE_ELEMENT = "case";
    public static final String WHEN_ELEMENT = "when";
    public static final String TABLES_ELEMENT = "tables";
    public static final String TABLE_ELEMENT = "table";
    public static final String JOIN_ELEMENT = "join";
    public static final String ON_ELEMENT = "on";
    public static final String SETS_ELEMENT = "sets";
    public static final String WHERE_ELEMENT = "where";
    public static final String GROUPBY_ELEMENT = "groupby";
    public static final String GROUP_ELEMENT = "group";
    public static final String HAVING_ELEMENT = "having";
    public static final String ORDERBY_ELEMENT = "orderby";
    public static final String DECORATORS_ELEMENT = "decorators";
    public static final String DECORATEBY_ELEMENT = "decorateby";
    public static final String ORDER_ELEMENT = "order";
    public static final String NOT_ELEMENT = "not";
    public static final String AND_ELEMENT = "and";
    public static final String OR_ELEMENT = "or";
    public static final String PAREN_ELEMENT = "paren";
    public static final String UNARY_ELEMENT = "unary";
    public static final String BINARY_ELEMENT = "binary";
    public static final String COMBINATION_ATTRIBUTE = "combination";
    public static final String SIZE_ATTRIBUTE = "size";
    public static final String WASHOUT_ATTRIBUTE = "washout";
    public static final String VALUE_ATTRIBUTE = "value";
    public static final String DISTINCT_ATTRIBUTE = "distinct";
    public static final String NAME_ATTRIBUTE = "name";
    public static final String OPERAND_ATTRIBUTE = "operand";
    public static final String LEFT_OPERAND_ATTRIBUTE = "loperand";
    public static final String RIGHT_OPERAND_ATTRIBUTE = "roperand";
    public static final String OPERATOR_ATTRIBUTE = "operator";
    public static final String COLUMN_ATTRIBUTE = "column";
    public static final String ELSE_ATTRIBUTE = "else";
    public static final String THEN_ATTRIBUTE = "then";
    public static final String MODE_ATTRIBUTE = "mode";
    public static final String OFFSET_ATTRIBUTE = "offset";
    public static final String DECORATOR_ATTRIBUTE = "decorator";
    protected Map<String, XmlElementFormater<Object>> extendedElementFormaters = new HashMap<String, XmlElementFormater<Object>>();

    XmlMetadataHelper() {
    }

    public SelectorDefinition readSelectorDefinition(Element element) throws XmlAccessException {
        Validate.notNull((Object)element, (String)"Parameter 'element' is null!", (Object[])new Object[0]);
        if (!element.getName().equals(SELECTOR_ELEMENT) && !element.getName().equals(SETLECTOR_ELEMENT)) {
            throw new IllegalArgumentException(StringFormater.format("Invalid element '{}'!", element.getName()));
        }
        if (element.getName().equals(SELECTOR_ELEMENT)) {
            return this.readSelectorMetadata(element);
        }
        return this.readSetlectorMetadata(element);
    }

    protected String getAttribute(Element element, String attribute, boolean option) throws XmlAccessException {
        Attribute attr = element.attribute(attribute);
        if (attr != null) {
            return attr.getValue();
        }
        if (option) {
            return null;
        }
        throw new XmlAccessException(StringFormater.format("There is no attribute '{}' in element '{}'!", attribute, element.getName()));
    }

    protected String getElementText(Element element, String textElement, boolean option) throws XmlAccessException {
        Element el = element.element(textElement);
        if (el != null) {
            return el.getTextTrim();
        }
        if (option) {
            return null;
        }
        throw new XmlAccessException(StringFormater.format("There is no element '{}' in element '{}'!", textElement, element.getName()));
    }

    protected SelectorMetadata readSelectorMetadata(Element element) throws XmlAccessException {
        SelectorMetadata selector = new SelectorMetadata();
        this.readSelectorMetadata(element, selector);
        return selector;
    }

    protected void readSelectorMetadata(Element element, SelectorMetadata selector) throws XmlAccessException {
        Iterator it = element.elementIterator();
        while (it.hasNext()) {
            Element el = (Element)it.next();
            if (el.getName().equals(CACHE_ELEMENT)) {
                CacheMetadata cache = this.readCacheMetadata(el);
                selector.setCache(cache);
                continue;
            }
            if (el.getName().equals(COLUMNS_ELEMENT)) {
                ColumnsMetadata columns = this.readColumnsMetadata(el);
                selector.setColumns(columns);
                continue;
            }
            if (el.getName().equals(TABLES_ELEMENT)) {
                TablesMetadata tables = this.readTablesMetadata(el);
                selector.setTables(tables);
                continue;
            }
            if (el.getName().equals(WHERE_ELEMENT)) {
                ConditionMetadata where = this.innerReadConditionMetadata(el);
                selector.setWhere(where);
                continue;
            }
            if (el.getName().equals(GROUPBY_ELEMENT)) {
                List<GroupMetadata> groups = this.readGroupBy(el);
                selector.setGroupBy(groups);
                continue;
            }
            if (el.getName().equals(HAVING_ELEMENT)) {
                ConditionMetadata having = this.innerReadConditionMetadata(el);
                selector.setHaving(having);
                continue;
            }
            if (el.getName().equals(ORDERBY_ELEMENT)) {
                List<OrderMetadata> orders = this.readOrderBy(el);
                selector.setOrderBy(orders);
                continue;
            }
            if (el.getName().equals(LIMIT_ELEMENT)) {
                LimitMetadata limit = this.readLimitMetadata(el);
                selector.setLimit(limit);
                continue;
            }
            if (!el.getName().equals(DECORATORS_ELEMENT)) continue;
            List<DecorateMetadata> decorateMetadatas = this.readDecorateMetadatas(el);
            selector.setDecorateBy(decorateMetadatas);
        }
    }

    protected CacheMetadata readCacheMetadata(Element element) throws XmlAccessException {
        String value = this.getAttribute(element, SIZE_ATTRIBUTE, false);
        CacheMetadata cacheMetadata = new CacheMetadata(Integer.valueOf(value));
        value = this.getAttribute(element, WASHOUT_ATTRIBUTE, true);
        if (value != null) {
            cacheMetadata.setWashoutStrategy(WashoutStrategy.valueOf(value));
        }
        return cacheMetadata;
    }

    protected ColumnsMetadata readColumnsMetadata(Element element) throws XmlAccessException {
        ColumnsMetadata columnsMetadata = new ColumnsMetadata();
        String value = this.getAttribute(element, DISTINCT_ATTRIBUTE, true);
        if (value != null) {
            columnsMetadata.setDistinct(Boolean.valueOf(value));
        }
        LinkedList<ColumnMetadata> columns = new LinkedList<ColumnMetadata>();
        Iterator it = element.elementIterator("column");
        while (it.hasNext()) {
            Element el = (Element)it.next();
            ColumnMetadata column = this.readColumnMetadata(el);
            columns.add(column);
        }
        columnsMetadata.setColumns(columns);
        return columnsMetadata;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected ColumnMetadata readColumnMetadata(Element element) throws XmlAccessException {
        String name = this.getAttribute(element, NAME_ATTRIBUTE, false);
        String value = this.getAttribute(element, VALUE_ATTRIBUTE, true);
        if (value != null) return new ColumnMetadata(name, value);
        Element el = element.element(SELECTOR_ELEMENT);
        if (el != null) {
            SelectorDefinition nestedSelector = this.readColumnSelectorMetadata(el);
            return new ColumnMetadata(name, nestedSelector);
        }
        el = element.element(CASE_ELEMENT);
        if (el == null) throw new XmlAccessException(StringFormater.format("Invalid element '{}' has no selector, setlector or case element!", element.getName()));
        CaseMetadata caseMetadata = this.readCaseMetadata(el);
        return new ColumnMetadata(name, caseMetadata);
    }

    protected SelectorDefinition readColumnSelectorMetadata(Element el) throws XmlAccessException {
        if (el.getName().equals(SELECTOR_ELEMENT)) {
            SelectorMetadata columnSelector = new SelectorMetadata();
            this.readSelectorMetadata(el, columnSelector);
            return columnSelector;
        }
        SetlectorMetadata columnSelector = new SetlectorMetadata();
        this.readSetlectorMetadata(el, columnSelector);
        return columnSelector;
    }

    protected CaseMetadata readCaseMetadata(Element el) throws XmlAccessException {
        LinkedList<WhenMetadata> whenMetadatas = new LinkedList<WhenMetadata>();
        String elseText = null;
        Attribute attr = el.attribute(ELSE_ATTRIBUTE);
        elseText = attr.getValue();
        for (Element e : el.elements()) {
            WhenMetadata whenMetadata = this.readWhenMetadata(e);
            whenMetadatas.add(whenMetadata);
        }
        return new CaseMetadata(whenMetadatas, elseText);
    }

    protected WhenMetadata readWhenMetadata(Element el) throws XmlAccessException {
        String then = el.attributeValue(THEN_ATTRIBUTE);
        OperationMetadata when = this.readOperationMetadata(el);
        return new WhenMetadata(when, then);
    }

    protected TablesMetadata readTablesMetadata(Element element) throws XmlAccessException {
        LinkedList<QueryableMetadata> tables = new LinkedList<QueryableMetadata>();
        Iterator it = element.elementIterator();
        while (it.hasNext()) {
            Element el = (Element)it.next();
            if (el.getName().equals(TABLE_ELEMENT)) {
                TableMetadata tableMetadata = this.readTableMetadata(el);
                tables.add(tableMetadata);
                continue;
            }
            if (el.getName().equals(JOIN_ELEMENT)) {
                JoinMetadata joinMetadata = this.readJoinMetadata(el);
                tables.add(joinMetadata);
                continue;
            }
            throw new XmlAccessException(StringFormater.format("Invalid element '{}' in element '{}'!", element.getName(), TABLES_ELEMENT));
        }
        return new TablesMetadata(tables);
    }

    protected TableMetadata readTableMetadata(Element element) throws XmlAccessException {
        TableMetadata table;
        String name = this.getAttribute(element, NAME_ATTRIBUTE, false);
        String value = this.getAttribute(element, VALUE_ATTRIBUTE, true);
        if (value == null) {
            List elements = element.elements();
            if (elements == null || elements.size() == 0) {
                throw new XmlAccessException(StringFormater.format("Invalid element '{}' has no selector,setlector or reference element!", element.getName()));
            }
            Element el = (Element)elements.get(0);
            if (el.getName().equals(SELECTOR_ELEMENT)) {
                SelectorMetadata nestedSelector = new SelectorMetadata();
                this.readSelectorMetadata(el, nestedSelector);
                table = new TableMetadata(name, nestedSelector);
            } else {
                SetlectorMetadata nestedSelector = new SetlectorMetadata();
                this.readSetlectorMetadata(el, nestedSelector);
                table = new TableMetadata(name, nestedSelector);
            }
        } else {
            table = new TableMetadata(name, value);
        }
        return table;
    }

    protected JoinMetadata readJoinMetadata(Element element) throws XmlAccessException {
        String value = this.getAttribute(element, MODE_ATTRIBUTE, false);
        JoinType joinType = JoinType.valueOf(value);
        Serializable lQueryable = null;
        Serializable rQueryable = null;
        ConditionMetadata condition = null;
        Iterator it = element.elementIterator();
        while (it.hasNext()) {
            Element el = (Element)it.next();
            if (el.getName().equals(TABLE_ELEMENT)) {
                if (lQueryable == null) {
                    lQueryable = this.readTableMetadata(el);
                    continue;
                }
                rQueryable = this.readTableMetadata(el);
                continue;
            }
            if (el.getName().equals(JOIN_ELEMENT)) {
                if (lQueryable == null) {
                    lQueryable = this.readJoinMetadata(el);
                    continue;
                }
                rQueryable = this.readJoinMetadata(el);
                continue;
            }
            if (el.getName().equals(ON_ELEMENT)) {
                condition = this.innerReadConditionMetadata(el);
                continue;
            }
            throw new XmlAccessException(StringFormater.format("Invalid element '{}' in element '{}'!", element.getName(), TABLES_ELEMENT));
        }
        JoinMetadata join = new JoinMetadata(joinType, (QueryableMetadata)((Object)lQueryable), (QueryableMetadata)((Object)rQueryable));
        if (condition != null) {
            join.setOn(condition);
        }
        return join;
    }

    protected ConditionMetadata innerReadConditionMetadata(Element element) throws XmlAccessException {
        OperationMetadata operation = this.readOperationMetadata(element);
        return new ConditionMetadata(operation);
    }

    protected OperationMetadata readOperationMetadata(Element element) throws XmlAccessException {
        Iterator it = element.elementIterator();
        if (it.hasNext()) {
            Element el = (Element)it.next();
            if (el.getName().equals(AND_ELEMENT)) {
                return this.readLogicOperationMetadata(el);
            }
            if (el.getName().equals(OR_ELEMENT)) {
                return this.readLogicOperationMetadata(el);
            }
            if (el.getName().equals(NOT_ELEMENT)) {
                return this.readLogicOperationMetadata(el);
            }
            if (el.getName().equals(PAREN_ELEMENT)) {
                return this.readParenMetadata(el);
            }
            if (el.getName().equals(UNARY_ELEMENT)) {
                return this.readUnaryRelationOperationMetadata(el);
            }
            if (el.getName().equals(BINARY_ELEMENT)) {
                return this.readBinaryRelationOperationMetadata(el);
            }
            throw new XmlAccessException(StringFormater.format("Invalid operation element '{}' in condition element '{}'!", el.getName(), element.getName()));
        }
        throw new XmlAccessException(StringFormater.format("Invalid condition element '{}' !", element.getName()));
    }

    protected LogicOperationMetadata readLogicOperationMetadata(Element element) throws XmlAccessException {
        String operator;
        int size = 1;
        if (element.getName().equals(AND_ELEMENT) || element.getName().equals(OR_ELEMENT)) {
            size = 2;
            operator = element.getName();
        } else {
            operator = element.getName();
        }
        OperationMetadata[] operands = new OperationMetadata[size];
        int inx = 0;
        Iterator it = element.elementIterator();
        while (it.hasNext()) {
            Element el = (Element)it.next();
            if (el.getName().equals(AND_ELEMENT)) {
                operands[inx] = this.readLogicOperationMetadata(el);
            } else if (el.getName().equals(OR_ELEMENT)) {
                operands[inx] = this.readLogicOperationMetadata(el);
            } else if (el.getName().equals(NOT_ELEMENT)) {
                operands[inx] = this.readLogicOperationMetadata(el);
            } else if (el.getName().equals(PAREN_ELEMENT)) {
                operands[inx] = this.readParenMetadata(el);
            } else if (el.getName().equals(UNARY_ELEMENT)) {
                operands[inx] = this.readUnaryRelationOperationMetadata(el);
            } else if (el.getName().equals(BINARY_ELEMENT)) {
                operands[inx] = this.readBinaryRelationOperationMetadata(el);
            } else {
                throw new XmlAccessException(StringFormater.format("Invalid operation element '{}' !", el.getName()));
            }
            if (++inx != size) continue;
            break;
        }
        if (inx == 0) {
            throw new XmlAccessException(StringFormater.format("Invalid operation element '{}' !", element.getName()));
        }
        if (size == 1) {
            return new LogicOperationMetadata(operator, operands[0]);
        }
        return new LogicOperationMetadata(operator, operands[0], operands[1]);
    }

    protected ParenMetadata readParenMetadata(Element element) throws XmlAccessException {
        OperationMetadata operationMetadata = this.readOperationMetadata(element);
        return new ParenMetadata(operationMetadata);
    }

    protected RelationOperationMetadata readBinaryRelationOperationMetadata(Element element) throws XmlAccessException {
        RelationOperationMetadata relation;
        String operator = this.getAttribute(element, OPERATOR_ATTRIBUTE, false);
        String lOperand = this.getAttribute(element, LEFT_OPERAND_ATTRIBUTE, false);
        String rOperand = this.getAttribute(element, RIGHT_OPERAND_ATTRIBUTE, true);
        if (rOperand == null) {
            SelectorDefinition nestedSelector = this.readColumnSelectorMetadata(element);
            relation = new RelationOperationMetadata(operator, lOperand, nestedSelector);
        } else {
            relation = new RelationOperationMetadata(operator, lOperand, rOperand);
        }
        return relation;
    }

    protected RelationOperationMetadata readUnaryRelationOperationMetadata(Element element) throws XmlAccessException {
        RelationOperationMetadata relation;
        String operator = this.getAttribute(element, OPERATOR_ATTRIBUTE, false);
        String operand = this.getAttribute(element, OPERAND_ATTRIBUTE, true);
        if (operand == null) {
            Element el = element.element(SELECTOR_ELEMENT);
            SelectorDefinition nestedSelector = this.readColumnSelectorMetadata(el);
            relation = new RelationOperationMetadata(operator, nestedSelector);
        } else {
            relation = new RelationOperationMetadata(operator, operand);
        }
        return relation;
    }

    protected List<GroupMetadata> readGroupBy(Element element) throws XmlAccessException {
        LinkedList<GroupMetadata> groups = new LinkedList<GroupMetadata>();
        Iterator it = element.elementIterator(GROUP_ELEMENT);
        while (it.hasNext()) {
            Element el = (Element)it.next();
            String column = this.getAttribute(el, "column", false);
            GroupMetadata group = new GroupMetadata(column);
            groups.add(group);
        }
        return groups;
    }

    protected List<OrderMetadata> readOrderBy(Element element) throws XmlAccessException {
        LinkedList<OrderMetadata> orders = new LinkedList<OrderMetadata>();
        Iterator it = element.elementIterator(ORDER_ELEMENT);
        while (it.hasNext()) {
            Element el = (Element)it.next();
            OrderMetadata order = this.readOrderMetadata(el);
            orders.add(order);
        }
        return orders;
    }

    protected OrderMetadata readOrderMetadata(Element element) throws XmlAccessException {
        String column = this.getAttribute(element, "column", false);
        OrderMetadata order = new OrderMetadata(column);
        String value = this.getAttribute(element, MODE_ATTRIBUTE, true);
        if (value != null) {
            order.setOrderType(OrderType.valueOf(value));
        }
        return order;
    }

    protected LimitMetadata readLimitMetadata(Element element) throws XmlAccessException {
        String value = this.getAttribute(element, OFFSET_ATTRIBUTE, true);
        int startPos = 0;
        if (value != null) {
            startPos = Integer.valueOf(value);
        }
        value = this.getAttribute(element, VALUE_ATTRIBUTE, false);
        boolean percent = false;
        if (value.charAt(value.length() - 1) == '%') {
            value = value.substring(0, value.length() - 1);
            percent = true;
        }
        LimitMetadata limitMetadata = new LimitMetadata(startPos, Integer.valueOf(value), percent);
        return limitMetadata;
    }

    protected List<DecorateMetadata> readDecorateMetadatas(Element element) throws XmlAccessException {
        LinkedList<DecorateMetadata> decorateMetadatas = new LinkedList<DecorateMetadata>();
        Iterator it = element.elementIterator(DECORATOR_ATTRIBUTE);
        while (it.hasNext()) {
            Element el = (Element)it.next();
            String value = this.getAttribute(el, DECORATOR_ATTRIBUTE, false);
            DecorateMetadata decorateMetadata = new DecorateMetadata(value);
            decorateMetadatas.add(decorateMetadata);
        }
        return decorateMetadatas;
    }

    protected SetlectorMetadata readSetlectorMetadata(Element element) throws XmlAccessException {
        SetlectorMetadata setlector = new SetlectorMetadata();
        this.readSetlectorMetadata(element, setlector);
        return setlector;
    }

    protected void readSetlectorMetadata(Element element, SetlectorMetadata setlector) throws XmlAccessException {
        String value = this.getAttribute(element, COMBINATION_ATTRIBUTE, true);
        if (value != null) {
            setlector.setCombinationType(CombinationType.valueOf(value));
        }
        Iterator it = element.elementIterator();
        while (it.hasNext()) {
            Element el = (Element)it.next();
            if (el.getName().equals(COLUMNS_ELEMENT)) {
                ColumnsMetadata columns = this.readColumnsMetadata(el);
                setlector.setColumns(columns);
                continue;
            }
            if (el.getName().equals(SETS_ELEMENT)) {
                List<SelectorDefinition> sets = this.readSets(el);
                setlector.setSets(sets);
                continue;
            }
            if (el.getName().equals(ORDERBY_ELEMENT)) {
                List<OrderMetadata> orders = this.readOrderBy(el);
                setlector.setOrderBy(orders);
                continue;
            }
            throw new XmlAccessException(StringFormater.format("Invalid element '{}' in element '{}'!", el.getName(), element.getName()));
        }
    }

    protected List<SelectorDefinition> readSets(Element element) throws XmlAccessException {
        LinkedList<SelectorDefinition> sets = new LinkedList<SelectorDefinition>();
        int i = 0;
        Iterator it = element.elementIterator();
        while (it.hasNext()) {
            Element el = (Element)it.next();
            if (el.getName().equals(SELECTOR_ELEMENT)) {
                SelectorMetadata nestedSelector = new SelectorMetadata();
                this.readSelectorMetadata(el, nestedSelector);
                sets.add(nestedSelector);
            } else if (el.getName().equals(SETLECTOR_ELEMENT)) {
                SetlectorMetadata nestedSetlector = new SetlectorMetadata();
                this.readSetlectorMetadata(el, nestedSetlector);
                sets.add(nestedSetlector);
            } else {
                throw new XmlAccessException(StringFormater.format("Invalid element '{}' in element '{}'!", el.getName(), element.getName()));
            }
            if (++i != 2) continue;
            break;
        }
        if (i != 2) {
            throw new XmlAccessException(StringFormater.format("Invalid element '{}'!", element.getName()));
        }
        return sets;
    }

    public ConditionMetadata readConditionMetadata(Element element) throws XmlAccessException {
        OperationMetadata operation = this.readOperationMetadata(element);
        return new ConditionMetadata(operation);
    }

    public Element writeSelectorDefinition(Element element, SelectorDefinition selectorDefinition) throws XmlAccessException {
        Validate.notNull((Object)selectorDefinition, (String)"Parameter 'selectorDefinition' is null!", (Object[])new Object[0]);
        if (selectorDefinition instanceof SelectorMetadata) {
            return this.writeSelectorMetadata(element, (SelectorMetadata)selectorDefinition);
        }
        return this.writeSetlectorMetadata(element, (SetlectorMetadata)selectorDefinition);
    }

    protected Element createElement(Element element, String rootName) {
        Element elRoot = null;
        if (element != null) {
            elRoot = element.addElement(rootName);
        } else {
            Document doc = DocumentHelper.createDocument();
            elRoot = doc.addElement(rootName, "http://www.datayoo.org/schema/moql");
            elRoot.add(new Namespace("xsi", "http://www.w3.org/2001/XMLSchema-instance"));
            elRoot.addAttribute("xsi:schemaLocation", "http://www.datayoo.org/schema/moql selector-base.xsd");
        }
        return elRoot;
    }

    protected Element writeSelectorMetadata(Element element, SelectorMetadata selector) throws XmlAccessException {
        Element elSelector = this.createElement(element, SELECTOR_ELEMENT);
        this.writeNestedSelectorMetadataWithoutId(elSelector, selector);
        return elSelector;
    }

    protected void writeNestedSelectorMetadataWithoutId(Element element, SelectorMetadata selector) throws XmlAccessException {
        this.writeCacheMetadata(element, selector.getCache());
        this.writeColumnsMetadata(element, selector.getColumns());
        this.writeTablesMetadata(element, selector.getTables());
        if (selector.getWhere() != null) {
            this.innerWriteConditionMetadata(element, WHERE_ELEMENT, selector.getWhere());
        }
        if (selector.getGroupBy() != null) {
            this.writeGroupBy(element, selector.getGroupBy());
        }
        if (selector.getHaving() != null) {
            this.innerWriteConditionMetadata(element, HAVING_ELEMENT, selector.getHaving());
        }
        if (selector.getOrderBy() != null) {
            this.writeOrderBy(element, selector.getOrderBy());
        }
        if (selector.getLimit() != null) {
            this.writeLimitMetadata(element, selector.getLimit());
        }
        if (selector.getDecorateBy() != null && selector.getDecorateBy().size() > 0) {
            this.writeDecorateMetadatas(element, selector.getDecorateBy());
        }
    }

    protected void writeCacheMetadata(Element element, CacheMetadata cache) {
        Element elCache = element.addElement(CACHE_ELEMENT);
        elCache.addAttribute(SIZE_ATTRIBUTE, String.valueOf(cache.getSize()));
        if (cache.getWashoutStrategy() != WashoutStrategy.FIFO) {
            elCache.addAttribute(WASHOUT_ATTRIBUTE, cache.getWashoutStrategy().name());
        }
    }

    protected void writeColumnsMetadata(Element element, ColumnsMetadata columns) throws XmlAccessException {
        Element elColumns = element.addElement(COLUMNS_ELEMENT);
        if (columns.isDistinct()) {
            elColumns.addAttribute(DISTINCT_ATTRIBUTE, String.valueOf(columns.isDistinct()));
        }
        for (ColumnMetadata column : columns.getColumns()) {
            this.writeColumnMetadata(elColumns, column);
        }
    }

    protected void writeColumnMetadata(Element element, ColumnMetadata column) throws XmlAccessException {
        Element elColumn = element.addElement("column");
        elColumn.addAttribute(NAME_ATTRIBUTE, column.getName());
        if (column.getNestedSelector() != null) {
            SelectorDefinition selectorDefinition = column.getNestedSelector();
            if (selectorDefinition instanceof SelectorMetadata) {
                Element elSelector = elColumn.addElement(SELECTOR_ELEMENT);
                this.writeNestedSelectorMetadataWithoutId(elSelector, (SelectorMetadata)selectorDefinition);
            } else {
                Element elSelector = elColumn.addElement(SETLECTOR_ELEMENT);
                this.writeSetlectorMetadataWithoutId(elSelector, (SetlectorMetadata)selectorDefinition);
            }
        } else if (column.getCaseMetadata() != null) {
            this.writeCaseMetadata(elColumn, column.getCaseMetadata());
        } else if (column.getValue() != null) {
            elColumn.addAttribute(VALUE_ATTRIBUTE, column.getValue());
        }
    }

    protected void writeCaseMetadata(Element element, CaseMetadata caseMetadata) throws XmlAccessException {
        Element caseElement = element.addElement(CASE_ELEMENT);
        caseElement.addAttribute(ELSE_ATTRIBUTE, caseMetadata.getElseMetadata());
        for (WhenMetadata whenMetadata : caseMetadata.getWhenMetadatas()) {
            Element elWhen = caseElement.addElement(WHEN_ELEMENT);
            elWhen.addAttribute(THEN_ATTRIBUTE, whenMetadata.getThenMetadata());
            this.writeOperationMetadata(elWhen, whenMetadata.getWhenMetadata());
        }
    }

    protected void writeTablesMetadata(Element element, TablesMetadata tables) throws XmlAccessException {
        Element elTables = element.addElement(TABLES_ELEMENT);
        for (QueryableMetadata queryableMetadata : tables.getTables()) {
            if (queryableMetadata instanceof TableMetadata) {
                this.writeTableMetadata(elTables, (TableMetadata)queryableMetadata);
                continue;
            }
            this.writeJoinMetadata(elTables, (JoinMetadata)queryableMetadata);
        }
    }

    protected void writeTableMetadata(Element element, TableMetadata table) throws XmlAccessException {
        Element elTable = element.addElement(TABLE_ELEMENT);
        elTable.addAttribute(NAME_ATTRIBUTE, table.getName());
        if (table.getValue() != null) {
            elTable.addAttribute(VALUE_ATTRIBUTE, table.getValue());
        } else {
            SelectorDefinition nestedSelector = table.getNestedSelector();
            if (nestedSelector instanceof SelectorMetadata) {
                Element elSelector = elTable.addElement(SELECTOR_ELEMENT);
                this.writeNestedSelectorMetadataWithoutId(elSelector, (SelectorMetadata)nestedSelector);
            } else {
                Element elSelector = elTable.addElement(SETLECTOR_ELEMENT);
                this.writeSetlectorMetadataWithoutId(elSelector, (SetlectorMetadata)nestedSelector);
            }
        }
    }

    protected void writeJoinMetadata(Element element, JoinMetadata join) throws XmlAccessException {
        Element elJoin = element.addElement(JOIN_ELEMENT);
        elJoin.addAttribute(MODE_ATTRIBUTE, join.getJoinType().name());
        QueryableMetadata queryable = join.getLQueryable();
        if (queryable instanceof TableMetadata) {
            this.writeTableMetadata(elJoin, (TableMetadata)queryable);
        } else {
            this.writeJoinMetadata(elJoin, (JoinMetadata)queryable);
        }
        queryable = join.getRQueryable();
        if (queryable instanceof TableMetadata) {
            this.writeTableMetadata(elJoin, (TableMetadata)queryable);
        } else {
            this.writeJoinMetadata(elJoin, (JoinMetadata)queryable);
        }
        if (join.getOn() != null) {
            this.innerWriteConditionMetadata(elJoin, ON_ELEMENT, join.getOn());
        }
    }

    protected void innerWriteConditionMetadata(Element element, String elementName, ConditionMetadata condition) throws XmlAccessException {
        Element elCondition = element.addElement(elementName);
        this.writeOperationMetadata(elCondition, condition.getOperation());
    }

    protected Element writeOperationMetadata(Element element, OperationMetadata operation) throws XmlAccessException {
        if (operation instanceof LogicOperationMetadata) {
            return this.writeLogicOperationMetadata(element, (LogicOperationMetadata)operation);
        }
        return this.writeRelationOperationMetadata(element, (RelationOperationMetadata)operation);
    }

    protected Element writeLogicOperationMetadata(Element element, LogicOperationMetadata operation) throws XmlAccessException {
        Element elLogic = operation.getOperator().equals(AND_ELEMENT) ? element.addElement(AND_ELEMENT) : (operation.getOperator().equals(OR_ELEMENT) ? element.addElement(OR_ELEMENT) : element.addElement(NOT_ELEMENT));
        if (operation.getOperatorType() == OperatorType.UNARY) {
            if (operation.getRightOperand() instanceof LogicOperationMetadata) {
                this.writeLogicOperationMetadata(elLogic, (LogicOperationMetadata)operation.getRightOperand());
            } else {
                this.writeRelationOperationMetadata(elLogic, (RelationOperationMetadata)operation.getRightOperand());
            }
        } else {
            if (operation.getLeftOperand() instanceof LogicOperationMetadata) {
                this.writeLogicOperationMetadata(elLogic, (LogicOperationMetadata)operation.getLeftOperand());
            } else if (operation.getLeftOperand() instanceof RelationOperationMetadata) {
                this.writeRelationOperationMetadata(elLogic, (RelationOperationMetadata)operation.getLeftOperand());
            } else {
                this.writeParenMetadata(elLogic, (ParenMetadata)operation.getLeftOperand());
            }
            if (operation.getRightOperand() instanceof LogicOperationMetadata) {
                this.writeLogicOperationMetadata(elLogic, (LogicOperationMetadata)operation.getRightOperand());
            } else if (operation.getRightOperand() instanceof RelationOperationMetadata) {
                this.writeRelationOperationMetadata(elLogic, (RelationOperationMetadata)operation.getRightOperand());
            } else {
                this.writeParenMetadata(elLogic, (ParenMetadata)operation.getRightOperand());
            }
        }
        return elLogic;
    }

    protected Element writeRelationOperationMetadata(Element element, RelationOperationMetadata operation) throws XmlAccessException {
        Element elRelation;
        boolean unary = false;
        if (operation.getOperatorType() == OperatorType.UNARY) {
            elRelation = element.addElement(UNARY_ELEMENT);
            unary = true;
        } else {
            elRelation = element.addElement(BINARY_ELEMENT);
            elRelation.addAttribute(LEFT_OPERAND_ATTRIBUTE, operation.getLeftOperand());
        }
        elRelation.addAttribute(OPERATOR_ATTRIBUTE, operation.getOperator());
        if (operation.getRightOperand() != null) {
            if (unary) {
                elRelation.addAttribute(OPERAND_ATTRIBUTE, operation.getRightOperand());
            } else {
                elRelation.addAttribute(RIGHT_OPERAND_ATTRIBUTE, operation.getRightOperand());
            }
        } else {
            SelectorDefinition selectorDefinition = operation.getNestedSelector();
            if (selectorDefinition instanceof SelectorMetadata) {
                Element elSelector = elRelation.addElement(SELECTOR_ELEMENT);
                this.writeNestedSelectorMetadataWithoutId(elSelector, (SelectorMetadata)selectorDefinition);
            } else {
                Element elSelector = elRelation.addElement(SETLECTOR_ELEMENT);
                this.writeSetlectorMetadataWithoutId(elSelector, (SetlectorMetadata)selectorDefinition);
            }
        }
        return elRelation;
    }

    protected Element writeParenMetadata(Element element, ParenMetadata operation) throws XmlAccessException {
        Element elParen = element.addElement(PAREN_ELEMENT);
        this.writeOperationMetadata(elParen, operation.getOperand());
        return elParen;
    }

    protected void writeGroupBy(Element element, List<GroupMetadata> groupBy) {
        Element elGroupBy = element.addElement(GROUPBY_ELEMENT);
        for (GroupMetadata group : groupBy) {
            Element elGroup = elGroupBy.addElement(GROUP_ELEMENT);
            elGroup.addAttribute("column", group.getColumn());
        }
    }

    protected void writeOrderBy(Element element, List<OrderMetadata> orderBy) {
        Element elOrderBy = element.addElement(ORDERBY_ELEMENT);
        for (OrderMetadata order : orderBy) {
            Element elOrder = elOrderBy.addElement(ORDER_ELEMENT);
            elOrder.addAttribute("column", order.getColumn());
            if (order.getOrderType() != OrderType.ASC) continue;
            elOrder.addAttribute(MODE_ATTRIBUTE, order.getOrderType().name());
        }
    }

    protected void writeLimitMetadata(Element element, LimitMetadata limit) {
        Element elLimit = element.addElement(LIMIT_ELEMENT);
        if (limit.getOffset() != 0) {
            elLimit.addAttribute(OFFSET_ATTRIBUTE, String.valueOf(limit.getOffset()));
        }
        String value = String.valueOf(limit.getValue());
        if (limit.isPercent()) {
            value = value + '%';
        }
        elLimit.addAttribute(VALUE_ATTRIBUTE, value);
    }

    protected void writeDecorateMetadatas(Element element, List<DecorateMetadata> decorateMetadatas) {
        Element elDecorators = element.addElement(DECORATORS_ELEMENT);
        for (DecorateMetadata decorateMetadata : decorateMetadatas) {
            Element el = elDecorators.addElement(DECORATEBY_ELEMENT);
            el.addAttribute(DECORATOR_ATTRIBUTE, decorateMetadata.getDecorator());
        }
    }

    protected Element writeSetlectorMetadata(Element element, SetlectorMetadata setlector) throws XmlAccessException {
        Element elSetlector = this.createElement(element, SETLECTOR_ELEMENT);
        this.writeSetlectorMetadataWithoutId(elSetlector, setlector);
        return elSetlector;
    }

    protected void writeSetlectorMetadataWithoutId(Element element, SetlectorMetadata nestedSetlector) throws XmlAccessException {
        if (nestedSetlector.getCombinationType() != null) {
            element.addAttribute(COMBINATION_ATTRIBUTE, nestedSetlector.getCombinationType().name());
        }
        this.writeColumnsMetadata(element, nestedSetlector.getColumns());
        this.writeSets(element, nestedSetlector.getSets());
        if (nestedSetlector.getOrderBy() != null) {
            this.writeOrderBy(element, nestedSetlector.getOrderBy());
        }
    }

    protected void writeSets(Element element, List<SelectorDefinition> sets) throws XmlAccessException {
        Element elSets = element.addElement(SETS_ELEMENT);
        int i = 0;
        for (SelectorDefinition definition : sets) {
            if (definition instanceof SelectorMetadata) {
                SelectorMetadata nestedSelector = (SelectorMetadata)definition;
                Element elSelector = elSets.addElement(SELECTOR_ELEMENT);
                this.writeNestedSelectorMetadataWithoutId(elSelector, nestedSelector);
            } else {
                Element elNestedSetlector = elSets.addElement(SETLECTOR_ELEMENT);
                this.writeSetlectorMetadataWithoutId(elNestedSetlector, (SetlectorMetadata)definition);
            }
            if (++i != 2) continue;
            break;
        }
    }

    public Element writeFilterMetadata(Element element, ConditionMetadata condition) throws XmlAccessException {
        Element elCondition = this.createElement(element, FILTER_ELEMENT);
        this.writeOperationMetadata(elCondition, condition.getOperation());
        return elCondition;
    }
}

