/*
 * Decompiled with CFR 0.152.
 */
package org.datayoo.moql.util;

import java.util.LinkedList;
import org.apache.commons.lang3.StringUtils;

public abstract class PathUtils {
    public static final String FOLDER_SEPARATOR = "/";
    public static final String WINDOWS_FOLDER_SEPARATOR = "\\";
    public static final String TOP_PATH = "..";
    public static final String CURRENT_PATH = ".";
    public static final char DOT_CHAR = '.';
    public static final char FOLDER_SEPARATOR_CHAR = '/';

    public static int lastIndexOfFolderSeparator(String path) {
        int separatorIndex = path.lastIndexOf(FOLDER_SEPARATOR);
        if (separatorIndex == -1) {
            return path.lastIndexOf(WINDOWS_FOLDER_SEPARATOR);
        }
        return separatorIndex;
    }

    public static String getFileName(String path) {
        if (path == null) {
            return null;
        }
        int separatorIndex = PathUtils.lastIndexOfFolderSeparator(path);
        return separatorIndex != -1 ? path.substring(separatorIndex + 1) : path;
    }

    public static String getFilePath(String path) {
        if (path == null) {
            return null;
        }
        int separatorIndex = PathUtils.lastIndexOfFolderSeparator(path);
        return separatorIndex != -1 ? path.substring(0, separatorIndex + 1) : path;
    }

    public static String getFileNameExtension(String path) {
        if (path == null) {
            return null;
        }
        int separatorIndex = path.lastIndexOf(46);
        return separatorIndex != -1 ? path.substring(separatorIndex + 1) : null;
    }

    public static String joinPath(String path, String relativePath) {
        int separatorIndex = PathUtils.lastIndexOfFolderSeparator(path);
        if (separatorIndex != -1) {
            String newPath = path.substring(0, separatorIndex);
            if (relativePath.charAt(0) != '/') {
                newPath = newPath + FOLDER_SEPARATOR;
            }
            return newPath + relativePath;
        }
        return relativePath;
    }

    public static String toCanonicalPath(String path) {
        int i;
        if (path == null) {
            return null;
        }
        String pathToUse = StringUtils.replace((String)path, (String)WINDOWS_FOLDER_SEPARATOR, (String)FOLDER_SEPARATOR);
        int prefixIndex = pathToUse.indexOf(":");
        String prefix = "";
        if (prefixIndex != -1) {
            prefix = pathToUse.substring(0, prefixIndex + 1);
            pathToUse = pathToUse.substring(prefixIndex + 1);
        }
        if (pathToUse.charAt(0) == '/') {
            if (pathToUse.charAt(1) == '/') {
                prefix = new StringBuffer(prefix).append('/').append('/').toString();
                pathToUse = pathToUse.substring(2);
            } else {
                prefix = prefix + FOLDER_SEPARATOR;
                pathToUse = pathToUse.substring(1);
            }
        }
        String[] pathArray = StringUtils.split((String)pathToUse, (String)FOLDER_SEPARATOR);
        LinkedList<String> pathElements = new LinkedList<String>();
        int tops = 0;
        for (i = pathArray.length - 1; i >= 0; --i) {
            String element = pathArray[i];
            if (CURRENT_PATH.equals(element)) continue;
            if (TOP_PATH.equals(element)) {
                ++tops;
                continue;
            }
            if (tops > 0) {
                --tops;
                continue;
            }
            pathElements.add(0, element);
        }
        for (i = 0; i < tops; ++i) {
            pathElements.add(0, TOP_PATH);
        }
        pathElements.add(0, prefix);
        return StringUtils.join(pathElements, (String)FOLDER_SEPARATOR);
    }

    public static boolean isRelativePath(String path) {
        return path.charAt(0) == '.';
    }
}

