/*
 * Decompiled with CFR 0.152.
 */
package org.datayoo.moql.sql;

import java.util.Map;
import org.datayoo.moql.Operand;
import org.datayoo.moql.core.Column;
import org.datayoo.moql.core.Columns;
import org.datayoo.moql.core.HavingImpl;
import org.datayoo.moql.core.Join;
import org.datayoo.moql.core.Limit;
import org.datayoo.moql.core.RecordSetOperator;
import org.datayoo.moql.core.SetlectorImpl;
import org.datayoo.moql.core.Table;
import org.datayoo.moql.core.group.GroupRecordSetOperator;
import org.datayoo.moql.core.table.SelectorTable;
import org.datayoo.moql.metadata.TableMetadata;
import org.datayoo.moql.operand.expression.AbstractOperationExpression;
import org.datayoo.moql.operand.expression.ExpressionType;
import org.datayoo.moql.operand.expression.ParenExpression;
import org.datayoo.moql.operand.expression.relation.InExpression;
import org.datayoo.moql.operand.function.AbstractFunction;
import org.datayoo.moql.operand.selector.ColumnSelectorOperand;
import org.datayoo.moql.operand.selector.ValueSelectorOperand;
import org.datayoo.moql.sql.MoqlGrammarTranslator;
import org.datayoo.moql.util.StringFormater;

public class DynamodbTranslator
extends MoqlGrammarTranslator {
    @Override
    protected String translate2SelectClause(RecordSetOperator recordSetOperator, Map<String, Object> translationContext) {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("select ");
        sbuf.append(this.translateColumns(recordSetOperator.getColumns(), translationContext));
        return sbuf.toString();
    }

    @Override
    protected String translateColumns(Columns columns, Map<String, Object> translationContext) {
        StringBuffer sbuf = new StringBuffer();
        int i = 0;
        for (Column column : columns.getColumns()) {
            String t;
            int index;
            if (column.isJustUsed4Order()) continue;
            if (i != 0) {
                sbuf.append(", ");
            }
            if ((index = (t = this.translateOperand(column.getOperand(), translationContext).trim()).indexOf(".")) != -1) {
                t = t.substring(index + 1);
            }
            sbuf.append(t);
            ++i;
        }
        sbuf.append(" ");
        return sbuf.toString();
    }

    @Override
    protected String translateTable(Table table, Map<String, Object> translationContext) {
        TableMetadata tableMetadata = table.getTableMetadata();
        if (table instanceof SelectorTable) {
            throw new UnsupportedOperationException("Unsupport inner select clause!");
        }
        return tableMetadata.getValue();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected String translateOperand(Operand operand, Map<String, Object> translationContext) {
        StringBuffer sbuf = new StringBuffer();
        if (operand instanceof AbstractOperationExpression) {
            AbstractOperationExpression expression = (AbstractOperationExpression)operand;
            if (expression.getExpressionType() == ExpressionType.LOGIC) {
                sbuf.append(this.translateLogicExpression(expression, translationContext));
                return sbuf.toString();
            } else if (expression.getExpressionType() == ExpressionType.RELATION) {
                sbuf.append(this.translateRelationExpression(expression, translationContext));
                return sbuf.toString();
            } else if (expression.getExpressionType() == ExpressionType.ARITHMETIC) {
                sbuf.append(this.translateArithmeticExpression(expression, translationContext));
                return sbuf.toString();
            } else {
                if (expression.getExpressionType() != ExpressionType.BITWISE) throw new IllegalArgumentException(StringFormater.format((String)"Doesn't support operand with type '{}'!", (Object[])new Object[]{expression.getExpressionType()}));
                sbuf.append(this.translateBitwiseExpression(expression, translationContext));
            }
            return sbuf.toString();
        } else if (operand instanceof ParenExpression) {
            ParenExpression parenExpression = (ParenExpression)operand;
            sbuf.append(this.translateParenExpression(parenExpression, translationContext));
            return sbuf.toString();
        } else if (operand instanceof ColumnSelectorOperand) {
            ColumnSelectorOperand selectorOperand = (ColumnSelectorOperand)operand;
            sbuf.append(this.translate2Sql(selectorOperand.getColumnSelector()));
            return sbuf.toString();
        } else if (operand instanceof ValueSelectorOperand) {
            ValueSelectorOperand selectorOperand = (ValueSelectorOperand)operand;
            sbuf.append("(");
            sbuf.append(this.translate2Sql(selectorOperand.getValueSelector()).trim());
            sbuf.append(") ");
            return sbuf.toString();
        } else if (operand instanceof AbstractFunction) {
            AbstractFunction function = (AbstractFunction)operand;
            sbuf.append(this.translateFunction(function, translationContext));
            return sbuf.toString();
        } else {
            String t = operand.getName();
            int index = t.indexOf(46);
            if (index != -1) {
                t = t.substring(index + 1);
            }
            sbuf.append(t);
            sbuf.append(" ");
        }
        return sbuf.toString();
    }

    @Override
    protected String translateInExpression(InExpression expression, Map<String, Object> translationContext) {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append(this.translateOperand(expression.getLeftOperand(), translationContext));
        sbuf.append("in [");
        int i = 0;
        for (Operand rOperand : expression.getrOperands()) {
            if (i != 0) {
                sbuf.append(", ");
            }
            sbuf.append(this.translateOperand(rOperand, translationContext).trim());
            ++i;
        }
        sbuf.append("] ");
        return sbuf.toString();
    }

    @Override
    protected String translate2Sql(SetlectorImpl setlector, Map<String, Object> translationContext) {
        throw new UnsupportedOperationException("Unsupport set operator!");
    }

    @Override
    protected String translate2LimitClause(Limit limit, Map<String, Object> translationContext) {
        throw new UnsupportedOperationException("Unsupport limit clause!");
    }

    @Override
    protected String translateJoin(Join join, boolean multiTables, Map<String, Object> translationContext) {
        throw new UnsupportedOperationException("Unsupport join clause!");
    }

    @Override
    protected String translate2GroupbyClause(GroupRecordSetOperator groupRecordSetOperator, Map<String, Object> translationContext) {
        throw new UnsupportedOperationException("Unsupport groupBy clause!");
    }

    @Override
    protected String translate2HavingClause(HavingImpl having, Map<String, Object> translationContext) {
        throw new UnsupportedOperationException("Unsupport having clause!");
    }
}

