/*
 * Decompiled with CFR 0.152.
 */
package org.datayoo.moql.sql;

import java.util.Map;
import org.datayoo.moql.core.Cache;
import org.datayoo.moql.core.Condition;
import org.datayoo.moql.core.HavingImpl;
import org.datayoo.moql.core.Limit;
import org.datayoo.moql.core.OrderImpl;
import org.datayoo.moql.core.SelectorImpl;
import org.datayoo.moql.core.group.GroupRecordSetOperator;
import org.datayoo.moql.sql.MoqlGrammarTranslator;

public class OracleTranslator
extends MoqlGrammarTranslator {
    @Override
    protected String translateCache(Cache cache) {
        return "";
    }

    @Override
    protected String translate2Sql(SelectorImpl selector, Map<String, Object> translationContext) {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append(this.translate2SelectClause(selector.getRecordSetOperator(), translationContext));
        sbuf.append(this.translate2FromClause(selector.getTables(), translationContext));
        if (selector.getWhere() != null || selector.getLimit() != null) {
            sbuf.append(this.translate2WhereClause(selector.getWhere(), selector.getLimit(), translationContext));
        }
        if (selector.getRecordSetOperator() instanceof GroupRecordSetOperator) {
            sbuf.append(this.translate2GroupbyClause((GroupRecordSetOperator)selector.getRecordSetOperator(), translationContext));
        }
        if (selector.getHaving() != null) {
            sbuf.append(this.translate2HavingClause((HavingImpl)selector.getHaving(), translationContext));
        }
        if (selector.getOrder() != null) {
            sbuf.append(this.translate2OrderbyClause((OrderImpl)selector.getOrder(), translationContext));
        }
        return sbuf.toString();
    }

    protected String translate2WhereClause(Condition condition, Limit top, Map<String, Object> translationContext) {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("where ");
        if (top != null) {
            sbuf.append(this.translateWhereLimit(top));
        }
        if (condition != null) {
            sbuf.append(this.translateOperand(condition.getOperand(), translationContext));
        }
        return sbuf.toString();
    }

    protected String translateWhereLimit(Limit limit) {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("rownum <= ");
        sbuf.append(limit.getLimitMetadata().getValue());
        sbuf.append(" ");
        return sbuf.toString();
    }
}

