/*
 * Decompiled with CFR 0.152.
 */
package org.datayoo.moql.sql;

import java.util.Map;
import org.datayoo.moql.core.Cache;
import org.datayoo.moql.core.HavingImpl;
import org.datayoo.moql.core.Limit;
import org.datayoo.moql.core.OrderImpl;
import org.datayoo.moql.core.RecordSetOperator;
import org.datayoo.moql.core.SelectorImpl;
import org.datayoo.moql.core.group.GroupRecordSetOperator;
import org.datayoo.moql.metadata.LimitMetadata;
import org.datayoo.moql.sql.MoqlGrammarTranslator;

public class SQLServerTranslator
extends MoqlGrammarTranslator {
    @Override
    protected String translateCache(Cache cache) {
        return "";
    }

    @Override
    protected String translate2Sql(SelectorImpl selector, Map<String, Object> translationContext) {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append(this.translate2SelectClause(selector.getRecordSetOperator(), selector.getLimit(), translationContext));
        sbuf.append(this.translate2FromClause(selector.getTables(), translationContext));
        if (selector.getWhere() != null) {
            sbuf.append(this.translate2WhereClause(selector.getWhere(), translationContext));
        }
        if (selector.getRecordSetOperator() instanceof GroupRecordSetOperator) {
            sbuf.append(this.translate2GroupbyClause((GroupRecordSetOperator)selector.getRecordSetOperator(), translationContext));
        }
        if (selector.getHaving() != null) {
            sbuf.append(this.translate2HavingClause((HavingImpl)selector.getHaving(), translationContext));
        }
        if (selector.getOrder() != null) {
            sbuf.append(this.translate2OrderbyClause((OrderImpl)selector.getOrder(), translationContext));
        }
        return sbuf.toString();
    }

    protected String translate2SelectClause(RecordSetOperator recordSetOperator, Limit limit, Map<String, Object> translationContext) {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("select ");
        if (recordSetOperator.getCache() != null) {
            sbuf.append(this.translateCache(recordSetOperator.getCache()));
        }
        if (recordSetOperator.getColumns().getColumnsMetadata().isDistinct()) {
            sbuf.append("distinct ");
        }
        if (limit != null) {
            sbuf.append(this.translate2LimitClause(limit));
        }
        sbuf.append(this.translateColumns(recordSetOperator.getColumns(), translationContext));
        return sbuf.toString();
    }

    protected String translate2LimitClause(Limit limit) {
        StringBuffer sbuf = new StringBuffer();
        LimitMetadata limitMetadata = limit.getLimitMetadata();
        sbuf.append("top ");
        sbuf.append(limitMetadata.getValue());
        if (limitMetadata.isPercent()) {
            sbuf.append("%");
        }
        sbuf.append(" ");
        return sbuf.toString();
    }
}

