/*
 * Decompiled with CFR 0.152.
 */
package org.datayoo.moql.sql.es;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import org.datayoo.moql.operand.function.Function;
import org.datayoo.moql.sql.es.AbstractESFunctionTranslator;

public class KNNTranslator
extends AbstractESFunctionTranslator {
    public static final String FUNCTION_NAME = "knn";

    public KNNTranslator() {
        super(FUNCTION_NAME);
    }

    @Override
    protected void innerTranslate(Function function, JsonElement jsonObject) {
        if (function.getParameterCount() != 4) {
            throw new IllegalArgumentException("Error function! The match function's format should be match(fields,query_vector,k,num_candidates)!");
        }
        JsonObject knn = new JsonObject();
        List parameters = function.getParameters();
        this.putObject((JsonElement)knn, "field", parameters.get(0));
        this.putObject((JsonElement)knn, "query_vector", parameters.get(1));
        this.putObject((JsonElement)knn, "k", parameters.get(2));
        this.putObject((JsonElement)knn, "num_candidates", parameters.get(3));
        this.putObject(jsonObject, FUNCTION_NAME, knn);
    }
}

