/*
 * Decompiled with CFR 0.152.
 */
package org.datayoo.moql.sql.mongodb;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import org.apache.commons.lang3.Validate;
import org.datayoo.moql.Operand;
import org.datayoo.moql.operand.constant.StringConstant;
import org.datayoo.moql.operand.expression.member.MemberVariableExpression;
import org.datayoo.moql.operand.function.Function;
import org.datayoo.moql.sql.mongodb.MongoFunctionTranslator;
import org.datayoo.moql.util.StringFormater;

public abstract class AbstractMongoFunctionTranslator
implements MongoFunctionTranslator {
    protected String functionName;

    public AbstractMongoFunctionTranslator(String functionName) {
        Validate.notEmpty((CharSequence)functionName, (String)"Parameter 'functionName' is empty!", (Object[])new Object[0]);
        this.functionName = functionName;
    }

    @Override
    public String getFunctionName() {
        return this.functionName;
    }

    @Override
    public String translate(Function function) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void translate(Function function, JsonElement jsonObject) {
        Validate.notNull((Object)function, (String)"Parameter 'function' is null!", (Object[])new Object[0]);
        Validate.notNull((Object)jsonObject, (String)"Parameter 'jsonObject' is null!", (Object[])new Object[0]);
        if (!this.functionName.equalsIgnoreCase(function.getName())) {
            throw new IllegalArgumentException(StringFormater.format((String)"FunctionTranslator '{}' couldn't translate the function '{}'!", (Object[])new Object[]{this.functionName, function.getName()}));
        }
        this.innerTranslate(function, jsonObject);
    }

    protected abstract void innerTranslate(Function var1, JsonElement var2);

    protected void putObject(JsonElement jsonObject, String name, Object valueJson) {
        if (jsonObject instanceof JsonObject) {
            if (valueJson instanceof JsonElement) {
                ((JsonObject)jsonObject).add(name, (JsonElement)valueJson);
            } else {
                ((JsonObject)jsonObject).addProperty(name, valueJson.toString());
            }
        } else {
            JsonObject jo = new JsonObject();
            if (valueJson instanceof JsonElement) {
                jo.add(name, (JsonElement)valueJson);
            } else {
                jo.addProperty(name, valueJson.toString());
            }
            ((JsonArray)jsonObject).add((JsonElement)jo);
        }
    }

    protected String getOperandName(Operand operand) {
        String name = operand.getName();
        if (operand instanceof MemberVariableExpression) {
            int index = name.indexOf(46);
            if (index != -1) {
                return name.substring(index + 1);
            }
        } else if (operand instanceof StringConstant) {
            return name.substring(1, name.length() - 1);
        }
        return name;
    }

    protected String getOperandName(String name) {
        int index = (name = name.trim()).indexOf(46);
        if (index != -1) {
            return name.substring(index + 1);
        }
        return name;
    }
}

