/*
 * Decompiled with CFR 0.152.
 */
package org.datayoo.moql.sql.mongodb;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import org.datayoo.moql.Operand;
import org.datayoo.moql.operand.function.Function;
import org.datayoo.moql.sql.mongodb.AbstractMongoFunctionTranslator;

public class TextTranslator
extends AbstractMongoFunctionTranslator {
    public static final String FUNCTION_NAME = "text";

    public TextTranslator() {
        super(FUNCTION_NAME);
    }

    @Override
    protected void innerTranslate(Function function, JsonElement jsonObject) {
        if (function.getParameterCount() < 1 || function.getParameterCount() > 4) {
            throw new IllegalArgumentException("Error function! The text function's format should be text(searchString,language,caseSenstive,diacriticSensitive)!");
        }
        JsonObject text = new JsonObject();
        List parameters = function.getParameters();
        text.addProperty("$search", this.getOperandName((Operand)parameters.get(0)));
        if (parameters.size() > 1) {
            text.addProperty("$language", this.getOperandName((Operand)parameters.get(1)));
            if (parameters.size() > 2) {
                boolean b = Boolean.valueOf(this.getOperandName((Operand)parameters.get(2)));
                text.addProperty("$caseSensitive", Boolean.valueOf(b));
                if (parameters.size() > 3) {
                    b = Boolean.valueOf(this.getOperandName((Operand)parameters.get(3)));
                    text.addProperty("$diacriticSensitive", Boolean.valueOf(b));
                }
            }
        }
        this.putObject(jsonObject, "$text", text);
    }
}

