/*
 * Decompiled with CFR 0.152.
 */
package org.datayoo.tripod.parser;

import java.io.InputStream;
import java.io.Reader;
import java.util.HashSet;
import java.util.Set;
import org.antlr.v4.runtime.ANTLRErrorStrategy;
import org.antlr.v4.runtime.BailErrorStrategy;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CodePointCharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.apache.commons.lang3.Validate;
import org.datayoo.tripod.antlr.TripodLexer;
import org.datayoo.tripod.antlr.TripodParser;
import org.datayoo.tripod.exception.TripodRuntimeException;
import org.datayoo.tripod.metadata.BinaryMetadata;
import org.datayoo.tripod.metadata.BoolMetadata;
import org.datayoo.tripod.metadata.ExpressionMetadata;
import org.datayoo.tripod.metadata.ExpressionType;
import org.datayoo.tripod.metadata.FieldMetadata;
import org.datayoo.tripod.metadata.InMetadata;
import org.datayoo.tripod.metadata.RangeMetadata;
import org.datayoo.tripod.metadata.UnaryMetadata;

public class TripodExpressionParser {
    public static BoolMetadata parseFromFile(String fileName) {
        Validate.notEmpty((CharSequence)fileName, (String)"fileName is empty!", (Object[])new Object[0]);
        try {
            CharStream charStream = CharStreams.fromFileName((String)fileName);
            TripodLexer tripodLexer = new TripodLexer(charStream);
            CommonTokenStream tokens = new CommonTokenStream((TokenSource)tripodLexer);
            TripodParser tripodParser = new TripodParser((TokenStream)tokens);
            tripodParser.setErrorHandler((ANTLRErrorStrategy)new BailErrorStrategy());
            TripodParser.TripodExpressionContext context = tripodParser.tripodExpression();
            if (context.exception != null) {
                throw new TripodRuntimeException(context.exception.getMessage(), context.exception);
            }
            if (!tripodLexer._hitEOF) {
                throw new TripodRuntimeException("Unsupported grammar!");
            }
            return context.boolMetadata;
        }
        catch (Throwable t) {
            throw new TripodRuntimeException("Invalid expression!", t);
        }
    }

    public static BoolMetadata parseFromStream(InputStream inputStream) {
        Validate.notNull((Object)inputStream, (String)"inputStream is null!", (Object[])new Object[0]);
        try {
            CharStream charStream = CharStreams.fromStream((InputStream)inputStream);
            TripodLexer tripodLexer = new TripodLexer(charStream);
            CommonTokenStream tokens = new CommonTokenStream((TokenSource)tripodLexer);
            TripodParser tripodParser = new TripodParser((TokenStream)tokens);
            tripodParser.setErrorHandler((ANTLRErrorStrategy)new BailErrorStrategy());
            TripodParser.TripodExpressionContext context = tripodParser.tripodExpression();
            if (context.exception != null) {
                throw new TripodRuntimeException(context.exception.getMessage(), context.exception);
            }
            if (!tripodLexer._hitEOF) {
                throw new TripodRuntimeException("Unsupported grammar!");
            }
            return context.boolMetadata;
        }
        catch (Throwable t) {
            throw new TripodRuntimeException("Invalid expression!", t);
        }
    }

    public static BoolMetadata parseFromReader(Reader reader) {
        Validate.notNull((Object)reader, (String)"reader is null!", (Object[])new Object[0]);
        try {
            CodePointCharStream charStream = CharStreams.fromReader((Reader)reader);
            TripodLexer tripodLexer = new TripodLexer((CharStream)charStream);
            CommonTokenStream tokens = new CommonTokenStream((TokenSource)tripodLexer);
            TripodParser tripodParser = new TripodParser((TokenStream)tokens);
            tripodParser.setErrorHandler((ANTLRErrorStrategy)new BailErrorStrategy());
            TripodParser.TripodExpressionContext context = tripodParser.tripodExpression();
            if (context.exception != null) {
                throw new TripodRuntimeException(context.exception.getMessage(), context.exception);
            }
            if (!tripodLexer._hitEOF) {
                throw new TripodRuntimeException("Unsupported grammar!");
            }
            return context.boolMetadata;
        }
        catch (Throwable t) {
            throw new TripodRuntimeException("Invalid expression!", t);
        }
    }

    public static BoolMetadata parseFromString(String data) {
        Validate.notEmpty((CharSequence)data, (String)"data is empty!", (Object[])new Object[0]);
        try {
            CodePointCharStream charStream = CharStreams.fromString((String)data);
            TripodLexer tripodLexer = new TripodLexer((CharStream)charStream);
            CommonTokenStream tokens = new CommonTokenStream((TokenSource)tripodLexer);
            TripodParser tripodParser = new TripodParser((TokenStream)tokens);
            tripodParser.setErrorHandler((ANTLRErrorStrategy)new BailErrorStrategy());
            TripodParser.TripodExpressionContext context = tripodParser.tripodExpression();
            if (context.exception != null) {
                throw new TripodRuntimeException(context.exception.getMessage(), context.exception);
            }
            if (!tripodLexer._hitEOF) {
                throw new TripodRuntimeException("Unsupported grammar!");
            }
            return context.boolMetadata;
        }
        catch (Throwable t) {
            throw new TripodRuntimeException(String.format("Invalid expression '%s'", data), t);
        }
    }

    public static Set<String> extractSegmentFields(String data) {
        BoolMetadata boolMetadata = TripodExpressionParser.parseFromString(data);
        HashSet<String> fields = new HashSet<String>();
        TripodExpressionParser.extractSegmentFields(boolMetadata, fields);
        return fields;
    }

    protected static void extractSegmentFields(ExpressionMetadata expressionMetadata, Set<String> fields) {
        if (expressionMetadata.getExpressionType() == ExpressionType.SPACE_OR) {
            TripodExpressionParser.extractSegmentFields((BoolMetadata)expressionMetadata, fields);
        } else if (expressionMetadata.getExpressionType() == ExpressionType.AND) {
            TripodExpressionParser.extractSegmentFields((BinaryMetadata)expressionMetadata, fields);
        } else if (expressionMetadata.getExpressionType() == ExpressionType.OR) {
            TripodExpressionParser.extractSegmentFields((BinaryMetadata)expressionMetadata, fields);
        } else if (expressionMetadata.getExpressionType() == ExpressionType.NOT) {
            TripodExpressionParser.extractSegmentFields((UnaryMetadata)expressionMetadata, fields);
        } else if (expressionMetadata.getExpressionType() == ExpressionType.MUST) {
            TripodExpressionParser.extractSegmentFields((UnaryMetadata)expressionMetadata, fields);
        } else if (expressionMetadata.getExpressionType() == ExpressionType.MINUS) {
            TripodExpressionParser.extractSegmentFields((UnaryMetadata)expressionMetadata, fields);
        } else if (expressionMetadata.getExpressionType() == ExpressionType.FIELD) {
            TripodExpressionParser.extractSegmentFields((FieldMetadata)expressionMetadata, fields);
        } else if (expressionMetadata.getExpressionType() == ExpressionType.PAREN) {
            TripodExpressionParser.extractSegmentFields((UnaryMetadata)expressionMetadata, fields);
        } else if (expressionMetadata.getExpressionType() == ExpressionType.RANGE) {
            TripodExpressionParser.extractSegmentFields((RangeMetadata)expressionMetadata, fields);
        } else if (expressionMetadata.getExpressionType() == ExpressionType.IN) {
            TripodExpressionParser.extractSegmentFields((InMetadata)expressionMetadata, fields);
        } else {
            return;
        }
    }

    protected static void extractSegmentFields(BoolMetadata boolMetadata, Set<String> fields) {
        for (ExpressionMetadata expressionMetadata : boolMetadata.getBoolExprs()) {
            TripodExpressionParser.extractSegmentFields(expressionMetadata, fields);
        }
    }

    protected static void extractSegmentFields(BinaryMetadata binaryMetadata, Set<String> fields) {
        TripodExpressionParser.extractSegmentFields(binaryMetadata.getlExpr(), fields);
        TripodExpressionParser.extractSegmentFields(binaryMetadata.getrExpr(), fields);
    }

    protected static void extractSegmentFields(UnaryMetadata unaryMetadata, Set<String> fields) {
        TripodExpressionParser.extractSegmentFields(unaryMetadata.getExpr(), fields);
    }

    protected static void extractSegmentFields(FieldMetadata fieldMetadata, Set<String> fields) {
        if (fieldMetadata.getField() != null) {
            fields.add(fieldMetadata.getField());
        }
        TripodExpressionParser.extractSegmentFields(fieldMetadata.getExpr(), fields);
    }

    protected static void extractSegmentFields(RangeMetadata rangeMetadata, Set<String> fields) {
        TripodExpressionParser.extractSegmentFields(rangeMetadata.getlExpr(), fields);
        TripodExpressionParser.extractSegmentFields(rangeMetadata.getrExpr(), fields);
    }

    protected static void extractSegmentFields(InMetadata inMetadata, Set<String> fields) {
        for (ExpressionMetadata expressionMetadata : inMetadata.getExpressions()) {
            TripodExpressionParser.extractSegmentFields(expressionMetadata, fields);
        }
    }
}

