/*
 * Copyright 2014-2019 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.dbflute.twowaysql.context;

/**
 * @author modified by jflute (originated in S2Dao)
 */
public interface CommandContext {

    Object getArg(String name);

    Class<?> getArgType(String name);

    void addArg(String name, Object arg, Class<?> argType);

    String getSql();

    Object[] getBindVariables();

    Class<?>[] getBindVariableTypes();

    CommandContext addSql(String sql);

    CommandContext addSql(String sql, Object bindVariable, Class<?> bindVariableType);

    CommandContext addSql(String sql, Object[] bindVariables, Class<?>[] bindVariableTypes);

    boolean isEnabled();

    void setEnabled(boolean enabled);

    boolean isBeginChild();

    boolean isAlreadySkippedConnector();

    void setAlreadySkippedConnector(boolean alreadySkippedConnector);
}
