/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.bhv.exception;

import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.dbflute.bhv.core.context.ConditionBeanContext;
import org.dbflute.bhv.core.context.InternalMapContext;
import org.dbflute.bhv.core.context.ResourceContext;
import org.dbflute.bhv.exception.SQLExceptionAdviser;
import org.dbflute.bhv.exception.SQLExceptionResource;
import org.dbflute.cbean.ConditionBean;
import org.dbflute.dbway.DBDef;
import org.dbflute.exception.EntityAlreadyExistsException;
import org.dbflute.exception.SQLFailureException;
import org.dbflute.helper.message.ExceptionMessageBuilder;
import org.dbflute.outsidesql.OutsideSqlContext;
import org.dbflute.system.DBFluteSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLExceptionHandler {
    private static final Logger _log = LoggerFactory.getLogger(SQLExceptionHandler.class);
    protected final SQLExceptionAdviser _adviser = this.createAdviser();

    public void handleSQLException(SQLException e, SQLExceptionResource resource) {
        if (resource.isUniqueConstraintHandling() && this.isUniqueConstraintException(e)) {
            this.throwEntityAlreadyExistsException(e, resource);
        } else {
            this.throwSQLFailureException(e, resource);
        }
    }

    protected boolean isUniqueConstraintException(SQLException e) {
        if (!ResourceContext.isExistResourceContextOnThread()) {
            return false;
        }
        return ResourceContext.isUniqueConstraintException(this.extractSQLState(e), e.getErrorCode());
    }

    protected void throwEntityAlreadyExistsException(SQLException e, SQLExceptionResource resource) {
        ExceptionMessageBuilder br = this.createExceptionMessageBuilder();
        br.addNotice("The entity already exists on the database.");
        br.addItem("Advice");
        br.addElement("Please confirm the primary key whether it already exists on the database.");
        br.addElement("And also confirm the unique constraint for other columns.");
        this.setupCommonElement(br, e, resource);
        String msg = br.buildExceptionMessage();
        throw new EntityAlreadyExistsException(msg, e);
    }

    protected void throwSQLFailureException(SQLException e, SQLExceptionResource resource) {
        ExceptionMessageBuilder br = this.createExceptionMessageBuilder();
        List<String> noticeList = resource.getNoticeList();
        if (!noticeList.isEmpty()) {
            for (String notice : noticeList) {
                br.addNotice(notice);
            }
        } else {
            br.addNotice("The SQL failed to execute.");
        }
        br.addItem("Advice");
        br.addElement("Read the SQLException message.");
        String advice = this.askAdvice(e, ResourceContext.currentDBDef());
        if (advice != null && advice.trim().length() > 0) {
            br.addElement("*" + advice);
        }
        this.setupCommonElement(br, e, resource);
        String msg = br.buildExceptionMessage();
        throw new SQLFailureException(msg, e);
    }

    protected ExceptionMessageBuilder createExceptionMessageBuilder() {
        return new ExceptionMessageBuilder();
    }

    protected String askAdvice(SQLException e, DBDef dbdef) {
        return this._adviser.askAdvice(e, dbdef);
    }

    protected void setupCommonElement(ExceptionMessageBuilder br, SQLException e, SQLExceptionResource resource) {
        br.addItem("SQLState");
        br.addElement(this.extractSQLState(e));
        br.addItem("ErrorCode");
        br.addElement(e.getErrorCode());
        this.setupSQLExceptionElement(br, e);
        Map<String, List<Object>> resourceMap = resource.getResourceMap();
        for (Map.Entry<String, List<Object>> entry : resourceMap.entrySet()) {
            br.addItem(entry.getKey());
            List<Object> elementList = entry.getValue();
            for (Object element : elementList) {
                br.addElement(element);
            }
        }
        this.setupBehaviorElement(br);
        this.setupConditionBeanElement(br);
        this.setupOutsideSqlElement(br);
        this.setupTargetSqlElement(br, resource);
    }

    protected void setupSQLExceptionElement(ExceptionMessageBuilder br, SQLException e) {
        br.addItem("SQLException");
        br.addElement(e.getClass().getName());
        br.addElement(this.extractMessage(e));
        SQLException nextEx = e.getNextException();
        if (nextEx != null) {
            br.addItem("NextException");
            br.addElement(nextEx.getClass().getName());
            br.addElement(this.extractMessage(nextEx));
            SQLException nextNextEx = nextEx.getNextException();
            if (nextNextEx != null) {
                br.addItem("NextNextException");
                br.addElement(nextNextEx.getClass().getName());
                br.addElement(this.extractMessage(nextNextEx));
            }
        }
    }

    protected void setupBehaviorElement(ExceptionMessageBuilder br) {
        String invokePath = this.extractBehaviorInvokePath();
        if (invokePath != null) {
            br.addItem("Behavior");
            br.addElement(invokePath);
        }
    }

    protected void setupConditionBeanElement(ExceptionMessageBuilder br) {
        if (this.hasConditionBean()) {
            br.addItem("ConditionBean");
            br.addElement(this.getConditionBean().getClass().getName());
        }
    }

    protected void setupOutsideSqlElement(ExceptionMessageBuilder br) {
        if (this.hasOutsideSqlContext()) {
            br.addItem("OutsideSql");
            br.addElement(this.getOutsideSqlContext().getOutsideSqlPath());
        }
    }

    protected void setupTargetSqlElement(ExceptionMessageBuilder br, SQLExceptionResource resource) {
        String displaySql = resource.getDisplaySql();
        if (displaySql != null) {
            this.doSetupTargetSqlElement(br, displaySql, resource.isDisplaySqlPartHandling());
        }
    }

    protected void doSetupTargetSqlElement(ExceptionMessageBuilder br, String displaySql, boolean partHandling) {
        if (partHandling) {
            br.addItem("Part of Display SQLs");
            br.addElement(displaySql);
            br.addElement("...");
            br.addElement("...");
            br.addElement("(and other statements)");
        } else {
            br.addItem("Display SQL");
            br.addElement(displaySql);
        }
    }

    protected String extractMessage(SQLException e) {
        String message = e.getMessage();
        return message != null ? message.trim() : message;
    }

    protected String extractSQLState(SQLException e) {
        String sqlState = e.getSQLState();
        if (sqlState != null) {
            return sqlState;
        }
        SQLException nextEx = e.getNextException();
        if (nextEx == null) {
            return null;
        }
        sqlState = nextEx.getSQLState();
        if (sqlState != null) {
            return sqlState;
        }
        SQLException nextNextEx = nextEx.getNextException();
        if (nextNextEx == null) {
            return null;
        }
        sqlState = nextNextEx.getSQLState();
        if (sqlState != null) {
            return sqlState;
        }
        SQLException nextNextNextEx = nextNextEx.getNextException();
        if (nextNextNextEx == null) {
            return null;
        }
        sqlState = nextNextNextEx.getSQLState();
        if (sqlState != null) {
            return sqlState;
        }
        return null;
    }

    protected String extractBehaviorInvokePath() {
        try {
            String provided = this.doExtractBehaviorInvokePathFromProvider();
            if (provided != null) {
                return provided;
            }
            return this.doExtractBehabiorInvokePathFromSeparatedParts();
        }
        catch (RuntimeException continued) {
            if (_log.isDebugEnabled()) {
                _log.debug("Failed to extract behavior invoke path for debug.", (Throwable)continued);
            }
            return null;
        }
    }

    protected String doExtractBehaviorInvokePathFromProvider() {
        InternalMapContext.InvokePathProvider provider = InternalMapContext.getInvokePathProvider();
        return provider != null ? provider.provide() : null;
    }

    protected String doExtractBehabiorInvokePathFromSeparatedParts() {
        String behaviorInvokeName = InternalMapContext.getBehaviorInvokeName();
        if (behaviorInvokeName == null) {
            return null;
        }
        String clientInvokeName = InternalMapContext.getClientInvokeName();
        String byPassInvokeName = InternalMapContext.getByPassInvokeName();
        StringBuilder sb = new StringBuilder();
        boolean existsPath = false;
        if (clientInvokeName != null) {
            existsPath = true;
            sb.append((Object)clientInvokeName);
        }
        if (byPassInvokeName != null) {
            existsPath = true;
            sb.append((Object)byPassInvokeName);
        }
        sb.append((Object)behaviorInvokeName);
        if (existsPath) {
            sb.append("...");
        }
        return sb.toString();
    }

    protected SQLExceptionAdviser createAdviser() {
        return new SQLExceptionAdviser();
    }

    protected boolean hasConditionBean() {
        return ConditionBeanContext.isExistConditionBeanOnThread();
    }

    protected ConditionBean getConditionBean() {
        return ConditionBeanContext.getConditionBeanOnThread();
    }

    protected boolean hasOutsideSqlContext() {
        return OutsideSqlContext.isExistOutsideSqlContextOnThread();
    }

    protected OutsideSqlContext getOutsideSqlContext() {
        return OutsideSqlContext.getOutsideSqlContextOnThread();
    }

    protected String ln() {
        return DBFluteSystem.ln();
    }
}

