/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.helper;

import java.io.Serializable;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.Month;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.dbflute.exception.ParseDateExpressionFailureException;
import org.dbflute.helper.message.ExceptionMessageBuilder;
import org.dbflute.helper.secretary.BusinessDayDeterminer;
import org.dbflute.helper.secretary.DateCompareCallback;
import org.dbflute.helper.secretary.LocalDateCompareCallback;
import org.dbflute.helper.secretary.LocalDateTimeCompareCallback;
import org.dbflute.system.DBFluteSystem;
import org.dbflute.util.DfTypeUtil;

public class HandyDate
implements Serializable {
    private static final long serialVersionUID = -5181512291555841795L;
    protected final Calendar _cal;
    protected int _yearBeginMonth;
    protected int _monthBeginDay;
    protected int _dayBeginHour;
    protected int _weekBeginDay;

    public HandyDate(LocalDate localDate) {
        this.assertConstructorArgNotNull("localDate", localDate);
        this._cal = this.createCalendar(null, null);
        this.prepareDefaultBeginAttribute();
        this._cal.setTime(DfTypeUtil.toDate(localDate));
    }

    public HandyDate(LocalDate localDate, TimeZone timeZone) {
        this.assertConstructorArgNotNull("localDate", localDate);
        this.assertConstructorArgNotNull("timeZone", timeZone);
        this._cal = this.createCalendar(timeZone, null);
        this.prepareDefaultBeginAttribute();
        this._cal.setTime(DfTypeUtil.toDate((Object)localDate, timeZone));
    }

    public HandyDate(LocalDateTime localDateTime) {
        this.assertConstructorArgNotNull("localDateTime", localDateTime);
        this._cal = this.createCalendar(null, null);
        this.prepareDefaultBeginAttribute();
        this._cal.setTime(DfTypeUtil.toDate(localDateTime));
    }

    public HandyDate(LocalDateTime localDateTime, TimeZone timeZone) {
        this.assertConstructorArgNotNull("localDateTime", localDateTime);
        this.assertConstructorArgNotNull("timeZone", timeZone);
        this._cal = this.createCalendar(timeZone, null);
        this.prepareDefaultBeginAttribute();
        this._cal.setTime(DfTypeUtil.toDate((Object)localDateTime, timeZone));
    }

    public HandyDate(Date date) {
        this.assertConstructorArgNotNull("date", date);
        this._cal = this.createCalendar(null, null);
        this.prepareDefaultBeginAttribute();
        this._cal.setTime(date);
    }

    public HandyDate(String exp) {
        this.assertConstructorArgNotNullAndNotEmpty("exp", exp);
        this._cal = this.createCalendar(null, null);
        this.prepareDefaultBeginAttribute();
        try {
            this._cal.setTime(DfTypeUtil.toDate(exp));
        }
        catch (DfTypeUtil.ParseDateException e) {
            this.throwParseDateExpressionFailureException(exp, e);
        }
    }

    public HandyDate(String exp, TimeZone timeZone) {
        this.assertConstructorArgNotNullAndNotEmpty("exp", exp);
        this.assertConstructorArgNotNull("timeZone", timeZone);
        this._cal = this.createCalendar(timeZone, null);
        this.prepareDefaultBeginAttribute();
        try {
            this._cal.setTime(DfTypeUtil.toDate((Object)exp, timeZone));
        }
        catch (DfTypeUtil.ParseDateException e) {
            this.throwParseDateExpressionFailureException(exp, e);
        }
    }

    public HandyDate(String exp, String pattern) {
        this.assertConstructorArgNotNullAndNotEmpty("exp", exp);
        this.assertConstructorArgNotNullAndNotEmpty("pattern", pattern);
        this._cal = this.createCalendar(null, null);
        this.prepareDefaultBeginAttribute();
        try {
            this._cal.setTime(DfTypeUtil.toDate((Object)exp, pattern));
        }
        catch (DfTypeUtil.ParseDateException e) {
            this.throwParseDateExpressionFailureException(exp, e);
        }
    }

    public HandyDate(String exp, String pattern, Locale locale) {
        this.assertConstructorArgNotNullAndNotEmpty("exp", exp);
        this.assertConstructorArgNotNullAndNotEmpty("pattern", pattern);
        this.assertConstructorArgNotNull("locale", locale);
        this._cal = this.createCalendar(null, locale);
        this.prepareDefaultBeginAttribute();
        try {
            this._cal.setTime(DfTypeUtil.toDate(exp, pattern, locale));
        }
        catch (DfTypeUtil.ParseDateException e) {
            this.throwParseDateExpressionFailureException(exp, e);
        }
    }

    public HandyDate(String exp, TimeZone timeZone, String pattern, Locale locale) {
        this.assertConstructorArgNotNullAndNotEmpty("exp", exp);
        this.assertConstructorArgNotNull("timeZone", timeZone);
        this.assertConstructorArgNotNullAndNotEmpty("pattern", pattern);
        this.assertConstructorArgNotNull("locale", locale);
        this._cal = this.createCalendar(timeZone, locale);
        this.prepareDefaultBeginAttribute();
        try {
            this._cal.setTime(DfTypeUtil.toDate(exp, timeZone, pattern, locale));
        }
        catch (DfTypeUtil.ParseDateException e) {
            this.throwParseDateExpressionFailureException(exp, e);
        }
    }

    protected void assertConstructorArgNotNull(String name, Object value) {
        if (value == null) {
            String msg = "The constructor argument '" + name + "' should not be null.";
            throw new IllegalArgumentException(msg);
        }
    }

    protected void assertConstructorArgNotNullAndNotEmpty(String name, Object value) {
        if (value == null) {
            String msg = "The constructor argument '" + name + "' should not be null.";
            throw new IllegalArgumentException(msg);
        }
        if (value instanceof String && ((String)value).isEmpty()) {
            String msg = "The constructor argument '" + name + "' should not be empty.";
            throw new IllegalArgumentException(msg);
        }
    }

    protected Calendar createCalendar(TimeZone timeZone, Locale locale) {
        TimeZone realZone = this.chooseRealZone(timeZone);
        Locale realLocale = this.chooseRealLocale(locale);
        return Calendar.getInstance(realZone, realLocale);
    }

    protected Locale chooseRealLocale(Locale locale) {
        return locale != null ? locale : DBFluteSystem.getFinalLocale();
    }

    protected TimeZone chooseRealZone(TimeZone timeZone) {
        return timeZone != null ? timeZone : DBFluteSystem.getFinalTimeZone();
    }

    protected void prepareDefaultBeginAttribute() {
        this._yearBeginMonth = this._cal.getActualMinimum(2) + 1;
        this._monthBeginDay = this._cal.getActualMinimum(5);
        this._dayBeginHour = this._cal.getActualMinimum(11);
        this._weekBeginDay = 1;
    }

    protected void throwParseDateExpressionFailureException(String exp, DfTypeUtil.ParseDateException e) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("Failed to parse the expression as date.");
        br.addItem("Expression");
        br.addElement(exp);
        String msg = br.buildExceptionMessage();
        throw new ParseDateExpressionFailureException(msg, e);
    }

    public HandyDate timeZone(TimeZone timeZone) {
        this.assertArgumentNotNull("timeZone", timeZone);
        this._cal.setTimeZone(timeZone);
        return this;
    }

    public HandyDate addYear(int years) {
        DfTypeUtil.addCalendarYear(this._cal, years);
        return this;
    }

    public HandyDate addMonth(int months) {
        DfTypeUtil.addCalendarMonth(this._cal, months);
        return this;
    }

    public HandyDate addDay(int days) {
        DfTypeUtil.addCalendarDay(this._cal, days);
        return this;
    }

    public HandyDate addHour(int hours) {
        DfTypeUtil.addCalendarHour(this._cal, hours);
        return this;
    }

    public HandyDate addMinute(int minutes) {
        DfTypeUtil.addCalendarMinute(this._cal, minutes);
        return this;
    }

    public HandyDate addSecond(int seconds) {
        DfTypeUtil.addCalendarSecond(this._cal, seconds);
        return this;
    }

    public HandyDate addMillisecond(int milliseconds) {
        DfTypeUtil.addCalendarMillisecond(this._cal, milliseconds);
        return this;
    }

    public HandyDate addWeek(int weeks) {
        DfTypeUtil.addCalendarWeek(this._cal, weeks);
        return this;
    }

    public HandyDate moveToYear(int year) {
        DfTypeUtil.moveToCalendarYear(this._cal, year);
        return this;
    }

    public HandyDate moveToYearJust() {
        DfTypeUtil.moveToCalendarYearJust(this._cal, this._yearBeginMonth);
        this.moveToMonthJust();
        return this;
    }

    public HandyDate moveToYearJustAdded(int years) {
        DfTypeUtil.moveToCalendarYearJustAdded(this._cal, years);
        return this;
    }

    public HandyDate moveToYearJustFor(int year) {
        DfTypeUtil.moveToCalendarYearJustFor(this._cal, year);
        return this;
    }

    public HandyDate moveToYearTerminal() {
        DfTypeUtil.moveToCalendarYearTerminal(this._cal, this._yearBeginMonth);
        this.moveToMonthTerminal();
        return this;
    }

    public HandyDate moveToYearTerminalAdded(int years) {
        DfTypeUtil.moveToCalendarYearTerminalAdded(this._cal, years);
        return this;
    }

    public HandyDate moveToYearTerminalFor(int year) {
        DfTypeUtil.moveToCalendarYearTerminalFor(this._cal, year);
        return this;
    }

    public HandyDate moveToMonth(int month) {
        this.assertValidMonth(month);
        DfTypeUtil.moveToCalendarMonth(this._cal, month);
        return this;
    }

    public HandyDate moveToMonthJust() {
        DfTypeUtil.moveToCalendarMonthJust(this._cal, this._monthBeginDay);
        this.moveToDayJust();
        return this;
    }

    public HandyDate moveToMonthJustAdded(int months) {
        DfTypeUtil.moveToCalendarMonthJustAdded(this._cal, months);
        return this;
    }

    public HandyDate moveToMonthJustFor(int month) {
        this.assertValidMonth(month);
        DfTypeUtil.moveToCalendarMonthJustFor(this._cal, month);
        return this;
    }

    public HandyDate moveToMonthTerminal() {
        DfTypeUtil.moveToCalendarMonthTerminal(this._cal, this._monthBeginDay);
        this.moveToDayTerminal();
        return this;
    }

    public HandyDate moveToMonthTerminalAdded(int months) {
        DfTypeUtil.moveToCalendarMonthTerminalAdded(this._cal, months);
        return this;
    }

    public HandyDate moveToMonthTerminalFor(int month) {
        this.assertValidMonth(month);
        DfTypeUtil.moveToCalendarMonthTerminalFor(this._cal, month);
        return this;
    }

    public HandyDate moveToMonthFirstWeekdayJust() {
        this.moveToMonthJust();
        if (this.isWeek_DayOfWeek1st_Sunday()) {
            this.addDay(1);
        } else if (this.isWeek_DayOfWeek7th_Saturday()) {
            this.addDay(2);
        }
        return this;
    }

    public HandyDate moveToMonthLastWeekdayTerminal() {
        this.moveToMonthTerminal();
        if (this.isWeek_DayOfWeek1st_Sunday()) {
            this.addDay(-2);
        } else if (this.isWeek_DayOfWeek7th_Saturday()) {
            this.addDay(-1);
        }
        return this;
    }

    public HandyDate moveToMonthFirstWeekendJust() {
        this.moveToMonthJust();
        while (!this.isWeek_DayOfWeekWeekend()) {
            this.addDay(1);
        }
        return this;
    }

    public HandyDate moveToMonthLastWeekendTerminal() {
        this.moveToMonthTerminal();
        while (!this.isWeek_DayOfWeekWeekend()) {
            this.addDay(-1);
        }
        return this;
    }

    public HandyDate moveToDay(int day) {
        this.assertValidDay(day);
        DfTypeUtil.moveToCalendarDay(this._cal, day);
        return this;
    }

    public HandyDate moveToDayJust() {
        DfTypeUtil.moveToCalendarDayJust(this._cal, this._dayBeginHour);
        return this;
    }

    public HandyDate moveToDayJustAdded(int days) {
        DfTypeUtil.moveToCalendarDayJustAdded(this._cal, days);
        return this;
    }

    public HandyDate moveToDayJustFor(int day) {
        this.assertValidDay(day);
        DfTypeUtil.moveToCalendarDayJustFor(this._cal, day);
        return this;
    }

    public HandyDate moveToDayTerminal() {
        DfTypeUtil.moveToCalendarDayTerminal(this._cal, this._dayBeginHour);
        return this;
    }

    public HandyDate moveToDayTerminalAdded(int days) {
        DfTypeUtil.moveToCalendarDayTerminalAdded(this._cal, days);
        return this;
    }

    public HandyDate moveToDayTerminalFor(int day) {
        this.assertValidDay(day);
        DfTypeUtil.moveToCalendarDayTerminalFor(this._cal, day);
        return this;
    }

    public HandyDate moveToHour(int hour) {
        this.assertValidHour(hour);
        DfTypeUtil.moveToCalendarHour(this._cal, hour);
        return this;
    }

    public HandyDate moveToHourJust() {
        DfTypeUtil.moveToCalendarHourJust(this._cal);
        return this;
    }

    public HandyDate moveToHourJustAdded(int hours) {
        DfTypeUtil.moveToCalendarHourJustAdded(this._cal, hours);
        return this;
    }

    public HandyDate moveToHourJustFor(int hour) {
        this.assertValidHour(hour);
        DfTypeUtil.moveToCalendarHourJustFor(this._cal, hour);
        return this;
    }

    public HandyDate moveToHourTerminal() {
        DfTypeUtil.moveToCalendarHourTerminal(this._cal);
        return this;
    }

    public HandyDate moveToHourTerminalAdded(int hours) {
        DfTypeUtil.moveToCalendarHourTerminalAdded(this._cal, hours);
        return this;
    }

    public HandyDate moveToHourTerminalFor(int hour) {
        this.assertValidHour(hour);
        DfTypeUtil.moveToCalendarHourTerminalFor(this._cal, hour);
        return this;
    }

    public HandyDate moveToHourJustNoon() {
        DfTypeUtil.moveToCalendarHourJustNoon(this._cal);
        return this;
    }

    public HandyDate moveToMinute(int minute) {
        this.assertValidMinute(minute);
        DfTypeUtil.moveToCalendarMinute(this._cal, minute);
        return this;
    }

    public HandyDate moveToMinuteJust() {
        DfTypeUtil.moveToCalendarMinuteJust(this._cal);
        return this;
    }

    public HandyDate moveToMinuteJustAdded(int minutes) {
        DfTypeUtil.moveToCalendarMinuteJustAdded(this._cal, minutes);
        return this;
    }

    public HandyDate moveToMinuteJustFor(int minute) {
        this.assertValidMinute(minute);
        DfTypeUtil.moveToCalendarMinuteJustFor(this._cal, minute);
        return this;
    }

    public HandyDate moveToMinuteTerminal() {
        DfTypeUtil.moveToCalendarMinuteTerminal(this._cal);
        return this;
    }

    public HandyDate moveToMinuteTerminal\u00c5dded(int minutes) {
        DfTypeUtil.moveToCalendarMinuteTerminalAdded(this._cal, minutes);
        return this;
    }

    public HandyDate moveToMinuteTerminalFor(int minute) {
        this.assertValidMinute(minute);
        DfTypeUtil.moveToCalendarMinuteTerminalFor(this._cal, minute);
        return this;
    }

    public HandyDate moveToSecond(int second) {
        this.assertValidSecond(second);
        DfTypeUtil.moveToCalendarSecond(this._cal, second);
        return this;
    }

    public HandyDate moveToSecondJust() {
        DfTypeUtil.moveToCalendarSecondJust(this._cal);
        return this;
    }

    public HandyDate moveToSecondJustFor(int second) {
        this.assertValidSecond(second);
        DfTypeUtil.moveToCalendarSecondJustFor(this._cal, second);
        return this;
    }

    public HandyDate moveToSecondJustAdded(int seconds) {
        DfTypeUtil.moveToCalendarSecondJustAdded(this._cal, seconds);
        return this;
    }

    public HandyDate moveToSecondTerminal() {
        DfTypeUtil.moveToCalendarSecondTerminal(this._cal);
        return this;
    }

    public HandyDate moveToSecondTerminalAdded(int seconds) {
        DfTypeUtil.moveToCalendarSecondTerminalAdded(this._cal, seconds);
        return this;
    }

    public HandyDate moveToSecondTerminalFor(int second) {
        this.assertValidSecond(second);
        DfTypeUtil.moveToCalendarSecondTerminalFor(this._cal, second);
        return this;
    }

    public HandyDate moveToMillisecond(int millisecond) {
        this.assertValidMillisecond(millisecond);
        DfTypeUtil.moveToCalendarMillisecond(this._cal, millisecond);
        return this;
    }

    public HandyDate moveToWeekJust() {
        DfTypeUtil.moveToCalendarWeekJust(this._cal, this._weekBeginDay);
        return this;
    }

    public HandyDate moveToWeekTerminal() {
        DfTypeUtil.moveToCalendarWeekTerminal(this._cal, this._weekBeginDay);
        return this;
    }

    public HandyDate moveToWeekOfMonth(int weekOfMonth) {
        DfTypeUtil.moveToCalendarWeekOfMonth(this._cal, weekOfMonth);
        return this;
    }

    public HandyDate moveToWeekOfYear(int weekOfYear) {
        DfTypeUtil.moveToCalendarWeekOfYear(this._cal, weekOfYear);
        return this;
    }

    public HandyDate moveToQuarterOfYearJust() {
        DfTypeUtil.moveToCalendarQuarterOfYearJust(this._cal, this._yearBeginMonth);
        this.moveToMonthJust();
        return this;
    }

    public HandyDate moveToQuarterOfYearJustAdded(int quarterOfYear) {
        DfTypeUtil.moveToCalendarQuarterOfYearJustAdded(this._cal, quarterOfYear, this._yearBeginMonth);
        this.moveToMonthJust();
        return this;
    }

    public HandyDate moveToQuarterOfYearJustFor(int quarterOfYear) {
        DfTypeUtil.moveToCalendarQuarterOfYearJustFor(this._cal, quarterOfYear, this._yearBeginMonth);
        this.moveToMonthJust();
        return this;
    }

    public HandyDate moveToQuarterOfYearTerminal() {
        DfTypeUtil.moveToCalendarQuarterOfYearTerminal(this._cal, this._yearBeginMonth);
        this.moveToMonthTerminal();
        return this;
    }

    public HandyDate moveToQuarterOfYearTerminalAdded(int quarterOfYear) {
        DfTypeUtil.moveToCalendarQuarterOfYearTerminalAdded(this._cal, quarterOfYear, this._yearBeginMonth);
        this.moveToMonthTerminal();
        return this;
    }

    public HandyDate moveToQuarterOfYearTerminalFor(int quarterOfYear) {
        DfTypeUtil.moveToCalendarQuarterOfYearTerminalFor(this._cal, quarterOfYear, this._yearBeginMonth);
        this.moveToMonthTerminal();
        return this;
    }

    public HandyDate moveToNextBusinessDay(BusinessDayDeterminer determiner) {
        block1: {
            this.assertArgumentNotNull("determiner", determiner);
            int addedLimit = 1000;
            int addedCount = 0;
            do {
                this.addDay(1);
                ++addedCount;
                if (determiner.isBusinessDay(this)) break block1;
            } while (addedCount <= 1000);
            String msg = "Business day is so far: limit=1000";
            throw new IllegalStateException(msg);
        }
        return this;
    }

    public HandyDate moveToNextBusinessDay(int movedDays, BusinessDayDeterminer determiner) {
        this.assertArgumentNotNull("determiner", determiner);
        if (movedDays < 0) {
            String msg = "The argument 'movedDays' should not be minus: " + movedDays;
            throw new IllegalArgumentException(msg);
        }
        for (int i = 0; i < movedDays; ++i) {
            this.moveToNextBusinessDay(determiner);
        }
        return this;
    }

    public HandyDate clearTimeParts() {
        DfTypeUtil.clearCalendarTimeParts(this._cal);
        return this;
    }

    public HandyDate clearMinuteWithRear() {
        DfTypeUtil.clearCalendarMinuteWithRear(this._cal);
        return this;
    }

    public HandyDate clearSecondWithRear() {
        DfTypeUtil.clearCalendarSecondWithRear(this._cal);
        return this;
    }

    public HandyDate clearMillisecond() {
        DfTypeUtil.clearCalendarMillisecond(this._cal);
        return this;
    }

    public boolean isMatch(Date date) {
        this.assertArgumentNotNull("date", date);
        return this._cal.getTimeInMillis() == date.getTime();
    }

    public boolean isGreaterThan(LocalDate date) {
        this.assertArgumentNotNull("date", date);
        return this.isGreaterThanAll(date);
    }

    public boolean isGreaterThan(LocalDateTime date) {
        this.assertArgumentNotNull("date", date);
        return this.isGreaterThanAll(date);
    }

    public boolean isGreaterThan(Date date) {
        this.assertArgumentNotNull("date", date);
        return this.isGreaterThanAll(date);
    }

    public boolean isGreaterThanAll(LocalDate ... dates) {
        return this.doCompareAll(this.createGreaterThanLocalDateCompareCallback(), dates);
    }

    public boolean isGreaterThanAll(LocalDateTime ... dates) {
        return this.doCompareAll(this.createGreaterThanLocalDateTimeCompareCallback(), dates);
    }

    public boolean isGreaterThanAll(Date ... dates) {
        return this.doCompareAll(this.createGreaterThanDateCompareCallback(), dates);
    }

    public boolean isGreaterThanAny(LocalDate ... dates) {
        return this.doCompareAny(this.createGreaterThanLocalDateCompareCallback(), dates);
    }

    public boolean isGreaterThanAny(LocalDateTime ... dates) {
        return this.doCompareAny(this.createGreaterThanLocalDateTimeCompareCallback(), dates);
    }

    public boolean isGreaterThanAny(Date ... dates) {
        return this.doCompareAny(this.createGreaterThanDateCompareCallback(), dates);
    }

    protected LocalDateCompareCallback createGreaterThanLocalDateCompareCallback() {
        return new LocalDateCompareCallback(){

            @Override
            public boolean isTarget(LocalDate current, LocalDate date) {
                return current.isAfter(date);
            }
        };
    }

    protected LocalDateTimeCompareCallback createGreaterThanLocalDateTimeCompareCallback() {
        return new LocalDateTimeCompareCallback(){

            @Override
            public boolean isTarget(LocalDateTime current, LocalDateTime date) {
                return current.isAfter(date);
            }
        };
    }

    protected DateCompareCallback createGreaterThanDateCompareCallback() {
        return new DateCompareCallback(){

            @Override
            public boolean isTarget(Date current, Date date) {
                return current.after(date);
            }
        };
    }

    public boolean isGreaterEqual(LocalDate date) {
        this.assertArgumentNotNull("date", date);
        return this.isGreaterEqualAll(date);
    }

    public boolean isGreaterEqual(LocalDateTime date) {
        this.assertArgumentNotNull("date", date);
        return this.isGreaterEqualAll(date);
    }

    public boolean isGreaterEqual(Date date) {
        this.assertArgumentNotNull("date", date);
        return this.isGreaterEqualAll(date);
    }

    public boolean isGreaterEqualAll(LocalDate ... dates) {
        return this.doCompareAll(this.createGreaterEqualLocalDateCompareCallback(), dates);
    }

    public boolean isGreaterEqualAll(LocalDateTime ... dates) {
        return this.doCompareAll(this.createGreaterEqualLocalDateTimeCompareCallback(), dates);
    }

    public boolean isGreaterEqualAll(Date ... dates) {
        return this.doCompareAll(this.createGreaterEqualDateCompareCallback(), dates);
    }

    public boolean isGreaterEqualAny(LocalDate ... dates) {
        return this.doCompareAny(this.createGreaterEqualLocalDateCompareCallback(), dates);
    }

    public boolean isGreaterEqualAny(LocalDateTime ... dates) {
        return this.doCompareAny(this.createGreaterEqualLocalDateTimeCompareCallback(), dates);
    }

    public boolean isGreaterEqualAny(Date ... dates) {
        return this.doCompareAny(this.createGreaterEqualDateCompareCallback(), dates);
    }

    protected LocalDateCompareCallback createGreaterEqualLocalDateCompareCallback() {
        return new LocalDateCompareCallback(){

            @Override
            public boolean isTarget(LocalDate current, LocalDate date) {
                return current.isAfter(date) || current.equals(date);
            }
        };
    }

    protected LocalDateTimeCompareCallback createGreaterEqualLocalDateTimeCompareCallback() {
        return new LocalDateTimeCompareCallback(){

            @Override
            public boolean isTarget(LocalDateTime current, LocalDateTime date) {
                return current.isAfter(date) || current.equals(date);
            }
        };
    }

    protected DateCompareCallback createGreaterEqualDateCompareCallback() {
        return new DateCompareCallback(){

            @Override
            public boolean isTarget(Date current, Date date) {
                return current.after(date) || current.equals(date);
            }
        };
    }

    public boolean isLessThan(LocalDate date) {
        this.assertArgumentNotNull("date", date);
        return this.isLessThanAll(date);
    }

    public boolean isLessThan(LocalDateTime date) {
        this.assertArgumentNotNull("date", date);
        return this.isLessThanAll(date);
    }

    public boolean isLessThan(Date date) {
        this.assertArgumentNotNull("date", date);
        return this.isLessThanAll(date);
    }

    public boolean isLessThanAll(LocalDate ... dates) {
        return this.doCompareAll(this.createLessThanLocalDateCompareCallback(), dates);
    }

    public boolean isLessThanAll(LocalDateTime ... dates) {
        return this.doCompareAll(this.createLessThanLocalDateTimeCompareCallback(), dates);
    }

    public boolean isLessThanAll(Date ... dates) {
        return this.doCompareAll(this.createLessThanDateCompareCallback(), dates);
    }

    public boolean isLessThanAny(LocalDate ... dates) {
        return this.doCompareAny(this.createLessThanLocalDateCompareCallback(), dates);
    }

    public boolean isLessThanAny(LocalDateTime ... dates) {
        return this.doCompareAny(this.createLessThanLocalDateTimeCompareCallback(), dates);
    }

    public boolean isLessThanAny(Date ... dates) {
        return this.doCompareAny(this.createLessThanDateCompareCallback(), dates);
    }

    protected LocalDateCompareCallback createLessThanLocalDateCompareCallback() {
        return new LocalDateCompareCallback(){

            @Override
            public boolean isTarget(LocalDate current, LocalDate date) {
                return current.isBefore(date);
            }
        };
    }

    protected LocalDateTimeCompareCallback createLessThanLocalDateTimeCompareCallback() {
        return new LocalDateTimeCompareCallback(){

            @Override
            public boolean isTarget(LocalDateTime current, LocalDateTime date) {
                return current.isBefore(date);
            }
        };
    }

    protected DateCompareCallback createLessThanDateCompareCallback() {
        return new DateCompareCallback(){

            @Override
            public boolean isTarget(Date current, Date date) {
                return current.before(date);
            }
        };
    }

    public boolean isLessEqual(LocalDate date) {
        this.assertArgumentNotNull("date", date);
        return this.isLessEqualAll(date);
    }

    public boolean isLessEqual(LocalDateTime date) {
        this.assertArgumentNotNull("date", date);
        return this.isLessEqualAll(date);
    }

    public boolean isLessEqual(Date date) {
        this.assertArgumentNotNull("date", date);
        return this.isLessEqualAll(date);
    }

    public boolean isLessEqualAll(LocalDate ... dates) {
        return this.doCompareAll(this.createLessEqualLocalDateCompareCallback(), dates);
    }

    public boolean isLessEqualAll(LocalDateTime ... dates) {
        return this.doCompareAll(this.createLessEqualLocalDateTimeCompareCallback(), dates);
    }

    public boolean isLessEqualAll(Date ... dates) {
        return this.doCompareAll(this.createLessEqualDateCompareCallback(), dates);
    }

    public boolean isLessEqualAny(LocalDate ... dates) {
        return this.doCompareAny(this.createLessEqualLocalDateCompareCallback(), dates);
    }

    public boolean isLessEqualAny(LocalDateTime ... dates) {
        return this.doCompareAny(this.createLessEqualLocalDateTimeCompareCallback(), dates);
    }

    public boolean isLessEqualAny(Date ... dates) {
        return this.doCompareAny(this.createLessEqualDateCompareCallback(), dates);
    }

    protected LocalDateCompareCallback createLessEqualLocalDateCompareCallback() {
        return new LocalDateCompareCallback(){

            @Override
            public boolean isTarget(LocalDate current, LocalDate date) {
                return current.isBefore(date) || current.equals(date);
            }
        };
    }

    protected LocalDateTimeCompareCallback createLessEqualLocalDateTimeCompareCallback() {
        return new LocalDateTimeCompareCallback(){

            @Override
            public boolean isTarget(LocalDateTime current, LocalDateTime date) {
                return current.isBefore(date) || current.equals(date);
            }
        };
    }

    protected DateCompareCallback createLessEqualDateCompareCallback() {
        return new DateCompareCallback(){

            @Override
            public boolean isTarget(Date current, Date date) {
                return current.before(date) || current.equals(date);
            }
        };
    }

    protected boolean doCompareAll(LocalDateCompareCallback callback, LocalDate ... dates) {
        this.assertCompareDateArrayValid(dates);
        LocalDate current = this.getLocalDate();
        for (LocalDate date : dates) {
            if (callback.isTarget(current, date)) continue;
            return false;
        }
        return true;
    }

    protected boolean doCompareAll(LocalDateTimeCompareCallback callback, LocalDateTime ... dates) {
        this.assertCompareDateArrayValid(dates);
        LocalDateTime current = this.getLocalDateTime();
        for (LocalDateTime date : dates) {
            if (callback.isTarget(current, date)) continue;
            return false;
        }
        return true;
    }

    protected boolean doCompareAll(DateCompareCallback callback, Date ... dates) {
        this.assertCompareDateArrayValid(dates);
        Date current = this.getDate();
        for (Date date : dates) {
            if (callback.isTarget(current, date)) continue;
            return false;
        }
        return true;
    }

    protected boolean doCompareAny(LocalDateCompareCallback callback, LocalDate ... dates) {
        this.assertCompareDateArrayValid(dates);
        LocalDate current = this.getLocalDate();
        for (LocalDate date : dates) {
            if (!callback.isTarget(current, date)) continue;
            return true;
        }
        return false;
    }

    protected boolean doCompareAny(LocalDateTimeCompareCallback callback, LocalDateTime ... dates) {
        this.assertCompareDateArrayValid(dates);
        LocalDateTime current = this.getLocalDateTime();
        for (LocalDateTime date : dates) {
            if (!callback.isTarget(current, date)) continue;
            return true;
        }
        return false;
    }

    protected boolean doCompareAny(DateCompareCallback callback, Date ... dates) {
        this.assertCompareDateArrayValid(dates);
        Date current = this.getDate();
        for (Date date : dates) {
            if (!callback.isTarget(current, date)) continue;
            return true;
        }
        return false;
    }

    protected void assertCompareDateArrayValid(LocalDate[] dates) {
        if (dates == null || dates.length == 0) {
            String msg = "The argument 'dates' should not be null or empty.";
            throw new IllegalArgumentException(msg);
        }
    }

    protected void assertCompareDateArrayValid(LocalDateTime[] dates) {
        if (dates == null || dates.length == 0) {
            String msg = "The argument 'dates' should not be null or empty.";
            throw new IllegalArgumentException(msg);
        }
    }

    protected void assertCompareDateArrayValid(Date[] dates) {
        if (dates == null || dates.length == 0) {
            String msg = "The argument 'dates' should not be null or empty.";
            throw new IllegalArgumentException(msg);
        }
    }

    public boolean isYear(int year) {
        return this.getYear() == year;
    }

    public boolean isYearSameAs(LocalDate date) {
        this.assertArgumentNotNull("date", date);
        return this.getYear() == this.prepareCompareDate(date).getYear();
    }

    public boolean isYearSameAs(LocalDateTime date) {
        this.assertArgumentNotNull("date", date);
        return this.getYear() == this.prepareCompareDate(date).getYear();
    }

    public boolean isYearSameAs(Date date) {
        this.assertArgumentNotNull("date", date);
        return this.getYear() == this.prepareCompareDate(date).getYear();
    }

    public boolean isYearSameAs(HandyDate handyDate) {
        this.assertArgumentNotNull("handyDate", handyDate);
        return this.getYear() == handyDate.getYear();
    }

    public boolean isYear_AnnoDomini() {
        return this.getYear() > 0;
    }

    public boolean isYear_BeforeChrist() {
        return this.getYear() < 0;
    }

    public boolean isMonth(int month) {
        return this.getMonthAsOneOrigin() == month;
    }

    public boolean isMonth(Month month) {
        this.assertArgumentNotNull("month", month);
        return this.getMonth() == month;
    }

    public boolean isMonthSameAs(LocalDate date) {
        this.assertArgumentNotNull("date", date);
        return this.getMonthAsOneOrigin() == this.prepareCompareDate(date).getMonthAsOneOrigin();
    }

    public boolean isMonthSameAs(LocalDateTime date) {
        this.assertArgumentNotNull("date", date);
        return this.getMonthAsOneOrigin() == this.prepareCompareDate(date).getMonthAsOneOrigin();
    }

    public boolean isMonthSameAs(Date date) {
        this.assertArgumentNotNull("date", date);
        return this.getMonthAsOneOrigin() == this.prepareCompareDate(date).getMonthAsOneOrigin();
    }

    public boolean isMonthSameAs(HandyDate handyDate) {
        this.assertArgumentNotNull("handyDate", handyDate);
        return this.getMonthAsOneOrigin() == handyDate.getMonthAsOneOrigin();
    }

    public boolean isMonthOfYearSameAs(LocalDate date) {
        this.assertArgumentNotNull("date", date);
        return this.isMonthOfYearSameAs(this.prepareCompareDate(date));
    }

    public boolean isMonthOfYearSameAs(LocalDateTime date) {
        this.assertArgumentNotNull("date", date);
        return this.isMonthOfYearSameAs(this.prepareCompareDate(date));
    }

    public boolean isMonthOfYearSameAs(Date date) {
        this.assertArgumentNotNull("date", date);
        return this.isMonthOfYearSameAs(this.prepareCompareDate(date));
    }

    public boolean isMonthOfYearSameAs(HandyDate handyDate) {
        this.assertArgumentNotNull("handyDate", handyDate);
        return this.isYearSameAs(handyDate) && this.getMonthAsOneOrigin() == handyDate.getMonthAsOneOrigin();
    }

    public boolean isMonth01_January() {
        return this.isMonth(1);
    }

    public boolean isMonth02_February() {
        return this.isMonth(2);
    }

    public boolean isMonth03_March() {
        return this.isMonth(3);
    }

    public boolean isMonth04_April() {
        return this.isMonth(4);
    }

    public boolean isMonth05_May() {
        return this.isMonth(5);
    }

    public boolean isMonth06_June() {
        return this.isMonth(6);
    }

    public boolean isMonth07_July() {
        return this.isMonth(7);
    }

    public boolean isMonth08_August() {
        return this.isMonth(8);
    }

    public boolean isMonth09_September() {
        return this.isMonth(9);
    }

    public boolean isMonth10_October() {
        return this.isMonth(10);
    }

    public boolean isMonth11_November() {
        return this.isMonth(11);
    }

    public boolean isMonth12_December() {
        return this.isMonth(12);
    }

    public boolean isDay(int day) {
        return this.getDay() == day;
    }

    public boolean isDaySameAs(LocalDate date) {
        this.assertArgumentNotNull("date", date);
        return this.getDay() == this.prepareCompareDate(date).getDay();
    }

    public boolean isDaySameAs(LocalDateTime date) {
        this.assertArgumentNotNull("date", date);
        return this.getDay() == this.prepareCompareDate(date).getDay();
    }

    public boolean isDaySameAs(Date date) {
        this.assertArgumentNotNull("date", date);
        return this.getDay() == this.prepareCompareDate(date).getDay();
    }

    public boolean isDaySameAs(HandyDate handyDate) {
        this.assertArgumentNotNull("handyDate", handyDate);
        return this.getDay() == handyDate.getDay();
    }

    public boolean isDayOfDateSameAs(LocalDate date) {
        this.assertArgumentNotNull("date", date);
        return this.isDayOfDateSameAs(this.prepareCompareDate(date));
    }

    public boolean isDayOfDateSameAs(LocalDateTime date) {
        this.assertArgumentNotNull("date", date);
        return this.isDayOfDateSameAs(this.prepareCompareDate(date));
    }

    public boolean isDayOfDateSameAs(Date date) {
        this.assertArgumentNotNull("date", date);
        return this.isDayOfDateSameAs(this.prepareCompareDate(date));
    }

    public boolean isDayOfDateSameAs(HandyDate handyDate) {
        this.assertArgumentNotNull("handyDate", handyDate);
        return this.isMonthOfYearSameAs(handyDate) && this.getDay() == handyDate.getDay();
    }

    public boolean isDay_MonthFirstDay() {
        return this.isDay(this._cal.getActualMinimum(5));
    }

    public boolean isDay_MonthLastDay() {
        return this.isDay(this._cal.getActualMaximum(5));
    }

    public boolean isHour(int hour) {
        return this.getHour() == hour;
    }

    public boolean isHourSameAs(LocalDateTime date) {
        this.assertArgumentNotNull("date", date);
        return this.isHourSameAs(this.prepareCompareDate(date));
    }

    public boolean isHourSameAs(Date date) {
        this.assertArgumentNotNull("date", date);
        return this.isHourSameAs(this.prepareCompareDate(date));
    }

    public boolean isHourSameAs(HandyDate handyDate) {
        this.assertArgumentNotNull("handyDate", handyDate);
        return this.getHour() == handyDate.getHour();
    }

    public boolean isHourOfDateSameAs(Date date) {
        this.assertArgumentNotNull("date", date);
        return this.isHourOfDateSameAs(this.prepareCompareDate(date));
    }

    public boolean isHourOfDateSameAs(HandyDate handyDate) {
        this.assertArgumentNotNull("handyDate", handyDate);
        return this.isDayOfDateSameAs(handyDate) && this.getHour() == handyDate.getHour();
    }

    public boolean isMinute(int minute) {
        return this.getMinute() == minute;
    }

    public boolean isMinuteSameAs(LocalDateTime date) {
        this.assertArgumentNotNull("date", date);
        return this.isMinuteSameAs(this.prepareCompareDate(date));
    }

    public boolean isMinuteSameAs(Date date) {
        this.assertArgumentNotNull("date", date);
        return this.isMinuteSameAs(this.prepareCompareDate(date));
    }

    public boolean isMinuteSameAs(HandyDate handyDate) {
        this.assertArgumentNotNull("handyDate", handyDate);
        return this.getMinute() == handyDate.getMinute();
    }

    public boolean isMinuteOfDateSameAs(LocalDate date) {
        this.assertArgumentNotNull("date", date);
        return this.isMinuteOfDateSameAs(this.prepareCompareDate(date));
    }

    public boolean isMinuteOfDateSameAs(LocalDateTime date) {
        this.assertArgumentNotNull("date", date);
        return this.isMinuteOfDateSameAs(this.prepareCompareDate(date));
    }

    public boolean isMinuteOfDateSameAs(Date date) {
        this.assertArgumentNotNull("date", date);
        return this.isMinuteOfDateSameAs(this.prepareCompareDate(date));
    }

    public boolean isMinuteOfDateSameAs(HandyDate handyDate) {
        this.assertArgumentNotNull("handyDate", handyDate);
        return this.isHourOfDateSameAs(handyDate) && this.getMinute() == handyDate.getMinute();
    }

    public boolean isSecond(int second) {
        return this.getSecond() == second;
    }

    public boolean isSecondSameAs(LocalDateTime date) {
        this.assertArgumentNotNull("date", date);
        return this.isSecondSameAs(this.prepareCompareDate(date));
    }

    public boolean isSecondSameAs(Date date) {
        this.assertArgumentNotNull("date", date);
        return this.isSecondSameAs(this.prepareCompareDate(date));
    }

    public boolean isSecondSameAs(HandyDate handyDate) {
        this.assertArgumentNotNull("handyDate", handyDate);
        return this.getSecond() == handyDate.getSecond();
    }

    public boolean isSecondOfDateSameAs(LocalDate date) {
        this.assertArgumentNotNull("date", date);
        return this.isSecondOfDateSameAs(this.prepareCompareDate(date));
    }

    public boolean isSecondOfDateSameAs(LocalDateTime date) {
        this.assertArgumentNotNull("date", date);
        return this.isSecondOfDateSameAs(this.prepareCompareDate(date));
    }

    public boolean isSecondOfDateSameAs(Date date) {
        this.assertArgumentNotNull("date", date);
        return this.isSecondOfDateSameAs(this.prepareCompareDate(date));
    }

    public boolean isSecondOfDateSameAs(HandyDate handyDate) {
        this.assertArgumentNotNull("handyDate", handyDate);
        return this.isMinuteOfDateSameAs(handyDate) && this.getSecond() == handyDate.getSecond();
    }

    public boolean isWeek_DayOfWeek1st_Sunday() {
        return this.getDayOfWeek() == 1;
    }

    public boolean isWeek_DayOfWeek2nd_Monday() {
        return this.getDayOfWeek() == 2;
    }

    public boolean isWeek_DayOfWeek3rd_Tuesday() {
        return this.getDayOfWeek() == 3;
    }

    public boolean isWeek_DayOfWeek4th_Wednesday() {
        return this.getDayOfWeek() == 4;
    }

    public boolean isWeek_DayOfWeek5th_Thursday() {
        return this.getDayOfWeek() == 5;
    }

    public boolean isWeek_DayOfWeek6th_Friday() {
        return this.getDayOfWeek() == 6;
    }

    public boolean isWeek_DayOfWeek7th_Saturday() {
        return this.getDayOfWeek() == 7;
    }

    public boolean isWeek_DayOfWeekWeekday() {
        return !this.isWeek_DayOfWeek1st_Sunday() && !this.isWeek_DayOfWeek7th_Saturday();
    }

    public boolean isWeek_DayOfWeekWeekend() {
        return this.isWeek_DayOfWeek1st_Sunday() || this.isWeek_DayOfWeek7th_Saturday();
    }

    public int calculateCalendarDistanceYears(LocalDate date) {
        return this.doCalculateCalendarDistanceYears(this.toDate(date));
    }

    public int calculateCalendarDistanceYears(LocalDateTime date) {
        return this.doCalculateCalendarDistanceYears(this.toDate(date));
    }

    public int calculateCalendarDistanceYears(Date date) {
        return this.doCalculateCalendarDistanceYears(date);
    }

    protected int doCalculateCalendarDistanceYears(Date date) {
        this.assertArgumentNotNull("date", date);
        if (this.isYearSameAs(date)) {
            return 0;
        }
        HandyDate you = this.prepareCompareDate(date);
        return you.getYear() - this.getYear();
    }

    public int calculateCalendarDistanceMonths(LocalDate date) {
        return this.doCalculateCalendarDistanceMonths(this.toDate(date));
    }

    public int calculateCalendarDistanceMonths(LocalDateTime date) {
        return this.doCalculateCalendarDistanceMonths(this.toDate(date));
    }

    public int calculateCalendarDistanceMonths(Date date) {
        return this.doCalculateCalendarDistanceMonths(date);
    }

    protected int doCalculateCalendarDistanceMonths(Date date) {
        this.assertArgumentNotNull("date", date);
        if (this.isMonthOfYearSameAs(date)) {
            return 0;
        }
        HandyDate you = this.prepareCompareDate(date);
        boolean greater = this.isGreaterThan(date);
        int countMonths = 0;
        while (!this.isMonthOfYearSameAs(you)) {
            int baseMonths;
            boolean sameAs = this.isYearSameAs(you);
            int n = sameAs ? this.getMonthAsOneOrigin() : (baseMonths = greater ? 12 : 1);
            int adjustmentMonths = sameAs ? 0 : (greater ? 1 : -1);
            int plusMonths = baseMonths - you.getMonthAsOneOrigin() + adjustmentMonths;
            you.addMonth(plusMonths);
            countMonths += plusMonths;
        }
        return -1 * countMonths;
    }

    public int calculateCalendarDistanceDays(LocalDate date) {
        return this.doCalculateCalendarDistanceDays(this.toDate(date));
    }

    public int calculateCalendarDistanceDays(LocalDateTime date) {
        return this.doCalculateCalendarDistanceDays(this.toDate(date));
    }

    public int calculateCalendarDistanceDays(Date date) {
        return this.doCalculateCalendarDistanceDays(date);
    }

    protected int doCalculateCalendarDistanceDays(Date date) {
        this.assertArgumentNotNull("date", date);
        if (this.isDayOfDateSameAs(date)) {
            return 0;
        }
        HandyDate you = this.prepareCompareDate(date);
        boolean greater = this.isGreaterThan(date);
        int countDays = 0;
        while (!this.isDayOfDateSameAs(you)) {
            int baseDays;
            boolean sameAs = this.isMonthOfYearSameAs(you);
            int n = sameAs ? this.getDay() : (baseDays = greater ? you.getLastDayOfMonth() : you.getFirstDayOfMonth());
            int adjustmentDays = sameAs ? 0 : (greater ? 1 : -1);
            int plusDays = baseDays - you.getDay() + adjustmentDays;
            you.addDay(plusDays);
            countDays += plusDays;
        }
        return -1 * countDays;
    }

    public int calculateCalendarDistanceHours(LocalDate date) {
        return this.doCalculateCalendarDistanceHours(this.toDate(date));
    }

    public int calculateCalendarDistanceHours(LocalDateTime date) {
        return this.doCalculateCalendarDistanceHours(this.toDate(date));
    }

    public int calculateCalendarDistanceHours(Date date) {
        return this.doCalculateCalendarDistanceHours(date);
    }

    protected int doCalculateCalendarDistanceHours(Date date) {
        this.assertArgumentNotNull("date", date);
        if (this.isHourOfDateSameAs(date)) {
            return 0;
        }
        HandyDate you = this.prepareCompareDate(date);
        boolean greater = this.isGreaterThan(date);
        int countHours = 0;
        while (!this.isHourOfDateSameAs(you)) {
            int baseHours;
            boolean sameAs = this.isDayOfDateSameAs(you);
            int n = sameAs ? this.getHour() : (baseHours = greater ? 23 : 0);
            int adjustmentHours = sameAs ? 0 : (greater ? 1 : -1);
            int plusHours = baseHours - you.getHour() + adjustmentHours;
            you.addHour(plusHours);
            countHours += plusHours;
        }
        return -1 * countHours;
    }

    public long calculateCalendarDistanceMinutes(LocalDate date) {
        return this.doCalculateCalendarDistanceMinutes(this.toDate(date));
    }

    public long calculateCalendarDistanceMinutes(LocalDateTime date) {
        return this.doCalculateCalendarDistanceMinutes(this.toDate(date));
    }

    public long calculateCalendarDistanceMinutes(Date date) {
        return this.doCalculateCalendarDistanceMinutes(date);
    }

    protected long doCalculateCalendarDistanceMinutes(Date date) {
        this.assertArgumentNotNull("date", date);
        if (this.isMinuteOfDateSameAs(date)) {
            return 0L;
        }
        HandyDate you = this.prepareCompareDate(date);
        boolean greater = this.isGreaterThan(date);
        long countMinutes = 0L;
        while (!this.isMinuteOfDateSameAs(you)) {
            int baseMinutes;
            boolean sameAs = this.isHourOfDateSameAs(you);
            int n = sameAs ? this.getMinute() : (baseMinutes = greater ? 59 : 0);
            int adjustmentMinutes = sameAs ? 0 : (greater ? 1 : -1);
            int plusMinutes = baseMinutes - you.getMinute() + adjustmentMinutes;
            you.addMinute(plusMinutes);
            countMinutes += (long)plusMinutes;
        }
        return -1L * countMinutes;
    }

    public long calculateCalendarDistanceSeconds(LocalDate date) {
        return this.doCalculateCalendarDistanceSeconds(this.toDate(date));
    }

    public long calculateCalendarDistanceSeconds(LocalDateTime date) {
        return this.doCalculateCalendarDistanceSeconds(this.toDate(date));
    }

    public long calculateCalendarDistanceSeconds(Date date) {
        return this.doCalculateCalendarDistanceSeconds(date);
    }

    protected long doCalculateCalendarDistanceSeconds(Date date) {
        this.assertArgumentNotNull("date", date);
        if (this.isSecondOfDateSameAs(date)) {
            return 0L;
        }
        HandyDate you = this.prepareCompareDate(date);
        boolean greater = this.isGreaterThan(date);
        long countSeconds = 0L;
        while (!this.isSecondOfDateSameAs(you)) {
            int baseSeconds;
            boolean sameAs = this.isMinuteOfDateSameAs(you);
            int n = sameAs ? this.getSecond() : (baseSeconds = greater ? 59 : 0);
            int adjustmentSeconds = sameAs ? 0 : (greater ? 1 : -1);
            int plusSeconds = baseSeconds - you.getSecond() + adjustmentSeconds;
            you.addSecond(plusSeconds);
            countSeconds += (long)plusSeconds;
        }
        return -1L * countSeconds;
    }

    public long calculateCalendarDistanceMilliseconds(Date date) {
        this.assertArgumentNotNull("date", date);
        return date.getTime() - this._cal.getTimeInMillis();
    }

    public int calculateMeasuredDistanceYears(LocalDate date) {
        return this.doCalculateMeasuredDistanceYears(this.toDate(date));
    }

    public int calculateMeasuredDistanceYears(LocalDateTime date) {
        return this.doCalculateMeasuredDistanceYears(this.toDate(date));
    }

    public int calculateMeasuredDistanceYears(Date date) {
        return this.doCalculateMeasuredDistanceYears(date);
    }

    protected int doCalculateMeasuredDistanceYears(Date date) {
        int months = this.calculateMeasuredDistanceMonths(date);
        return months / 12 + (months % 12 > 6 ? 1 : 0);
    }

    public int calculateMeasuredDistanceMonths(LocalDate date) {
        return this.doCalculateMeasuredDistanceMonths(this.toDate(date));
    }

    public int calculateMeasuredDistanceMonths(LocalDateTime date) {
        return this.doCalculateMeasuredDistanceMonths(this.toDate(date));
    }

    public int calculateMeasuredDistanceMonths(Date date) {
        return this.doCalculateMeasuredDistanceMonths(date);
    }

    protected int doCalculateMeasuredDistanceMonths(Date date) {
        int months;
        HandyDate copyInstance = this.createCopyInstance();
        int diffDays = copyInstance.addMonth(months = this.calculateCalendarDistanceMonths(date)).calculateCalendarDistanceDays(date);
        return months + (diffDays > 15 ? 1 : (diffDays < -15 ? -1 : 0));
    }

    public int calculateMeasuredDistanceDays(LocalDate date) {
        return this.doCalculateMeasuredDistanceDays(this.toDate(date));
    }

    public int calculateMeasuredDistanceDays(LocalDateTime date) {
        return this.doCalculateMeasuredDistanceDays(this.toDate(date));
    }

    public int calculateMeasuredDistanceDays(Date date) {
        return this.doCalculateMeasuredDistanceDays(date);
    }

    protected int doCalculateMeasuredDistanceDays(Date date) {
        int hours = this.calculateMeasuredDistanceHours(date);
        return hours / 24 + (hours % 24 > 12 ? 1 : 0);
    }

    public int calculateMeasuredDistanceHours(LocalDate date) {
        return this.doCalculateMeasuredDistanceHours(this.toDate(date));
    }

    public int calculateMeasuredDistanceHours(LocalDateTime date) {
        return this.doCalculateMeasuredDistanceHours(this.toDate(date));
    }

    public int calculateMeasuredDistanceHours(Date date) {
        return this.doCalculateMeasuredDistanceHours(date);
    }

    protected int doCalculateMeasuredDistanceHours(Date date) {
        long minutes = this.calculateMeasuredDistanceMinutes(date);
        return (int)(minutes / 60L) + (minutes % 60L > 30L ? 1 : 0);
    }

    public long calculateMeasuredDistanceMinutes(LocalDate date) {
        return this.doCalculateMeasuredDistanceMinutes(this.toDate(date));
    }

    public long calculateMeasuredDistanceMinutes(LocalDateTime date) {
        return this.doCalculateMeasuredDistanceMinutes(this.toDate(date));
    }

    public long calculateMeasuredDistanceMinutes(Date date) {
        return this.doCalculateMeasuredDistanceMinutes(date);
    }

    protected long doCalculateMeasuredDistanceMinutes(Date date) {
        long seconds = this.calculateMeasuredDistanceSeconds(date);
        return seconds / 60L + (seconds % 60L > 30L ? 1L : 0L);
    }

    public long calculateMeasuredDistanceSeconds(LocalDate date) {
        return this.doCalculateMeasuredDistanceSeconds(this.toDate(date));
    }

    public long calculateMeasuredDistanceSeconds(LocalDateTime date) {
        return this.doCalculateMeasuredDistanceSeconds(this.toDate(date));
    }

    public long calculateMeasuredDistanceSeconds(Date date) {
        return this.doCalculateMeasuredDistanceSeconds(date);
    }

    protected long doCalculateMeasuredDistanceSeconds(Date date) {
        long milliseconds = this.calculateCalendarDistanceMilliseconds(date);
        return milliseconds / 1000L + (milliseconds % 1000L > 500L ? 1L : 0L);
    }

    public int calculateSizeBusinessDays(LocalDate date, BusinessDayDeterminer determiner) {
        return this.doCalculateSizeBusinessDays(this.toDate(date), determiner);
    }

    public int calculateSizeBusinessDays(LocalDateTime date, BusinessDayDeterminer determiner) {
        return this.doCalculateSizeBusinessDays(this.toDate(date), determiner);
    }

    public int calculateSizeBusinessDays(Date date, BusinessDayDeterminer determiner) {
        return this.doCalculateSizeBusinessDays(date, determiner);
    }

    protected int doCalculateSizeBusinessDays(Date date, BusinessDayDeterminer determiner) {
        this.assertArgumentNotNull("date", date);
        if (this.isDayOfDateSameAs(date)) {
            return 0;
        }
        int countDays = 0;
        HandyDate you = this.prepareCompareDate(date);
        if (determiner.isBusinessDay(you)) {
            ++countDays;
        }
        boolean greater = this.isGreaterThan(date);
        while (!this.isDayOfDateSameAs(you)) {
            you.addDay(greater ? 1 : -1);
            if (!determiner.isBusinessDay(you)) continue;
            ++countDays;
        }
        return countDays > 0 ? countDays : countDays * -1;
    }

    public int calculateSizeWeekdays(LocalDate date) {
        this.assertArgumentNotNull("date", date);
        return this.doCalculateSizeWeekdays(this.toDate(date));
    }

    public int calculateSizeWeekdays(LocalDateTime date) {
        this.assertArgumentNotNull("date", date);
        return this.doCalculateSizeWeekdays(this.toDate(date));
    }

    public int calculateSizeWeekdays(Date date) {
        this.assertArgumentNotNull("date", date);
        return this.doCalculateSizeWeekdays(date);
    }

    protected int doCalculateSizeWeekdays(Date date) {
        return this.calculateSizeBusinessDays(date, (HandyDate hd) -> hd.isWeek_DayOfWeekWeekday());
    }

    public int calculateSizeWeekendDays(LocalDate date) {
        this.assertArgumentNotNull("date", date);
        return this.doCalculateSizeWeekendDays(this.toDate(date));
    }

    public int calculateSizeWeekendDays(LocalDateTime date) {
        this.assertArgumentNotNull("date", date);
        return this.doCalculateSizeWeekendDays(this.toDate(date));
    }

    public int calculateSizeWeekendDays(Date date) {
        this.assertArgumentNotNull("date", date);
        return this.doCalculateSizeWeekendDays(date);
    }

    protected int doCalculateSizeWeekendDays(Date date) {
        return this.calculateSizeBusinessDays(date, (HandyDate hd) -> hd.isWeek_DayOfWeekWeekend());
    }

    public LocalDate chooseNearestDate(LocalDate ... dates) {
        return this.toLocalDate(this.doChooseNearestDate(this.toDateArray(dates)));
    }

    public LocalDateTime chooseNearestDate(LocalDateTime ... dates) {
        return this.toLocalDateTime(this.doChooseNearestDate(this.toDateArray(dates)));
    }

    public Date chooseNearestDate(Date ... dates) {
        return this.doChooseNearestDate(dates);
    }

    protected Date doChooseNearestDate(Date ... dates) {
        this.assertCompareDateArrayValid(dates);
        Long nearestMillis = null;
        Date nearestDate = null;
        long standardMillis = this._cal.getTimeInMillis();
        for (Date date : dates) {
            long distanceMillis = date.getTime() - standardMillis;
            boolean past = false;
            if (distanceMillis < 0L) {
                distanceMillis *= -1L;
                past = true;
            }
            if (nearestMillis == null || nearestMillis > distanceMillis) {
                nearestMillis = distanceMillis;
                nearestDate = date;
                continue;
            }
            if (nearestMillis != distanceMillis || past) continue;
            nearestDate = date;
        }
        return nearestDate;
    }

    public LocalDate chooseNearestFutureDate(LocalDate ... dates) {
        return this.toLocalDate(this.doChooseNearestFutureDate(this.toDateArray(dates)));
    }

    public LocalDateTime chooseNearestFutureDate(LocalDateTime ... dates) {
        return this.toLocalDateTime(this.doChooseNearestFutureDate(this.toDateArray(dates)));
    }

    public Date chooseNearestFutureDate(Date ... dates) {
        return this.doChooseNearestFutureDate(dates);
    }

    protected Date doChooseNearestFutureDate(Date ... dates) {
        this.assertCompareDateArrayValid(dates);
        Long nearestMillis = null;
        Date nearestDate = null;
        long standardMillis = this._cal.getTimeInMillis();
        for (Date date : dates) {
            long distanceMillis = date.getTime() - standardMillis;
            if (distanceMillis < 0L || nearestMillis != null && nearestMillis <= distanceMillis) continue;
            nearestMillis = distanceMillis;
            nearestDate = date;
        }
        return nearestDate;
    }

    public LocalDate chooseNearestPastDate(LocalDate ... dates) {
        return this.toLocalDate(this.doChooseNearestPastDate(this.toDateArray(dates)));
    }

    public LocalDateTime chooseNearestPastDate(LocalDateTime ... dates) {
        return this.toLocalDateTime(this.doChooseNearestPastDate(this.toDateArray(dates)));
    }

    public Date chooseNearestPastDate(Date ... dates) {
        return this.doChooseNearestPastDate(dates);
    }

    protected Date doChooseNearestPastDate(Date ... dates) {
        this.assertCompareDateArrayValid(dates);
        Long nearestMillis = null;
        Date nearestDate = null;
        long standardMillis = this._cal.getTimeInMillis();
        for (Date date : dates) {
            long distanceMillis = date.getTime() - standardMillis;
            if (distanceMillis > 0L || nearestMillis != null && nearestMillis <= (distanceMillis *= -1L)) continue;
            nearestMillis = distanceMillis;
            nearestDate = date;
        }
        return nearestDate;
    }

    public HandyDate beginYear_Month(LocalDate yearBeginMonth) {
        this.doBeginYear_Month(this.toDate(yearBeginMonth));
        return this;
    }

    public HandyDate beginYear_Month(LocalDateTime yearBeginMonth) {
        this.doBeginYear_Month(this.toDate(yearBeginMonth));
        return this;
    }

    public HandyDate beginYear_Month(Date yearBeginMonth) {
        this.doBeginYear_Month(yearBeginMonth);
        return this;
    }

    protected void doBeginYear_Month(Date yearBeginMonth) {
        this.assertArgumentNotNull("yearBeginMonth", yearBeginMonth);
        this._yearBeginMonth = new HandyDate(yearBeginMonth).timeZone(this.getCalendarTimeZone()).getMonthAsOneOrigin();
    }

    public HandyDate beginYear_Month(int yearBeginMonth) {
        this.assertNotMinusNotOver("yearBeginMonth", yearBeginMonth, 12);
        this._yearBeginMonth = yearBeginMonth;
        return this;
    }

    public HandyDate beginYear_Month01_January() {
        this._yearBeginMonth = 1;
        return this;
    }

    public HandyDate beginYear_Month02_February() {
        this._yearBeginMonth = 2;
        return this;
    }

    public HandyDate beginYear_Month03_March() {
        this._yearBeginMonth = 3;
        return this;
    }

    public HandyDate beginYear_Month04_April() {
        this._yearBeginMonth = 4;
        return this;
    }

    public HandyDate beginYear_Month05_May() {
        this._yearBeginMonth = 5;
        return this;
    }

    public HandyDate beginYear_Month06_June() {
        this._yearBeginMonth = 6;
        return this;
    }

    public HandyDate beginYear_Month07_July() {
        this._yearBeginMonth = 7;
        return this;
    }

    public HandyDate beginYear_Month08_August() {
        this._yearBeginMonth = 8;
        return this;
    }

    public HandyDate beginYear_Month09_September() {
        this._yearBeginMonth = 9;
        return this;
    }

    public HandyDate beginYear_Month10_October() {
        this._yearBeginMonth = 10;
        return this;
    }

    public HandyDate beginYear_Month11_November() {
        this._yearBeginMonth = 11;
        return this;
    }

    public HandyDate beginYear_Month12_December() {
        this._yearBeginMonth = 12;
        return this;
    }

    public HandyDate beginYear_PreviousMonth(int yearBeginMonth) {
        this.assertNotMinusNotOver("yearBeginMonth", yearBeginMonth, 12);
        this._yearBeginMonth = -yearBeginMonth;
        return this;
    }

    public HandyDate beginMonth_Day(LocalDate monthBeginDay) {
        this.doBeginMonth_Day(this.toDate(monthBeginDay));
        return this;
    }

    public HandyDate beginMonth_Day(LocalDateTime monthBeginDay) {
        this.doBeginMonth_Day(this.toDate(monthBeginDay));
        return this;
    }

    public HandyDate beginMonth_Day(Date monthBeginDay) {
        this.doBeginMonth_Day(monthBeginDay);
        return this;
    }

    protected void doBeginMonth_Day(Date monthBeginDay) {
        this.assertArgumentNotNull("monthBeginDay", monthBeginDay);
        this._monthBeginDay = new HandyDate(monthBeginDay).timeZone(this.getCalendarTimeZone()).getDay();
    }

    public HandyDate beginMonth_Day(int monthBeginDay) {
        this.assertNotMinusNotOver("monthBeginDay", monthBeginDay, 31);
        this._monthBeginDay = monthBeginDay;
        return this;
    }

    public HandyDate beginMonth_PreviousDay(int monthBeginDay) {
        this.assertNotMinusNotOver("monthBeginDay", monthBeginDay, 31);
        this._monthBeginDay = -monthBeginDay;
        return this;
    }

    public HandyDate beginDay_Hour(LocalDate dayBeginHour) {
        this.doBeginDay_Hour(this.toDate(dayBeginHour));
        return this;
    }

    public HandyDate beginDay_Hour(LocalDateTime dayBeginHour) {
        this.doBeginDay_Hour(this.toDate(dayBeginHour));
        return this;
    }

    public HandyDate beginDay_Hour(Date dayBeginHour) {
        this.doBeginDay_Hour(dayBeginHour);
        return this;
    }

    protected void doBeginDay_Hour(Date dayBeginHour) {
        this.assertArgumentNotNull("dayBeginHour", dayBeginHour);
        this._dayBeginHour = new HandyDate(dayBeginHour).timeZone(this.getCalendarTimeZone()).getHour();
    }

    public HandyDate beginDay_Hour(int dayBeginHour) {
        this.assertNotMinusNotOver("dayBeginHour", dayBeginHour, 23);
        this._dayBeginHour = dayBeginHour;
        return this;
    }

    public HandyDate beginDay_PreviousHour(int dayBeginHour) {
        this.assertNotMinusNotOver("dayBeginHour", dayBeginHour, 23);
        this._dayBeginHour = -dayBeginHour;
        return this;
    }

    public HandyDate beginWeek_DayOfWeek(LocalDate weekBeginDayOfWeek) {
        this.doBeginWeek_DayOfWeek(this.toDate(weekBeginDayOfWeek));
        return this;
    }

    public HandyDate beginWeek_DayOfWeek(LocalDateTime weekBeginDayOfWeek) {
        this.doBeginWeek_DayOfWeek(this.toDate(weekBeginDayOfWeek));
        return this;
    }

    public HandyDate beginWeek_DayOfWeek(Date weekBeginDayOfWeek) {
        this.doBeginWeek_DayOfWeek(weekBeginDayOfWeek);
        return this;
    }

    protected void doBeginWeek_DayOfWeek(Date weekBeginDayOfWeek) {
        this.assertArgumentNotNull("weekBeginDayOfWeek", weekBeginDayOfWeek);
        this._weekBeginDay = new HandyDate(weekBeginDayOfWeek).timeZone(this.getCalendarTimeZone()).getDayOfWeek();
    }

    public HandyDate beginWeek_DayOfWeek1st_Sunday() {
        this._weekBeginDay = 1;
        return this;
    }

    public HandyDate beginWeek_DayOfWeek2nd_Monday() {
        this._weekBeginDay = 2;
        return this;
    }

    public HandyDate beginWeek_DayOfWeek3rd_Tuesday() {
        this._weekBeginDay = 3;
        return this;
    }

    public HandyDate beginWeek_DayOfWeek4th_Wednesday() {
        this._weekBeginDay = 4;
        return this;
    }

    public HandyDate beginWeek_DayOfWeek5th_Thursday() {
        this._weekBeginDay = 5;
        return this;
    }

    public HandyDate beginWeek_DayOfWeek6th_Friday() {
        this._weekBeginDay = 6;
        return this;
    }

    public HandyDate beginWeek_DayOfWeek7th_Saturday() {
        this._weekBeginDay = 7;
        return this;
    }

    public LocalDate getLocalDate() {
        return DfTypeUtil.toLocalDate((Object)this.getDate(), this.getCalendarTimeZone());
    }

    public LocalDateTime getLocalDateTime() {
        return DfTypeUtil.toLocalDateTime((Object)this.getDate(), this.getCalendarTimeZone());
    }

    public Date getDate() {
        return new Date(this._cal.getTimeInMillis());
    }

    public Timestamp getTimestamp() {
        return new Timestamp(this._cal.getTimeInMillis());
    }

    public TimeZone getTimeZone() {
        return this.getCalendarTimeZone();
    }

    protected TimeZone getCalendarTimeZone() {
        return this._cal.getTimeZone();
    }

    public int getYear() {
        int year = this._cal.get(1);
        int era = this._cal.get(0);
        return era == 1 ? year : -year;
    }

    public Month getMonth() {
        return Month.of(this.getMonthAsOneOrigin());
    }

    public int getMonthAsOneOrigin() {
        return this._cal.get(2) + 1;
    }

    public int getMonthAsZeroOrigin() {
        return this._cal.get(2);
    }

    public int getDay() {
        return this._cal.get(5);
    }

    public int getHour() {
        return this._cal.get(11);
    }

    public int getMinute() {
        return this._cal.get(12);
    }

    public int getSecond() {
        return this._cal.get(13);
    }

    public int getMillisecond() {
        return this._cal.get(14);
    }

    public int getDayOfWeek() {
        return this._cal.get(7);
    }

    public int getWeekOfMonth() {
        return this._cal.get(4);
    }

    public int getWeekOfYear() {
        return this._cal.get(3);
    }

    public int getFirstDayOfMonth() {
        return this._cal.getActualMinimum(5);
    }

    public int getLastDayOfMonth() {
        return this._cal.getActualMaximum(5);
    }

    public String toDisp(String pattern) {
        this.assertArgumentNotNull("pattern", pattern);
        Date date = this._cal.getTime();
        DateFormat dateFormat = this.createDateFormat(pattern, this.getCalendarTimeZone(), null);
        return dateFormat.format(date);
    }

    public String toDisp(String pattern, TimeZone timeZone) {
        this.assertArgumentNotNull("pattern", pattern);
        this.assertArgumentNotNull("timeZone", timeZone);
        Date date = this._cal.getTime();
        DateFormat dateFormat = this.createDateFormat(pattern, timeZone, null);
        return dateFormat.format(date);
    }

    public String toDisp(String pattern, Locale locale) {
        this.assertArgumentNotNull("pattern", pattern);
        this.assertArgumentNotNull("locale", locale);
        Date date = this._cal.getTime();
        DateFormat dateFormat = this.createDateFormat(pattern, this.getCalendarTimeZone(), locale);
        return dateFormat.format(date);
    }

    public String toDisp(String pattern, TimeZone timeZone, Locale locale) {
        this.assertArgumentNotNull("pattern", pattern);
        this.assertArgumentNotNull("timeZone", timeZone);
        this.assertArgumentNotNull("locale", locale);
        Date date = this._cal.getTime();
        DateFormat dateFormat = this.createDateFormat(pattern, timeZone, locale);
        return dateFormat.format(date);
    }

    protected DateFormat createDateFormat(String pattern, TimeZone timeZone, Locale locale) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(pattern, this.chooseRealLocale(locale));
        if (timeZone != null) {
            dateFormat.setTimeZone(timeZone);
        }
        return dateFormat;
    }

    public boolean equals(Object obj) {
        if (obj instanceof HandyDate) {
            HandyDate date = (HandyDate)obj;
            String pattern = this.getBasicDispPattern();
            return date.toDisp(pattern).equals(this.toDisp(pattern));
        }
        return false;
    }

    public int hashCode() {
        return this.toDisp(this.getBasicDispPattern()).hashCode();
    }

    public String toString() {
        return this.toDisp(this.getBasicDispPattern());
    }

    protected String getBasicDispPattern() {
        String prefix = this.isYear_BeforeChrist() ? "'BC'" : "";
        return prefix + DfTypeUtil.SLASHED_TIMESTAMP_PATTERN;
    }

    public HandyDate deepCopy() {
        HandyDate cloned = this.createCopyInstance();
        this.inheritBeginAttribute(cloned);
        return cloned;
    }

    protected HandyDate createCopyInstance() {
        return this.createCopyInstance(this.getDate());
    }

    protected HandyDate createCopyInstance(LocalDate date) {
        HandyDate copy = new HandyDate(date, this.getCalendarTimeZone());
        this.inheritBeginAttribute(copy);
        return copy;
    }

    protected HandyDate createCopyInstance(LocalDateTime date) {
        HandyDate copy = new HandyDate(date, this.getCalendarTimeZone());
        this.inheritBeginAttribute(copy);
        return copy;
    }

    protected HandyDate createCopyInstance(Date date) {
        HandyDate copy = new HandyDate(date);
        this.inheritTimeZone(copy);
        this.inheritBeginAttribute(copy);
        return copy;
    }

    protected void inheritTimeZone(HandyDate copy) {
        TimeZone timeZone = this.getCalendarTimeZone();
        if (timeZone != null) {
            copy.timeZone(timeZone);
        }
    }

    protected void inheritBeginAttribute(HandyDate cloned) {
        cloned._yearBeginMonth = this._yearBeginMonth;
        cloned._monthBeginDay = this._monthBeginDay;
        cloned._dayBeginHour = this._dayBeginHour;
        cloned._weekBeginDay = this._weekBeginDay;
    }

    protected LocalDate toLocalDate(Date date) {
        return DfTypeUtil.toLocalDate((Object)date, this.getCalendarTimeZone());
    }

    protected LocalDateTime toLocalDateTime(Date date) {
        return DfTypeUtil.toLocalDateTime((Object)date, this.getCalendarTimeZone());
    }

    protected Date toDate(LocalDate date) {
        return DfTypeUtil.toDate((Object)date, this.getCalendarTimeZone());
    }

    protected Date toDate(LocalDateTime date) {
        return DfTypeUtil.toDate((Object)date, this.getCalendarTimeZone());
    }

    protected Date[] toDateArray(LocalDate ... dates) {
        Date[] utilDates = new Date[dates.length];
        int index = 0;
        for (LocalDate localDate : dates) {
            utilDates[index] = this.toDate(localDate);
            ++index;
        }
        return utilDates;
    }

    protected Date[] toDateArray(LocalDateTime ... dates) {
        Date[] utilDates = new Date[dates.length];
        int index = 0;
        for (LocalDateTime localDateTime : dates) {
            utilDates[index] = this.toDate(localDateTime);
            ++index;
        }
        return utilDates;
    }

    protected HandyDate prepareCompareDate(LocalDate date) {
        return this.createCopyInstance(date);
    }

    protected HandyDate prepareCompareDate(LocalDateTime date) {
        return this.createCopyInstance(date);
    }

    protected HandyDate prepareCompareDate(Date date) {
        return this.createCopyInstance(date);
    }

    protected void assertArgumentNotNull(String name, Object value) {
        if (value == null) {
            String msg = "The argument '" + name + "' should not be null.";
            throw new IllegalArgumentException(msg);
        }
    }

    protected void assertNotMinusNotOver(String name, int value, int max) {
        if (value < 0) {
            String msg = "The argument '" + name + "' should not be minus: value=" + value;
            throw new IllegalArgumentException(msg);
        }
        if (value > max) {
            String msg = "The argument '" + name + "' should not be over: value=" + value + " max=" + max;
            throw new IllegalArgumentException(msg);
        }
    }

    protected void assertValidMonth(int month) {
        if (month < 1 || month > 12) {
            String msg = "The argument 'month' should be 1 to 12: " + month;
            throw new IllegalArgumentException(msg);
        }
    }

    protected void assertValidDay(int day) {
        int firstDayOfMonth = this.getFirstDayOfMonth();
        int lastDayOfMonth = this.getLastDayOfMonth();
        if (day < firstDayOfMonth || day > lastDayOfMonth) {
            String msg = "The argument 'day' should be " + firstDayOfMonth + " to " + lastDayOfMonth + ": " + day;
            throw new IllegalArgumentException(msg);
        }
    }

    protected void assertValidHour(int hour) {
    }

    protected void assertValidMinute(int minute) {
        if (minute < 0 || minute > 59) {
            String msg = "The argument 'minute' should be 0 to 59: " + minute;
            throw new IllegalArgumentException(msg);
        }
    }

    protected void assertValidSecond(int second) {
        if (second < 0 || second > 59) {
            String msg = "The argument 'second' should be 0 to 59: " + second;
            throw new IllegalArgumentException(msg);
        }
    }

    protected void assertValidMillisecond(int millisecond) {
        if (millisecond < 0 || millisecond > 999) {
            String msg = "The argument 'millisecond' should be 0 to 999: " + millisecond;
            throw new IllegalArgumentException(msg);
        }
    }
}

