/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.outsidesql;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.dbflute.FunCustodial;
import org.dbflute.cbean.coption.FromToOption;
import org.dbflute.cbean.coption.LikeSearchOption;
import org.dbflute.exception.IllegalOutsideSqlOperationException;
import org.dbflute.exception.RequiredOptionNotFoundException;
import org.dbflute.jdbc.ShortCharHandlingMode;
import org.dbflute.system.DBFluteSystem;
import org.dbflute.util.DfCollectionUtil;
import org.dbflute.util.DfTypeUtil;
import org.dbflute.util.Srl;

public class PmbCustodial {
    public static String convertEmptyToNull(String value) {
        return Srl.isEmpty(value) ? null : value;
    }

    public static String handleShortChar(String parameterName, String value, Integer size, PmbShortCharHandlingMode mode) {
        if (mode == null) {
            throw new IllegalArgumentException("The argument 'mode' should not be null: " + parameterName);
        }
        return FunCustodial.handleShortChar(parameterName, value, size, mode.toWrappedMode());
    }

    public static void assertLikeSearchOptionValid(String name, LikeSearchOption option) {
        if (option == null) {
            throw new RequiredOptionNotFoundException("The like-search option is required: " + name);
        }
        if (option.isSplit()) {
            String msg = "The split of like-search is NOT available on parameter-bean: " + name + ", " + option;
            throw new IllegalOutsideSqlOperationException(msg);
        }
    }

    public static String formatByteArray(byte[] bytes) {
        return "byte[" + (bytes != null ? String.valueOf(bytes.length) : "null") + "]";
    }

    public static Date toUtilDate(Object date, TimeZone specifiedZone) {
        return DfTypeUtil.toDate(date, PmbCustodial.chooseRealTimeZone(specifiedZone));
    }

    public static <DATE> DATE toLocalDate(Date date, Class<DATE> localType, TimeZone timeZone) {
        if (LocalDate.class.isAssignableFrom(localType)) {
            return (DATE)DfTypeUtil.toLocalDate((Object)date, timeZone);
        }
        if (LocalDateTime.class.isAssignableFrom(localType)) {
            return (DATE)DfTypeUtil.toLocalDateTime((Object)date, timeZone);
        }
        return null;
    }

    public static String formatUtilDate(Date date, TimeZone specifiedZone, String pattern) {
        TimeZone realZone = PmbCustodial.chooseRealTimeZone(specifiedZone);
        Locale realLocale = DBFluteSystem.getFinalLocale();
        return DfTypeUtil.toStringDate(date, realZone, pattern, realLocale);
    }

    public static void assertFromToOptionValid(String name, FromToOption option) {
        if (option == null) {
            String msg = "The from-to option is required!";
            throw new RequiredOptionNotFoundException(msg);
        }
    }

    public static FromToOption createFromToOption(TimeZone specifiedZone) {
        return new FromToOption().zone(PmbCustodial.chooseRealTimeZone(specifiedZone));
    }

    public static TimeZone chooseRealTimeZone(TimeZone specifiedZone) {
        return specifiedZone != null ? specifiedZone : DBFluteSystem.getFinalTimeZone();
    }

    public static <NUMBER extends Number> NUMBER toNumber(Object obj, Class<NUMBER> type) {
        return (NUMBER)DfTypeUtil.toNumber(obj, type);
    }

    public static Boolean toBoolean(Object obj) {
        return DfTypeUtil.toBoolean(obj);
    }

    public static <ELEMENT> ArrayList<ELEMENT> newArrayList(ELEMENT ... elements) {
        ArrayList<ELEMENT> obj = DfCollectionUtil.newArrayList(elements);
        return obj;
    }

    public static enum PmbShortCharHandlingMode {
        RFILL(ShortCharHandlingMode.RFILL),
        LFILL(ShortCharHandlingMode.LFILL),
        EXCEPTION(ShortCharHandlingMode.EXCEPTION),
        NONE(ShortCharHandlingMode.NONE);

        protected final ShortCharHandlingMode _mode;

        private PmbShortCharHandlingMode(ShortCharHandlingMode mode) {
            this._mode = mode;
        }

        public ShortCharHandlingMode toWrappedMode() {
            return this._mode;
        }
    }
}

