/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.s2dao.extension;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dbflute.Entity;
import org.dbflute.bhv.core.context.ConditionBeanContext;
import org.dbflute.bhv.core.context.InternalMapContext;
import org.dbflute.bhv.core.context.ResourceContext;
import org.dbflute.cbean.ConditionBean;
import org.dbflute.cbean.chelper.HpDerivingSubQueryInfo;
import org.dbflute.cbean.sqlclause.SqlClause;
import org.dbflute.dbmeta.DBMeta;
import org.dbflute.dbmeta.accessory.ColumnNullObjectable;
import org.dbflute.dbmeta.accessory.DerivedMappable;
import org.dbflute.dbmeta.accessory.DerivedTypeHandler;
import org.dbflute.dbmeta.info.ColumnInfo;
import org.dbflute.exception.MappingClassCastException;
import org.dbflute.helper.message.ExceptionMessageBuilder;
import org.dbflute.jdbc.ValueType;
import org.dbflute.s2dao.metadata.TnBeanMetaData;
import org.dbflute.s2dao.metadata.TnPropertyMapping;
import org.dbflute.s2dao.rowcreator.impl.TnRowCreatorImpl;
import org.dbflute.s2dao.valuetype.TnValueTypes;
import org.dbflute.system.DBFluteSystem;
import org.dbflute.util.DfTypeUtil;
import org.dbflute.util.Srl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TnRowCreatorExtension
extends TnRowCreatorImpl {
    private static final Logger _log = LoggerFactory.getLogger(TnRowCreatorExtension.class);
    protected static final String DBMETA_CACHE_KEY = "df:DBMetaCache";
    protected static final String DERIVED_MAPPABLE_ALIAS_PREFIX = "$";
    protected DBMeta _fixedDBMeta;
    protected boolean _creatableByDBMeta;

    protected TnRowCreatorExtension() {
    }

    public static TnRowCreatorExtension createRowCreator(Class<?> beanClass) {
        DBMeta dbmeta;
        TnRowCreatorExtension rowCreator = new TnRowCreatorExtension();
        if (beanClass != null && (dbmeta = TnRowCreatorExtension.findDBMetaByClass(beanClass)) != null) {
            rowCreator.setFixedDBMeta(dbmeta);
            rowCreator.setCreatableByDBMeta(TnRowCreatorExtension.isCreatableByDBMeta(beanClass, dbmeta.getEntityType()));
        }
        return rowCreator;
    }

    protected static DBMeta findDBMetaByClass(Class<?> beanClass) {
        if (!Entity.class.isAssignableFrom(beanClass)) {
            return null;
        }
        Object instance = TnRowCreatorExtension.newInstance(beanClass);
        return ((Entity)instance).asDBMeta();
    }

    protected static Object newInstance(Class<?> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (InstantiationException e) {
            throw new IllegalStateException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
    }

    protected static boolean isCreatableByDBMeta(Class<?> beanClass, Class<?> entityType) {
        return beanClass.isAssignableFrom(entityType);
    }

    @Override
    public Object createRow(ResultSet rs, Map<String, Map<String, Integer>> selectIndexMap, Map<String, TnPropertyMapping> propertyCache, Class<?> beanClass, ConditionBean cb) throws SQLException {
        DBMeta dbmeta;
        Object row;
        if (propertyCache.isEmpty()) {
            String msg = "The propertyCache should not be empty: bean=" + beanClass.getName();
            throw new IllegalStateException(msg);
        }
        String columnName = null;
        TnPropertyMapping mapping = null;
        String propertyName = null;
        Object selectedValue = null;
        ColumnInfo columnInfo = null;
        if (this._fixedDBMeta != null) {
            if (this._creatableByDBMeta) {
                Entity entity = this._fixedDBMeta.newEntity();
                this.reflectConditionBeanOptionToEntity(cb, entity);
                row = entity;
            } else {
                row = this.newBean(beanClass);
            }
            dbmeta = this._fixedDBMeta;
        } else {
            row = this.newBean(beanClass);
            dbmeta = TnRowCreatorExtension.findCachedDBMeta(row);
        }
        try {
            if (dbmeta != null) {
                boolean isEntity = row instanceof Entity;
                Entity entityRow = isEntity ? (Entity)row : null;
                for (Map.Entry<String, TnPropertyMapping> entry : propertyCache.entrySet()) {
                    columnName = entry.getKey();
                    mapping = entry.getValue();
                    propertyName = mapping.getPropertyName();
                    selectedValue = this.getValue(rs, columnName, mapping.getValueType(), selectIndexMap);
                    columnInfo = mapping.getEntityColumnInfo();
                    if (columnInfo != null && isEntity) {
                        columnInfo.write(entityRow, selectedValue);
                        continue;
                    }
                    mapping.getPropertyAccessor().setValue(row, selectedValue);
                }
                if (this.canHandleDerivedMap(row)) {
                    this.processDerivedMap(rs, selectIndexMap, propertyCache, row);
                }
            } else {
                for (Map.Entry<String, TnPropertyMapping> entry : propertyCache.entrySet()) {
                    columnName = entry.getKey();
                    mapping = entry.getValue();
                    propertyName = mapping.getPropertyName();
                    selectedValue = this.getValue(rs, columnName, mapping.getValueType(), selectIndexMap);
                    mapping.getPropertyAccessor().setValue(row, selectedValue);
                }
            }
            return row;
        }
        catch (ClassCastException e) {
            this.throwMappingClassCastException(row, dbmeta, mapping, selectedValue, e);
            return null;
        }
        catch (SQLException e) {
            if (_log.isDebugEnabled()) {
                String msg = "Failed to get selected values while resultSet handling:";
                msg = msg + " target=" + DfTypeUtil.toClassTitle(beanClass) + "." + propertyName;
                _log.debug(msg);
            }
            throw e;
        }
    }

    protected void reflectConditionBeanOptionToEntity(ConditionBean cb, Entity entity) {
        if (cb != null && cb.isUndefinedClassificationSelectAllowed()) {
            entity.myunlockUndefinedClassificationAccess();
        }
    }

    protected boolean canHandleDerivedMap(Object row) {
        return row instanceof DerivedMappable && ConditionBeanContext.isExistConditionBeanOnThread();
    }

    protected void processDerivedMap(ResultSet rs, Map<String, Map<String, Integer>> selectIndexMap, Map<String, TnPropertyMapping> propertyCache, Object row) throws SQLException {
        ConditionBean cb = ConditionBeanContext.getConditionBeanOnThread();
        SqlClause sqlClause = cb.getSqlClause();
        if (!sqlClause.hasSpecifiedDerivingSubQuery()) {
            return;
        }
        DerivedMappable mappable = (DerivedMappable)row;
        List<String> derivingAliasList = sqlClause.getSpecifiedDerivingAliasList();
        DerivedTypeHandler typeHandler = null;
        for (String derivingAlias : derivingAliasList) {
            if (propertyCache.containsKey(derivingAlias) || !derivingAlias.startsWith(DERIVED_MAPPABLE_ALIAS_PREFIX)) continue;
            if (typeHandler == null && (typeHandler = cb.xgetDerivedTypeHandler()) == null) {
                String msg = "Not found the type handler from condition-bean: " + cb.asTableDbName();
                throw new IllegalStateException(msg);
            }
            HpDerivingSubQueryInfo derivingInfo = sqlClause.getSpecifiedDerivingInfo(derivingAlias);
            ValueType valueType = TnValueTypes.getValueType(typeHandler.findMappingType(derivingInfo));
            String onQueryAlias = Srl.substringFirstRear(derivingAlias, DERIVED_MAPPABLE_ALIAS_PREFIX);
            Object selectedValue = this.getValue(rs, onQueryAlias, valueType, selectIndexMap);
            selectedValue = typeHandler.convertToMapValue(derivingInfo, selectedValue);
            mappable.registerDerivedValue(derivingAlias, selectedValue);
        }
    }

    protected Object getValue(ResultSet rs, String columnName, ValueType valueType, Map<String, Map<String, Integer>> selectIndexMap) throws SQLException {
        Object value = selectIndexMap != null ? ResourceContext.getLocalValue(rs, columnName, valueType, selectIndexMap) : valueType.getValue(rs, columnName);
        return value;
    }

    protected void throwMappingClassCastException(Object entity, DBMeta dbmeta, TnPropertyMapping mapping, Object selectedValue, ClassCastException e) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("Failed to cast a class while data mapping.");
        br.addItem("Advice");
        br.addElement("If you use Seasar(S2Container), this exception may be");
        br.addElement("from ClassLoader Headache about HotDeploy.");
        br.addElement("Add the ignore-package setting to convention.dicon like this:");
        br.addElement("    <initMethod name=\u201daddIgnorePackageName\u201d>");
        br.addElement("        <arg>\u201dcom.example.xxx.dbflute\u201d</arg>");
        br.addElement("    </initMethod>");
        br.addElement("If you use an other DI container, this exception may be");
        br.addElement("from illegal state about your settings of DBFlute.");
        br.addElement("Confirm your settings: for example, typeMappingMap.dfprop.");
        br.addItem("Exception Message");
        br.addElement(e.getMessage());
        br.addItem("Target Entity");
        br.addElement(entity);
        br.addElement("classLoader: " + entity.getClass().getClassLoader());
        br.addItem("Target DBMeta");
        br.addElement(dbmeta);
        br.addElement("classLoader: " + dbmeta.getClass().getClassLoader());
        br.addItem("Property Mapping");
        br.addElement(mapping);
        br.addElement("type: " + (mapping != null ? mapping.getClass() : null));
        br.addItem("Selected Value");
        br.addElement(selectedValue);
        br.addElement("type: " + (selectedValue != null ? selectedValue.getClass() : null));
        String msg = br.buildExceptionMessage();
        throw new MappingClassCastException(msg, e);
    }

    public static DBMeta findCachedDBMeta(Object row) {
        return DBMetaCacheHandler.findDBMeta(row);
    }

    public static DBMeta findCachedDBMeta(Class<?> rowType, String tableName) {
        return DBMetaCacheHandler.findDBMeta(rowType, tableName);
    }

    public static void adjustCreatedRow(Object row, boolean checkNonSp, boolean colNullObj, TnBeanMetaData basePointBmd, ConditionBean cb) {
        if (row instanceof Entity) {
            Entity entity = (Entity)row;
            if (checkNonSp) {
                entity.modifiedToSpecified();
                if (colNullObj && cb != null) {
                    SqlClause sqlClause = cb.getSqlClause();
                    for (ColumnInfo columnInfo : sqlClause.getLocalSpecifiedNullObjectColumnSet()) {
                        entity.myspecifyProperty(columnInfo.getPropertyName());
                    }
                }
            }
            if (colNullObj && entity instanceof ColumnNullObjectable) {
                ((ColumnNullObjectable)((Object)entity)).enableColumnNullObject();
            }
            entity.clearModifiedInfo();
            entity.markAsSelect();
        } else {
            basePointBmd.getModifiedPropertyNames(row).clear();
        }
    }

    protected String ln() {
        return DBFluteSystem.ln();
    }

    public void setFixedDBMeta(DBMeta fixedDBMeta) {
        this._fixedDBMeta = fixedDBMeta;
    }

    public void setCreatableByDBMeta(boolean creatableByDBMeta) {
        this._creatableByDBMeta = creatableByDBMeta;
    }

    protected static class DBMetaCacheHandler {
        protected static final String DBMETA_CACHE_KEY = "df:DBMetaCache";

        protected DBMetaCacheHandler() {
        }

        public static DBMeta findDBMeta(Object row) {
            if (!(row instanceof Entity)) {
                return null;
            }
            Entity entity = (Entity)row;
            DBMeta dbmeta = DBMetaCacheHandler.getCachedDBMeta(entity.getClass());
            if (dbmeta != null) {
                return dbmeta;
            }
            dbmeta = entity.asDBMeta();
            DBMetaCacheHandler.cacheDBMeta(entity, dbmeta);
            return dbmeta;
        }

        public static DBMeta findDBMeta(Class<?> rowType, String tableName) {
            DBMeta dbmeta = DBMetaCacheHandler.getCachedDBMeta(rowType);
            if (dbmeta != null) {
                return dbmeta;
            }
            dbmeta = ResourceContext.provideDBMeta(tableName);
            DBMetaCacheHandler.cacheDBMeta(rowType, dbmeta);
            return dbmeta;
        }

        protected static DBMeta getCachedDBMeta(Class<?> rowType) {
            Map<Class<?>, DBMeta> contextCacheMap = DBMetaCacheHandler.getDBMetaContextCacheMap();
            if (contextCacheMap == null) {
                contextCacheMap = new HashMap();
                InternalMapContext.setObject("df:DBMetaCache", contextCacheMap);
            }
            return contextCacheMap.get(rowType);
        }

        protected static void cacheDBMeta(Entity entity, DBMeta dbmeta) {
            DBMetaCacheHandler.cacheDBMeta(entity.getClass(), dbmeta);
        }

        protected static void cacheDBMeta(Class<?> type, DBMeta dbmeta) {
            Map<Class<?>, DBMeta> dbmetaCache = DBMetaCacheHandler.getDBMetaContextCacheMap();
            dbmetaCache.put(type, dbmeta);
        }

        protected static Map<Class<?>, DBMeta> getDBMetaContextCacheMap() {
            return (Map)InternalMapContext.getObject("df:DBMetaCache");
        }
    }
}

