/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.s2dao.sqlhandler;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import javax.sql.DataSource;
import org.dbflute.bhv.exception.SQLExceptionResource;
import org.dbflute.jdbc.FetchBean;
import org.dbflute.jdbc.StatementFactory;
import org.dbflute.jdbc.ValueType;
import org.dbflute.s2dao.jdbc.TnFetchAssistResultSet;
import org.dbflute.s2dao.jdbc.TnResultSetHandler;
import org.dbflute.s2dao.metadata.TnProcedureMetaData;
import org.dbflute.s2dao.metadata.TnProcedureParameterType;
import org.dbflute.s2dao.sqlhandler.TnAbstractBasicSqlHandler;

public class TnProcedureHandler
extends TnAbstractBasicSqlHandler {
    private TnProcedureMetaData _procedureMetaData;
    private TnProcedureResultSetHandlerProvider _resultSetHandlerProvider;

    public TnProcedureHandler(DataSource dataSource, StatementFactory statementFactory, String sql, TnProcedureMetaData procedureMetaData, TnProcedureResultSetHandlerProvider resultSetHandlerProvider) {
        super(dataSource, statementFactory, sql);
        this.assertObjectNotNull("procedureMetaData", procedureMetaData);
        this.assertObjectNotNull("resultSetHandlerProvider", resultSetHandlerProvider);
        this._procedureMetaData = procedureMetaData;
        this._resultSetHandlerProvider = resultSetHandlerProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object execute(Object[] args) {
        Object object;
        Class<?>[] argTypes = this.getArgTypes(args);
        Object pmb = this.getParameterBean(args);
        this.logSql(args, argTypes);
        Connection conn = null;
        CallableStatement cs = null;
        try {
            conn = this.getConnection();
            cs = this.prepareCall(conn);
            this.bindArgs(conn, cs, pmb);
            boolean executed = this.executeProcedure(cs);
            this.handleNotParamResult(conn, cs, pmb, executed);
            this.handleOutParameter(conn, cs, pmb, executed);
            object = pmb;
        }
        catch (SQLException e) {
            Object var8_10;
            try {
                SQLExceptionResource resource = this.createSQLExceptionResource();
                resource.setNotice("Failed to execute the procedure.");
                resource.enableUniqueConstraintHandling();
                this.handleSQLException(e, resource);
                var8_10 = null;
            }
            catch (Throwable throwable) {
                this.close(cs);
                this.close(conn);
                throw throwable;
            }
            this.close(cs);
            this.close(conn);
            return var8_10;
        }
        this.close(cs);
        this.close(conn);
        return object;
    }

    protected Object getParameterBean(Object[] args) {
        if (args.length == 0) {
            return null;
        }
        if (args.length == 1) {
            if (args[0] == null) {
                throw new IllegalStateException("args[0] should not be null!");
            }
            return args[0];
        }
        throw new IllegalStateException("The size of args should be 1: " + args.length);
    }

    protected void bindArgs(Connection conn, CallableStatement cs, Object dto) throws SQLException {
        if (dto == null) {
            return;
        }
        int i = 0;
        for (TnProcedureParameterType ppt : this._procedureMetaData.getBindParameterTypeList()) {
            ValueType valueType = ppt.getValueType();
            int bindIndex = i + 1;
            if (ppt.isOutType()) {
                valueType.registerOutParameter(conn, cs, bindIndex);
            }
            if (ppt.isInType()) {
                Object value = ppt.getValue(dto);
                valueType.bindValue(conn, (PreparedStatement)cs, bindIndex, value);
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleNotParamResult(Connection conn, CallableStatement cs, Object pmb, boolean executed) throws SQLException {
        if (pmb == null) {
            return;
        }
        if (!executed && !cs.getMoreResults()) {
            return;
        }
        List<TnProcedureParameterType> resultList = this._procedureMetaData.getNotParamResultTypeList();
        ResultSet rs = null;
        for (TnProcedureParameterType ppt : resultList) {
            try {
                rs = cs.getResultSet();
                if (rs == null) break;
                rs = this.wrapResultSetIfNeeds(pmb, rs);
                TnResultSetHandler handler = this.createResultSetHandler(pmb, ppt);
                Object beanList = handler.handle(rs);
                ppt.setValue(pmb, beanList);
                if (cs.getMoreResults()) continue;
                break;
            }
            finally {
                if (rs == null) continue;
                rs.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleOutParameter(Connection conn, CallableStatement cs, Object pmb, boolean executed) throws SQLException {
        if (pmb == null) {
            return;
        }
        int index = 0;
        for (TnProcedureParameterType ppt : this._procedureMetaData.getBindParameterTypeList()) {
            ValueType valueType = ppt.getValueType();
            if (ppt.isOutType()) {
                Object value = valueType.getValue(cs, index + 1);
                if (value instanceof ResultSet) {
                    ResultSet rs = this.wrapResultSetIfNeeds(pmb, (ResultSet)value);
                    TnResultSetHandler handler = this.createResultSetHandler(pmb, ppt);
                    try {
                        value = handler.handle(rs);
                    }
                    finally {
                        if (rs != null) {
                            rs.close();
                        }
                    }
                }
                ppt.setValue(pmb, value);
            }
            ++index;
        }
    }

    @Override
    protected String buildDisplaySql(String sql, Object[] args) {
        if (args == null) {
            return sql;
        }
        Object dto = this.getParameterBean(args);
        if (dto == null) {
            return sql;
        }
        StringBuilder sb = new StringBuilder(100);
        int pos = 0;
        int pos2 = 0;
        for (TnProcedureParameterType ppt : this._procedureMetaData.getBindParameterTypeList()) {
            pos2 = sql.indexOf(63, pos);
            if (pos2 < 0) break;
            sb.append(sql.substring(pos, pos2));
            pos = pos2 + 1;
            if (ppt.isInType()) {
                sb.append(this.getBindVariableText(ppt.getValue(dto)));
                continue;
            }
            sb.append(sql.substring(pos2, pos));
        }
        sb.append(sql.substring(pos));
        return sb.toString();
    }

    protected TnResultSetHandler createResultSetHandler(Object pmb, TnProcedureParameterType ppt) {
        return this._resultSetHandlerProvider.provideResultSetHandler(ppt);
    }

    protected ResultSet wrapResultSetIfNeeds(Object pmb, ResultSet rs) {
        FetchBean fcbean;
        int safetyMaxResultSize;
        if (pmb instanceof FetchBean && (safetyMaxResultSize = (fcbean = (FetchBean)pmb).getSafetyMaxResultSize()) > 0) {
            return new TnFetchAssistResultSet(rs, fcbean, false, false);
        }
        return rs;
    }

    public static interface TnProcedureResultSetHandlerProvider {
        public TnResultSetHandler provideResultSetHandler(TnProcedureParameterType var1);
    }
}

