/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.bhv.core.command;

import org.dbflute.bhv.core.SqlExecution;
import org.dbflute.bhv.core.SqlExecutionCreator;
import org.dbflute.bhv.core.command.AbstractOutsideSqlCommand;
import org.dbflute.outsidesql.OutsideSqlContext;
import org.dbflute.outsidesql.OutsideSqlOption;
import org.dbflute.s2dao.jdbc.TnResultSetHandler;
import org.dbflute.s2dao.metadata.TnBeanMetaData;
import org.dbflute.s2dao.metadata.TnProcedureMetaData;
import org.dbflute.s2dao.metadata.TnProcedureMetaDataFactory;
import org.dbflute.s2dao.rshandler.TnMapListResultSetHandler;
import org.dbflute.s2dao.sqlcommand.TnProcedureCommand;

public class OutsideSqlCallCommand
extends AbstractOutsideSqlCommand<Void> {
    @Override
    public String getCommandName() {
        return "call";
    }

    @Override
    public Class<?> getCommandReturnType() {
        return Void.TYPE;
    }

    @Override
    public boolean isProcedure() {
        return true;
    }

    @Override
    public boolean isSelect() {
        return false;
    }

    @Override
    public void beforeGettingSqlExecution() {
        this.assertStatus("beforeGettingSqlExecution");
        OutsideSqlContext.setOutsideSqlContextOnThread(this.createOutsideSqlContext());
    }

    @Override
    public void afterExecuting() {
    }

    @Override
    protected Class<?> getResultType() {
        return this.getCommandReturnType();
    }

    @Override
    public String buildSqlExecutionKey() {
        this.assertStatus("buildSqlExecutionKey");
        return this.generateSpecifiedOutsideSqlUniqueKey();
    }

    protected String generateSpecifiedOutsideSqlUniqueKey() {
        String methodName = this.getCommandName();
        String path = this._outsideSqlPath;
        Object pmb = this._parameterBean;
        OutsideSqlOption option = this._outsideSqlOption;
        return OutsideSqlContext.generateSpecifiedOutsideSqlUniqueKey(methodName, path, pmb, option, null);
    }

    @Override
    public SqlExecutionCreator createSqlExecutionCreator() {
        this.assertStatus("createSqlExecutionCreator");
        return new SqlExecutionCreator(){

            @Override
            public SqlExecution createSqlExecution() {
                OutsideSqlContext outsideSqlContext = OutsideSqlContext.getOutsideSqlContextOnThread();
                return OutsideSqlCallCommand.this.createOutsideSqlProcedureExecution(outsideSqlContext);
            }
        };
    }

    protected SqlExecution createOutsideSqlProcedureExecution(OutsideSqlContext outsideSqlContext) {
        Object pmb = outsideSqlContext.getParameterBean();
        String procedureName = outsideSqlContext.getOutsideSqlPath();
        TnProcedureMetaDataFactory factory = this.createProcedureMetaDataFactory();
        Class<?> pmbType = pmb != null ? pmb.getClass() : null;
        TnProcedureMetaData metaData = factory.createProcedureMetaData(procedureName, pmbType);
        return this.createProcedureCommand(metaData);
    }

    protected TnProcedureMetaDataFactory createProcedureMetaDataFactory() {
        return new TnProcedureMetaDataFactory();
    }

    protected TnProcedureCommand createProcedureCommand(TnProcedureMetaData metaData) {
        TnProcedureCommand.TnProcedureResultSetHandlerFactory factory = this.createProcedureResultSetHandlerFactory();
        TnProcedureCommand cmd = this.newProcedureCommand(metaData, factory);
        cmd.setOutsideSqlFilter(this._outsideSqlFilter);
        return cmd;
    }

    protected TnProcedureCommand newProcedureCommand(TnProcedureMetaData metaData, TnProcedureCommand.TnProcedureResultSetHandlerFactory factory) {
        return new TnProcedureCommand(this._dataSource, this._statementFactory, metaData, factory);
    }

    protected TnProcedureCommand.TnProcedureResultSetHandlerFactory createProcedureResultSetHandlerFactory() {
        return new TnProcedureCommand.TnProcedureResultSetHandlerFactory(){

            @Override
            public TnResultSetHandler createBeanHandler(Class<?> beanClass) {
                TnBeanMetaData beanMetaData = OutsideSqlCallCommand.this._beanMetaDataFactory.createBeanMetaData(beanClass);
                return OutsideSqlCallCommand.this.createBeanListResultSetHandler(beanMetaData);
            }

            @Override
            public TnResultSetHandler createMapHandler() {
                return new TnMapListResultSetHandler();
            }
        };
    }

    @Override
    public Object[] getSqlExecutionArgument() {
        return new Object[]{this._parameterBean};
    }

    protected void assertStatus(String methodName) {
        this.assertBasicProperty(methodName);
        this.assertComponentProperty(methodName);
        this.assertOutsideSqlBasic(methodName);
        if (this._parameterBean == null) {
            String msg = "The property 'parameterBean' should not be null";
            msg = msg + " when you call " + methodName + "().";
            throw new IllegalStateException(msg);
        }
    }
}

