/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.infra.doc.decomment.parts;

import java.time.LocalDateTime;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.dbflute.helper.HandyDate;

public class DfDecoMapPropertyPart {
    protected final String decomment;
    protected final String databaseComment;
    protected final Long commentVersion;
    protected final List<String> authorList;
    protected final String pieceCode;
    protected final LocalDateTime pieceDatetime;
    protected final String pieceOwner;
    protected final String pieceGitBranch;
    protected final List<String> previousPieceList;

    public DfDecoMapPropertyPart(String decomment, String databaseComment, long commentVersion, List<String> authorList, String pieceCode, LocalDateTime pieceDatetime, String pieceOwner, String pieceGitBranch, List<String> previousPieceList) {
        this.decomment = decomment;
        this.databaseComment = databaseComment;
        this.commentVersion = commentVersion;
        this.authorList = authorList;
        this.pieceCode = pieceCode;
        this.pieceDatetime = pieceDatetime;
        this.pieceOwner = pieceOwner;
        this.pieceGitBranch = pieceGitBranch;
        this.previousPieceList = previousPieceList;
    }

    public DfDecoMapPropertyPart(Map<String, Object> propertyMap) {
        this.decomment = (String)propertyMap.get("decomment");
        this.databaseComment = (String)propertyMap.get("databaseComment");
        this.commentVersion = Long.valueOf((String)propertyMap.get("commentVersion"));
        this.authorList = ((List)propertyMap.get("authorList")).stream().map(obj -> (String)obj).collect(Collectors.toList());
        this.pieceCode = (String)propertyMap.get("pieceCode");
        this.pieceDatetime = new HandyDate((String)propertyMap.get("pieceDatetime")).getLocalDateTime();
        this.pieceOwner = (String)propertyMap.get("pieceOwner");
        this.pieceGitBranch = (String)propertyMap.get("pieceGitBranch");
        this.previousPieceList = ((List)propertyMap.get("previousPieceList")).stream().map(obj -> (String)obj).collect(Collectors.toList());
    }

    public String getDecomment() {
        return this.decomment;
    }

    public String getDatabaseComment() {
        return this.databaseComment;
    }

    public String getPieceCode() {
        return this.pieceCode;
    }

    public LocalDateTime getPieceDatetime() {
        return this.pieceDatetime;
    }

    public String getPieceOwner() {
        return this.pieceOwner;
    }

    public String getPieceGitBranch() {
        return this.pieceGitBranch;
    }

    public List<String> getPreviousPieceList() {
        return Collections.unmodifiableList(this.previousPieceList);
    }

    public Long getCommentVersion() {
        return this.commentVersion;
    }

    public List<String> getAuthorList() {
        return Collections.unmodifiableList(this.authorList);
    }

    public Map<String, Object> convertToMap() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("decomment", this.decomment);
        map.put("databaseComment", this.databaseComment);
        map.put("commentVersion", this.commentVersion);
        map.put("authorList", this.authorList);
        map.put("pieceCode", this.pieceCode);
        map.put("pieceOwner", this.pieceOwner);
        map.put("pieceGitBranch", this.pieceGitBranch);
        map.put("pieceDatetime", this.pieceDatetime);
        map.put("previousPieceList", this.previousPieceList);
        return map;
    }
}

