/*
 * Copyright 2014-2021 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.dbflute.helper.token.line;

/**
 * @author jflute
 */
public class LineTokenizingOption {

    // ===================================================================================
    //                                                                           Attribute
    //                                                                           =========
    protected String _delimiter;
    protected boolean _handleEmtpyAsNull;

    // ===================================================================================
    //                                                                         Easy-to-Use
    //                                                                         ===========
    public LineTokenizingOption delimitateBy(String delimiter) {
        _delimiter = delimiter;
        return this;
    }

    public LineTokenizingOption delimitateByComma() {
        _delimiter = ",";
        return this;
    }

    public LineTokenizingOption delimitateByTab() {
        _delimiter = "\t";
        return this;
    }

    public LineTokenizingOption handleEmtpyAsNull() {
        _handleEmtpyAsNull = true;
        return this;
    }

    // ===================================================================================
    //                                                                            Accessor
    //                                                                            ========
    public String getDelimiter() {
        return _delimiter;
    }

    public boolean isHandleEmtpyAsNull() {
        return _handleEmtpyAsNull;
    }
}