/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.cbean.sqlclause.subquery;

import java.util.List;
import org.dbflute.cbean.cipher.GearedCipherManager;
import org.dbflute.cbean.coption.ScalarConditionOption;
import org.dbflute.cbean.sqlclause.SqlClause;
import org.dbflute.cbean.sqlclause.subquery.AbstractSubQuery;
import org.dbflute.cbean.sqlclause.subquery.SubQueryPath;
import org.dbflute.dbmeta.DBMeta;
import org.dbflute.dbmeta.info.ColumnInfo;
import org.dbflute.dbmeta.name.ColumnRealName;
import org.dbflute.dbmeta.name.ColumnRealNameProvider;
import org.dbflute.dbmeta.name.ColumnSqlName;
import org.dbflute.dbmeta.name.ColumnSqlNameProvider;

public class ScalarCondition
extends AbstractSubQuery {
    protected final String _mainSubQueryIdentity;
    protected final String _operand;
    protected final PartitionByProvider _partitionByProvider;

    public ScalarCondition(SubQueryPath subQueryPath, ColumnRealNameProvider localRealNameProvider, ColumnSqlNameProvider subQuerySqlNameProvider, int subQueryLevel, SqlClause subQuerySqlClause, String subQueryIdentity, DBMeta subQueryDBMeta, GearedCipherManager cipherManager, String mainSubQueryIdentity, String operand, PartitionByProvider partitionByProvider) {
        super(subQueryPath, localRealNameProvider, subQuerySqlNameProvider, subQueryLevel, subQuerySqlClause, subQueryIdentity, subQueryDBMeta, cipherManager);
        this._mainSubQueryIdentity = mainSubQueryIdentity;
        this._operand = operand;
        this._partitionByProvider = partitionByProvider;
    }

    public String buildScalarCondition(String function, ScalarConditionOption option) {
        this.setupOptionAttribute(option);
        String columnDbName = this._subQuerySqlClause.getSpecifiedColumnDbNameAsOne();
        if (columnDbName == null || columnDbName.trim().length() == 0) {
            this.throwScalarConditionInvalidColumnSpecificationException(function);
        }
        ColumnRealName columnRealName = this._localRealNameProvider.provide(columnDbName);
        String subQueryClause = this.buildSubQueryClause(function, option);
        String beginMark = this.resolveSubQueryBeginMark(this._subQueryIdentity) + this.ln();
        String endMark = this.resolveSubQueryEndMark(this._subQueryIdentity);
        String endIndent = "       ";
        ColumnInfo columnInfo = this._subQuerySqlClause.getSpecifiedColumnInfoAsOne();
        String specifiedExp = this.decrypt(columnInfo, columnRealName.toString());
        return specifiedExp + " " + this._operand + " (" + beginMark + subQueryClause + this.ln() + "       " + ") " + endMark;
    }

    protected void setupOptionAttribute(ScalarConditionOption option) {
        ColumnInfo columnInfo = this._subQuerySqlClause.getSpecifiedColumnInfoAsOne();
        if (columnInfo == null) {
            columnInfo = this._subQuerySqlClause.getSpecifiedDerivingColumnInfoAsOne();
        }
        option.xsetTargetColumnInfo(columnInfo);
        option.xjudgeDatabase(this._subQuerySqlClause);
    }

    protected String buildSubQueryClause(String function, ScalarConditionOption option) {
        String subQueryClause;
        String tableAliasName = this.getSubQueryLocalAliasName();
        String derivedColumnDbName = this._subQuerySqlClause.getSpecifiedColumnDbNameAsOne();
        if (derivedColumnDbName == null) {
            this.throwScalarConditionInvalidColumnSpecificationException(function);
        }
        ColumnSqlName derivedColumnSqlName = this.getDerivedColumnSqlName();
        ColumnRealName derivedColumnRealName = this.getDerivedColumnRealName();
        this.assertScalarConditionColumnType(function, derivedColumnDbName);
        ColumnRealName partitionByCorrelatedColumnRealName = null;
        ColumnSqlName partitionByRelatedColumnSqlName = null;
        SqlClause partitionBySqlClause = this._partitionByProvider.provideSqlClause();
        if (partitionBySqlClause != null) {
            String partitionByColumnDbName = partitionBySqlClause.getSpecifiedColumnDbNameAsOne();
            if (partitionByColumnDbName == null) {
                this.throwScalarConditionPartitionByInvalidColumnSpecificationException(function);
            }
            partitionByCorrelatedColumnRealName = this._localRealNameProvider.provide(partitionByColumnDbName);
            partitionByRelatedColumnSqlName = this._subQuerySqlNameProvider.provide(partitionByColumnDbName);
        }
        if (this._subQuerySqlClause.hasUnionQuery()) {
            subQueryClause = this.buildUnionSubQuerySql(function, tableAliasName, derivedColumnSqlName, derivedColumnRealName, partitionByCorrelatedColumnRealName, partitionByRelatedColumnSqlName, option);
        } else {
            String selectClause = "select " + this.buildFunctionPart(function, derivedColumnRealName, option, false);
            String fromWhereClause = this.buildFromWhereClause(selectClause, tableAliasName, partitionByCorrelatedColumnRealName, partitionByRelatedColumnSqlName);
            subQueryClause = selectClause + " " + fromWhereClause;
        }
        return this.resolveSubQueryLevelVariable(subQueryClause);
    }

    protected ColumnSqlName getDerivedColumnSqlName() {
        return this._subQuerySqlClause.getSpecifiedResolvedColumnSqlNameAsOne();
    }

    protected ColumnRealName getDerivedColumnRealName() {
        return this._subQuerySqlClause.getSpecifiedResolvedColumnRealNameAsOne();
    }

    protected String buildFromWhereClause(String selectClause, String tableAliasName, ColumnRealName partitionByCorrelatedColumnRealName, ColumnSqlName partitionByRelatedColumnSqlName) {
        String fromWhereClause = partitionByCorrelatedColumnRealName != null ? this.buildCorrelationFromWhereClause(selectClause, tableAliasName, partitionByCorrelatedColumnRealName, partitionByRelatedColumnSqlName, null) : this.buildPlainFromWhereClause(selectClause, tableAliasName, null);
        return fromWhereClause;
    }

    protected String buildUnionSubQuerySql(String function, String tableAliasName, ColumnSqlName derivedColumnSqlName, ColumnRealName derivedColumnRealName, ColumnRealName partitionByCorrelatedColumnRealName, ColumnSqlName partitionByRelatedColumnSqlName, ScalarConditionOption option) {
        String beginMark = this.resolveSubQueryBeginMark(this._mainSubQueryIdentity) + this.ln();
        String endMark = this.resolveSubQueryEndMark(this._mainSubQueryIdentity);
        String mainSql = this.buildUnionMainPartClause(partitionByRelatedColumnSqlName, tableAliasName, derivedColumnRealName, derivedColumnSqlName);
        String mainAlias = this.buildSubQueryMainAliasName();
        String whereJoinCondition = "";
        if (partitionByRelatedColumnSqlName != null) {
            ColumnRealName relatedColumnRealName = ColumnRealName.create(mainAlias, partitionByRelatedColumnSqlName);
            StringBuilder sb = new StringBuilder();
            sb.append(this.ln()).append(" where ");
            sb.append(relatedColumnRealName).append(" = ").append(partitionByCorrelatedColumnRealName);
            whereJoinCondition = sb.toString();
        }
        ColumnRealName mainDerivedColumnRealName = ColumnRealName.create(mainAlias, derivedColumnSqlName);
        return "select " + this.buildFunctionPart(function, mainDerivedColumnRealName, option, true) + this.ln() + "  from (" + beginMark + mainSql + this.ln() + "       ) " + mainAlias + endMark + whereJoinCondition;
    }

    protected String buildUnionMainPartClause(ColumnSqlName relatedColumnSqlName, String tableAliasName, ColumnRealName derivedColumnRealName, ColumnSqlName derivedColumnSqlName) {
        ColumnSqlName derivedRealSqlName = derivedColumnRealName.getColumnSqlName();
        StringBuilder keySb = new StringBuilder();
        List<ColumnInfo> pkList = this._subQueryDBMeta.getPrimaryInfo().getPrimaryColumnList();
        for (ColumnInfo pk : pkList) {
            ColumnSqlName pkSqlName = pk.getColumnSqlName();
            if (pkSqlName.equals(derivedRealSqlName) || pkSqlName.equals(relatedColumnSqlName)) continue;
            keySb.append(keySb.length() > 0 ? ", " : "");
            keySb.append(ColumnRealName.create(tableAliasName, pk.getColumnSqlName()));
        }
        if (relatedColumnSqlName != null && !relatedColumnSqlName.equals(derivedRealSqlName)) {
            keySb.append(keySb.length() > 0 ? ", " : "");
            keySb.append(ColumnRealName.create(tableAliasName, relatedColumnSqlName));
        }
        this.setupUnionMainForDerivedColumn(keySb, derivedColumnRealName, derivedColumnSqlName, derivedRealSqlName);
        return this.completeUnionMainWholeClause(tableAliasName, keySb);
    }

    protected void setupUnionMainForDerivedColumn(StringBuilder keySb, ColumnRealName derivedColumnRealName, ColumnSqlName derivedColumnSqlName, ColumnSqlName derivedRealSqlName) {
        if (this.mightBeSubQueryOrCalculation(derivedRealSqlName)) {
            if (!this.isNestedDerivedReferrer(derivedRealSqlName)) {
                keySb.append(keySb.length() > 0 ? ", " : "");
                String realNameExp = derivedColumnRealName.toString();
                String locationResolved = this._subQueryPath.resolveParameterLocationPath(realNameExp);
                keySb.append(locationResolved).append(" as ").append(derivedColumnSqlName);
            }
        } else {
            keySb.append(keySb.length() > 0 ? ", " : "");
            keySb.append(derivedColumnRealName);
        }
    }

    protected boolean mightBeSubQueryOrCalculation(ColumnSqlName derivedRealSqlName) {
        String exp = derivedRealSqlName.toString();
        return exp.contains(" ") || exp.contains("(");
    }

    protected String completeUnionMainWholeClause(String tableAliasName, StringBuilder keySb) {
        String selectClause = "select " + keySb.toString();
        String fromWhereClause = this.buildPlainFromWhereClause(selectClause, tableAliasName, null);
        return selectClause + " " + fromWhereClause;
    }

    protected String buildFunctionPart(String function, ColumnRealName columnRealName, ScalarConditionOption option, boolean union) {
        String columnWithEndExp;
        String aliasDef = this.getDerivedReferrerNestedAliasDef();
        ColumnSqlName columnSqlName = columnRealName.getColumnSqlName();
        if (this.isNestedDerivedReferrer(columnSqlName)) {
            String sqlNameExp = columnSqlName.toString();
            String localtionResolved = this._subQueryPath.resolveParameterLocationPath(sqlNameExp);
            String aliasResolved = this.resolveNestedDerivedReferrerAliasDef(localtionResolved, aliasDef);
            columnWithEndExp = union ? this.resolveUnionCorrelation(aliasResolved) : aliasResolved;
        } else {
            ColumnInfo derivedColumnInfo = this._subQuerySqlClause.getSpecifiedColumnInfoAsOne();
            String localtionResolved = this._subQueryPath.resolveParameterLocationPath(columnRealName.toString());
            columnWithEndExp = this.decrypt(derivedColumnInfo, localtionResolved) + ")";
        }
        return option.filterFunction(function + "(" + columnWithEndExp);
    }

    protected String resolveNestedDerivedReferrerAliasDef(String derivedExp, String aliasDef) {
        return this.replace(derivedExp, aliasDef, ")");
    }

    protected String resolveUnionCorrelation(String derivedExp) {
        String basePointAlias = this._subQuerySqlClause.getBasePointAliasName();
        String mainAlias = this.buildSubQueryMainAliasName();
        return this.replace(derivedExp, basePointAlias, mainAlias);
    }

    protected boolean isNestedDerivedReferrer(String name) {
        return name.contains(this.getDerivedReferrerNestedAliasDef());
    }

    protected boolean isNestedDerivedReferrer(ColumnSqlName name) {
        return name.toString().contains(this.getDerivedReferrerNestedAliasDef());
    }

    protected String getDerivedReferrerNestedAliasDef() {
        return " as " + this.getDerivedReferrerNestedAlias();
    }

    protected String getDerivedReferrerNestedAlias() {
        return this._subQuerySqlClause.getDerivedReferrerNestedAlias();
    }

    protected void throwScalarConditionInvalidColumnSpecificationException(String function) {
        this.createCBExThrower().throwScalarConditionInvalidColumnSpecificationException(function);
    }

    protected void throwScalarConditionPartitionByInvalidColumnSpecificationException(String function) {
        this.createCBExThrower().throwScalarConditionPartitionByInvalidColumnSpecificationException(function);
    }

    protected void assertScalarConditionColumnType(String function, String derivedColumnDbName) {
        if ("sum".equalsIgnoreCase(function) || "avg".equalsIgnoreCase(function)) {
            ColumnInfo columnInfo = this._subQueryDBMeta.findColumnInfo(derivedColumnDbName);
            Class<?> deriveColumnType = columnInfo.getObjectNativeType();
            if (!columnInfo.isObjectNativeTypeNumber()) {
                this.throwScalarConditionUnmatchedColumnTypeException(function, derivedColumnDbName, deriveColumnType);
            }
        }
    }

    protected void throwScalarConditionUnmatchedColumnTypeException(String function, String derivedColumnDbName, Class<?> derivedColumnType) {
        this.createCBExThrower().throwScalarConditionUnmatchedColumnTypeException(function, derivedColumnDbName, derivedColumnType);
    }

    public static interface PartitionByProvider {
        public SqlClause provideSqlClause();
    }
}

