/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.system;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XLog {
    private static final Logger _log = LoggerFactory.getLogger(XLog.class);
    protected static boolean _executeStatusLogLevelInfo;
    protected static boolean _loggingInHolidayMood;
    protected static boolean _locked;

    public static void log(String msg) {
        if (_executeStatusLogLevelInfo) {
            _log.info(msg);
        } else {
            _log.debug(msg);
        }
    }

    public static boolean isLogEnabled() {
        if (_loggingInHolidayMood) {
            return false;
        }
        if (_executeStatusLogLevelInfo) {
            return _log.isInfoEnabled();
        }
        return _log.isDebugEnabled();
    }

    public static boolean isExecuteStatusLogLevelInfo() {
        return _executeStatusLogLevelInfo;
    }

    public static void setExecuteStatusLogLevelInfo(boolean executeStatusLogLevelInfo) {
        XLog.assertUnlocked();
        if (_log.isInfoEnabled()) {
            _log.info("...Setting executeStatusLogLevelInfo: " + executeStatusLogLevelInfo);
        }
        _executeStatusLogLevelInfo = executeStatusLogLevelInfo;
        XLog.lock();
    }

    protected static boolean isLoggingInHolidayMood() {
        return _loggingInHolidayMood;
    }

    public static void setLoggingInHolidayMood(boolean loggingInHolidayMood) {
        XLog.assertUnlocked();
        if (_log.isInfoEnabled()) {
            _log.info("...Setting loggingInHolidayMood: " + loggingInHolidayMood);
        }
        _loggingInHolidayMood = loggingInHolidayMood;
        XLog.lock();
    }

    public static boolean isLocked() {
        return _locked;
    }

    public static void lock() {
        if (_locked) {
            return;
        }
        if (_log.isInfoEnabled()) {
            _log.info("...Locking the log object for execute status!");
        }
        _locked = true;
    }

    public static void unlock() {
        if (!_locked) {
            return;
        }
        if (_log.isInfoEnabled()) {
            _log.info("...Unlocking the log object for execute status!");
        }
        _locked = false;
    }

    protected static void assertUnlocked() {
        if (!XLog.isLocked()) {
            return;
        }
        throw new IllegalStateException("The execute-status log is locked.");
    }

    static {
        _locked = true;
    }
}

